/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalEntityDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class EjbBundleDescriptor
extends BundleDescriptor {
    public static final String EJB_2_x_VERSION = "EJB 2.x";
    public static final String EJB_1_x_VERSION = "EJB 1.x";
    private int uniqueId;
    private Set ejbs = new HashSet();
    private Set relationships = new HashSet();
    private Set remoteEntities = new HashSet();
    private String relationshipsDescription;
    private String ejbClientJarUri;
    private String ejbVersion = "EJB 2.x";
    private ResourceReferenceDescriptor cmpResourceReference;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbBundleDescriptor == null ? (class$com$sun$enterprise$deployment$EjbBundleDescriptor = EjbBundleDescriptor.class$("com.sun.enterprise.deployment.EjbBundleDescriptor")) : class$com$sun$enterprise$deployment$EjbBundleDescriptor);
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbBundleDescriptor;

    public boolean isEJB20() {
        return this.ejbVersion.equals(EJB_2_x_VERSION);
    }

    public boolean isEJB11() {
        return this.ejbVersion.equals(EJB_1_x_VERSION);
    }

    public void setEJBVersion(String version) {
        if (!this.ejbVersion.equals(EJB_1_x_VERSION) && !this.ejbVersion.equals(EJB_2_x_VERSION)) {
            throw new IllegalArgumentException("Illegal ejb version : " + version);
        }
        this.ejbVersion = version;
    }

    public String getEjbClientJarUri() {
        if (this.ejbClientJarUri == null) {
            this.ejbClientJarUri = "";
        }
        return this.ejbClientJarUri;
    }

    public void setEjbClientJarUri(String ejbClientJarUri) {
        this.ejbClientJarUri = ejbClientJarUri;
        this.changed();
    }

    public void addEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        super.addBundleDescriptor(ejbBundleDescriptor);
        Iterator ejbs = ejbBundleDescriptor.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            ejbDescriptor.setEjbBundleDescriptor(this);
            this.getEjbs().add(ejbDescriptor);
        }
        this.changed();
    }

    public void classesChanged() {
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            ejbDescriptor.classesChanged();
        }
    }

    protected Archivist getDefaultArchivist() {
        return new EjbBundleArchivist(false, "", this, new HashSet());
    }

    public Collection getNamedDescriptors() {
        Vector<EjbDescriptor> namedDescriptors = new Vector<EjbDescriptor>();
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            namedDescriptors.add(ejbDescriptor);
            namedDescriptors.addAll(super.getNamedDescriptorsFrom(ejbDescriptor));
        }
        return namedDescriptors;
    }

    public Vector getNamedReferencePairs() {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            pairs.add(NamedReferencePair.createEjbPair(ejbDescriptor, ejbDescriptor));
            pairs.addAll(super.getNamedReferencePairsFrom(ejbDescriptor));
        }
        return pairs;
    }

    public Set getResourceReferenceDescriptors() {
        HashSet resourceReferences = new HashSet();
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            resourceReferences.addAll(ejbDescriptor.getResourceReferenceDescriptors());
        }
        return resourceReferences;
    }

    public boolean hasEjbReferences() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getEjbReferenceDescriptors().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set getEjbs() {
        if (this.ejbs == null) {
            this.ejbs = new HashSet();
        }
        return this.ejbs;
    }

    public boolean hasEjbByName(String name) {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public EjbDescriptor getEjbByName(String name) {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return (EjbDescriptor)next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanbundle", "Referencing error: this bundle has no bean of name: {0}", new Object[]{name}));
    }

    public void addEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(ejbDescriptor);
        super.changed();
    }

    public void removeEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(ejbDescriptor);
        super.changed();
    }

    void replaceEjb(EjbDescriptor oldEjbDescriptor, EjbDescriptor newEjbDescriptor) {
        oldEjbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(oldEjbDescriptor);
        newEjbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(newEjbDescriptor);
    }

    public boolean areResourceReferencesValid() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            Iterator roleRefs = ejbDescriptor.getRoleReferences().iterator();
            while (roleRefs.hasNext()) {
                RoleReference roleReference = (RoleReference)roleRefs.next();
                Role referredRole = roleReference.getRole();
                if (referredRole.getName().equals("") || super.getRoles().contains(referredRole)) continue;
                System.out.println(localStrings.getLocalString("enterprise.deployment.badrolereference", "Warning: Bad role reference to {0}", new Object[]{referredRole}));
                System.out.println(this.getRoles());
                return false;
            }
        }
        return true;
    }

    public void removeRole(Role role) {
        if (super.getRoles().contains(role)) {
            Iterator itr = this.getEjbs().iterator();
            while (itr.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
                ejbDescriptor.removeRole(role);
            }
            super.removeRole(role);
        }
    }

    public boolean hasPermissionedRoles() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getPermissionedMethodsByPermission().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasContainerTransactions() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getMethodContainerTransactions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAssemblyInformation() {
        return !this.getRoles().isEmpty() || this.hasPermissionedRoles() || this.hasContainerTransactions();
    }

    public void addRelationship(RelationshipDescriptor relDesc) {
        this.relationships.add(relDesc);
        super.changed();
    }

    public void removeRelationship(RelationshipDescriptor relDesc) {
        this.relationships.remove(relDesc);
        super.changed();
    }

    public String getRelationshipsDescription() {
        if (this.relationshipsDescription == null) {
            this.relationshipsDescription = "";
        }
        return this.relationshipsDescription;
    }

    public void setRelationshipsDescription(String relationshipsDescription) {
        this.relationshipsDescription = relationshipsDescription;
    }

    public Set getRelationships() {
        return this.relationships;
    }

    public boolean hasRelationships() {
        return this.relationships.size() > 0;
    }

    public boolean hasRelationship(RelationshipDescriptor rd) {
        return this.relationships.contains(rd);
    }

    public void addRemoteEntity(EjbExternalEntityDescriptor dd2) {
        this.remoteEntities.add(dd2);
        dd2.setEjbBundleDescriptor(this);
    }

    public Set getRemoteEntities() {
        return this.remoteEntities;
    }

    public ResourceReferenceDescriptor getCMPResourceReference() {
        return this.cmpResourceReference;
    }

    public void setCMPResourceReference(ResourceReferenceDescriptor resourceReference) {
        this.cmpResourceReference = resourceReference;
        this.changed();
    }

    /*
     * Unable to fully structure code
     */
    public Descriptor getDescriptorByName(String name) {
        try {
            d = this.getEjbByName(name);
            return d;
        }
        catch (IllegalArgumentException iae) {
            itr = this.remoteEntities.iterator();
            ** while (itr.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
lbl10:
        // 1 sources

        return null;
    }

    public EjbExternalEntityDescriptor getRemoteEntityByName(String name) {
        Iterator itr = this.remoteEntities.iterator();
        while (itr.hasNext()) {
            EjbExternalEntityDescriptor next = (EjbExternalEntityDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public boolean hasRemoteEntityByName(String name) {
        return this.getRemoteEntityByName(name) != null;
    }

    public String getName() {
        if ("".equals(super.getName())) {
            super.setName("Ejb1");
        }
        return super.getName();
    }

    private void doMethodDescriptorConversions() throws Exception {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            ejbDescriptor.doMethodDescriptorConversions();
        }
    }

    public void setUniqueId(int id) {
        this.uniqueId = id;
        EjbDescriptor[] descs = this.ejbs.toArray(new EjbDescriptor[this.ejbs.size()]);
        int i2 = descs.length - 1;
        while (i2 > 0) {
            int j2 = 0;
            while (j2 < i2) {
                if (descs[j2].getName().compareTo(descs[j2 + 1].getName()) > 0) {
                    EjbDescriptor tmp = descs[j2 + 1];
                    descs[j2 + 1] = descs[j2];
                    descs[j2] = tmp;
                }
                ++j2;
            }
            --i2;
        }
        int i3 = 0;
        while (i3 < descs.length) {
            long beanId = this.uniqueId;
            beanId <<= 32;
            descs[i3].setUniqueId(beanId |= (long)i3);
            ++i3;
        }
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public static int getIdFromEjbId(long ejbId) {
        long id = ejbId >> 32;
        return (int)id;
    }

    public String toString() {
        String s2 = "EjbBundleDescriptor";
        s2 = s2 + "\n archivist " + super.getArchivist();
        s2 = s2 + "\n roles " + this.getRoles();
        s2 = s2 + "\nclient JAR " + this.getEjbClientJarUri();
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            s2 = s2 + "\n------------\n";
            s2 = s2 + itr.next();
            s2 = s2 + "\n------------";
        }
        return s2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

