/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.util.Utility;
import java.io.IOException;
import java.util.Properties;

public class EjbIORConfigurationDescriptor {
    public static final String NONE = "none";
    public static final String SUPPORTED = "supported";
    public static final String REQUIRED = "required";
    public static final String USERNAME_PASSWORD = "username_password";
    public static final String DEFAULT_REALM = "default";
    private static final String SECURE_PROPERTIES = "security.properties";
    private String integrity = "supported";
    private String confidentiality = "supported";
    private String establishTrustInTarget = "supported";
    private String establishTrustInClient = "supported";
    private String authenticationMethod = "username_password";
    private String realmName = "default";
    private String callerPropagation = "supported";
    private boolean required = false;

    public EjbIORConfigurationDescriptor() {
        try {
            String authRequired;
            Properties cprops = Utility.getPropertiesFromFile(SECURE_PROPERTIES);
            boolean val = false;
            String sslRequired = cprops.getProperty("interop.ssl.required");
            if (sslRequired != null && !sslRequired.trim().equals("") && (val = new Boolean(sslRequired).booleanValue())) {
                this.integrity = REQUIRED;
                this.confidentiality = REQUIRED;
                this.establishTrustInClient = REQUIRED;
                this.establishTrustInTarget = SUPPORTED;
            }
            if ((authRequired = cprops.getProperty("interop.authRequired.enabled")) != null && !authRequired.trim().equals("") && (val = new Boolean(authRequired).booleanValue())) {
                this.required = true;
                this.authenticationMethod = USERNAME_PASSWORD;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public EjbIORConfigurationDescriptor(boolean enableUsernamePassword) {
        if (enableUsernamePassword) {
            this.required = true;
            this.authenticationMethod = USERNAME_PASSWORD;
        }
    }

    public String getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(String val) {
        if (!(val.equals(NONE) || val.equals(SUPPORTED) || val.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for integrity:" + val);
        }
        this.integrity = val;
    }

    public String getConfidentiality() {
        return this.confidentiality;
    }

    public void setConfidentiality(String val) {
        if (!(val.equals(NONE) || val.equals(SUPPORTED) || val.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for confidentiality:" + val);
        }
        this.confidentiality = val;
    }

    public String getEstablishTrustInTarget() {
        return this.establishTrustInTarget;
    }

    public void setEstablishTrustInTarget(String val) {
        if (!val.equals(NONE) && !val.equals(SUPPORTED)) {
            throw new RuntimeException("Incorrect value for establishTrustInTarget:" + val);
        }
        this.establishTrustInTarget = val;
    }

    public String getEstablishTrustInClient() {
        return this.establishTrustInClient;
    }

    public void setEstablishTrustInClient(String val) {
        if (!(val.equals(NONE) || val.equals(SUPPORTED) || val.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for establishTrustInClient:" + val);
        }
        this.establishTrustInClient = val;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String val) {
        if (!val.equals(USERNAME_PASSWORD) && !val.equals(NONE)) {
            throw new RuntimeException("Incorrect value for authentication method:" + val);
        }
        this.authenticationMethod = val;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String val) {
        this.realmName = val;
    }

    public String getCallerPropagation() {
        return this.callerPropagation;
    }

    public void setCallerPropagation(String val) {
        if (!(val.equals(NONE) || val.equals(SUPPORTED) || val.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for callerPropagation:" + val);
        }
        this.callerPropagation = val;
    }

    public boolean isAuthMethodRequired() {
        return this.required;
    }

    public void setAuthMethodRequired(boolean val) {
        this.required = val;
    }

    public String toString() {
        String s2 = "";
        s2 = s2 + "\n integrity " + this.integrity;
        s2 = s2 + "\n confidentiality " + this.confidentiality;
        s2 = s2 + "\n establishTrustInTarget " + this.establishTrustInTarget;
        s2 = s2 + "\n establishTrustInClient " + this.establishTrustInClient;
        s2 = s2 + "\n callerPropagation " + this.callerPropagation;
        s2 = s2 + "\n realm " + this.realmName;
        s2 = s2 + "\n authenticationMethod " + this.authenticationMethod + "\n";
        return s2;
    }
}

