/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;

public final class EjbMessageBeanDescriptor
extends EjbDescriptor {
    private static final boolean debug = false;
    private static final int UNKNOWN_DEST_TYPE = -1;
    private static final int QUEUE_DEST_TYPE = 1;
    private static final int TOPIC_DEST_TYPE = 2;
    private int jmsAcknowledgeMode = 1;
    public static final String TYPE = "Message-driven";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbMessageBeanDescriptor == null ? (class$com$sun$enterprise$deployment$EjbMessageBeanDescriptor = EjbMessageBeanDescriptor.class$("com.sun.enterprise.deployment.EjbMessageBeanDescriptor")) : class$com$sun$enterprise$deployment$EjbMessageBeanDescriptor);
    private Method onMessageMethod = null;
    private String messageSelector = null;
    private int destinationType = 1;
    private boolean hasDurableSubscription = false;
    private String durableSubscriptionName = null;
    private String connectionFactoryName = null;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbMessageBeanDescriptor;
    static /* synthetic */ Class class$javax$jms$Message;

    public EjbMessageBeanDescriptor() {
        this.setUsesCallerIdentity(false);
    }

    public EjbMessageBeanDescriptor(EjbMessageBeanDescriptor other) {
        super(other);
        this.messageSelector = other.messageSelector;
        this.onMessageMethod = other.onMessageMethod;
        this.jmsAcknowledgeMode = other.jmsAcknowledgeMode;
        this.hasDurableSubscription = other.hasDurableSubscription;
        this.durableSubscriptionName = other.durableSubscriptionName;
        this.destinationType = other.destinationType;
        this.setUsesCallerIdentity(false);
    }

    public String getType() {
        return TYPE;
    }

    public void setContainerTransactionFor(MethodDescriptor methodDescriptor, ContainerTransaction containerTransaction) {
        String transAttr = containerTransaction.getTransactionAttribute();
        if (!transAttr.equals(ContainerTransaction.NOT_SUPPORTED) && !transAttr.equals(ContainerTransaction.REQUIRED)) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.msgbeantxattrnotvalid", "Invalid transaction attribute for message-driven bean"));
        }
        super.setContainerTransactionFor(methodDescriptor, containerTransaction);
    }

    public void setType(String type) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeofmsgdrivenbean", "Cannot set the type of a message-drive bean"));
    }

    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> txAttributes = new Vector<ContainerTransaction>();
        txAttributes.add(new ContainerTransaction(ContainerTransaction.REQUIRED, ""));
        txAttributes.add(new ContainerTransaction(ContainerTransaction.NOT_SUPPORTED, ""));
        return txAttributes;
    }

    public boolean hasQueueDest() {
        return this.destinationType == 1;
    }

    public boolean hasTopicDest() {
        return this.destinationType == 2;
    }

    public boolean hasDurableSubscription() {
        return this.hasDurableSubscription;
    }

    public void setHasDurableSubscription(boolean durable) {
        this.hasDurableSubscription = durable;
        if (!durable) {
            this.durableSubscriptionName = null;
        }
        super.changed();
    }

    public String getDurableSubscriptionName() {
        if (!this.hasDurableSubscription()) {
            throw new RuntimeException("Can't have durable subscription");
        }
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        if (!this.hasDurableSubscription()) {
            throw new RuntimeException("Can't have durable subscription");
        }
        this.durableSubscriptionName = durableSubscriptionName;
        super.changed();
    }

    public void setHasQueueDest() {
        this.destinationType = 1;
        this.hasDurableSubscription = false;
        super.changed();
    }

    public void setHasTopicDest() {
        this.destinationType = 2;
        super.changed();
    }

    public boolean hasJmsMessageSelector() {
        return this.getJmsMessageSelector() != null;
    }

    public void setJmsMessageSelector(String selector) {
        this.messageSelector = selector == null || selector.trim().equals("") ? null : selector;
        super.changed();
    }

    public String getJmsMessageSelector() {
        return this.messageSelector;
    }

    public int getJmsAcknowledgeMode() {
        return this.jmsAcknowledgeMode;
    }

    public void setJmsAcknowledgeMode(int acknowledgeMode) {
        this.jmsAcknowledgeMode = acknowledgeMode;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactory) {
        this.connectionFactoryName = connectionFactory;
    }

    public boolean hasConnectionFactory() {
        return this.connectionFactoryName != null;
    }

    public Vector getMethods(ClassLoader classLoader) {
        return new Vector();
    }

    protected Collection getTransactionMethods(ClassLoader classLoader) {
        Vector<Method> methods = new Vector<Method>();
        if (this.onMessageMethod == null) {
            try {
                Class<?> ejbClass = classLoader.loadClass(this.getEjbClassName());
                Class[] paramTypes = new Class[]{class$javax$jms$Message == null ? (class$javax$jms$Message = EjbMessageBeanDescriptor.class$("javax.jms.Message")) : class$javax$jms$Message};
                this.onMessageMethod = ejbClass.getMethod("onMessage", paramTypes);
            }
            catch (Exception e10) {
                throw new NoSuchMethodError(localStrings.getLocalString("enterprise.deployment.noonmessagemethod", "onMessage is not defined for message-bean ") + this.getName());
            }
        }
        methods.addElement(this.onMessageMethod);
        return methods;
    }

    public void setTransactionType(String transactionType) {
        boolean isValidType;
        boolean bl2 = isValidType = EjbDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType) || EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType);
        if (!isValidType && Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmsgbeantxtypenotlegaltype", "{0} is not a legal transaction type for a message-driven bean", new Object[]{transactionType}));
        }
        this.transactionType = transactionType;
        super.setMethodContainerTransactions(new Hashtable());
        super.changed();
    }

    public String toString() {
        String s2 = super.toString();
        s2 = s2 + "Message-driven descriptor";
        s2 = s2 + "\n " + this.messageSelector;
        return s2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

