/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.WebDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class EnvironmentProperty
extends Descriptor
implements InitializationParameter,
ContextParameter,
WebDescriptor,
EnvironmentEntry {
    private String value;
    private String type;
    private Object valueObject;
    private static Class[] allowedTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnvironmentProperty.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = EnvironmentProperty.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = EnvironmentProperty.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = EnvironmentProperty.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Byte == null ? (class$java$lang$Byte = EnvironmentProperty.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = EnvironmentProperty.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Long == null ? (class$java$lang$Long = EnvironmentProperty.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = EnvironmentProperty.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Character == null ? (class$java$lang$Character = EnvironmentProperty.class$("java.lang.Character")) : class$java$lang$Character};
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EnvironmentProperty == null ? (class$com$sun$enterprise$deployment$EnvironmentProperty = EnvironmentProperty.class$("com.sun.enterprise.deployment.EnvironmentProperty")) : class$com$sun$enterprise$deployment$EnvironmentProperty);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EnvironmentProperty;

    public EnvironmentProperty() {
    }

    public EnvironmentProperty(String name, String value, String description) {
        this(name, value, description, null);
    }

    public EnvironmentProperty(String name, String value, String description, String type) {
        super(name, description);
        this.value = value;
        this.checkType(type);
        this.type = type;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = "";
        }
        return this.value;
    }

    private void checkType(String type) {
        if (type != null) {
            Class<?> typeClass = null;
            try {
                typeClass = Class.forName(type);
            }
            catch (Throwable t2) {
                if (Descriptor.isBoundsChecking()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{type}));
                }
                return;
            }
            boolean allowedType = false;
            int i2 = 0;
            while (i2 < allowedTypes.length) {
                if (allowedTypes[i2].equals(typeClass)) {
                    allowedType = true;
                    break;
                }
                ++i2;
            }
            if (Descriptor.isBoundsChecking() && !allowedType) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedprprtytype", "{0} is not an allowed property value type", new Object[]{type}));
            }
        }
    }

    public Object getValueObject() {
        if (this.valueObject == null) {
            this.valueObject = "";
        }
        return EnvironmentProperty.getObjectFromString(this.getValue(), this.getValueType());
    }

    public Class getValueType() {
        if (this.type == null) {
            return class$java$lang$String == null ? (class$java$lang$String = EnvironmentProperty.class$("java.lang.String")) : class$java$lang$String;
        }
        try {
            return Class.forName(this.type);
        }
        catch (Throwable t2) {
            return null;
        }
    }

    public void setType(String type) {
        this.checkType(type);
        this.type = type;
    }

    public String getType() {
        if (this.type == null && Descriptor.isBoundsChecking()) {
            this.type = (class$java$lang$String == null ? (class$java$lang$String = EnvironmentProperty.class$("java.lang.String")) : class$java$lang$String).getName();
        }
        return this.type;
    }

    public void setValue(String value) {
        this.value = value;
        super.changed();
    }

    public boolean equals(Object other) {
        return other instanceof EnvironmentProperty && this.getName().equals(((EnvironmentProperty)other).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "Env-Prop: " + super.getName() + "@" + this.getType() + "@" + this.getValue() + "@" + super.getDescription();
    }

    private static Object getObjectFromString(String string, Class type) {
        if (string == null || "".equals(string) && !type.equals(class$java$lang$String == null ? (class$java$lang$String = EnvironmentProperty.class$("java.lang.String")) : class$java$lang$String)) {
            return null;
        }
        try {
            if ((class$java$lang$String == null ? (class$java$lang$String = EnvironmentProperty.class$("java.lang.String")) : class$java$lang$String).equals(type)) {
                return string;
            }
            if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = EnvironmentProperty.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(type)) {
                return new Boolean(string);
            }
            if ((class$java$lang$Integer == null ? (class$java$lang$Integer = EnvironmentProperty.class$("java.lang.Integer")) : class$java$lang$Integer).equals(type)) {
                return new Integer(string);
            }
            if ((class$java$lang$Double == null ? (class$java$lang$Double = EnvironmentProperty.class$("java.lang.Double")) : class$java$lang$Double).equals(type)) {
                return new Double(string);
            }
            if ((class$java$lang$Float == null ? (class$java$lang$Float = EnvironmentProperty.class$("java.lang.Float")) : class$java$lang$Float).equals(type)) {
                return new Float(string);
            }
            if ((class$java$lang$Short == null ? (class$java$lang$Short = EnvironmentProperty.class$("java.lang.Short")) : class$java$lang$Short).equals(type)) {
                return new Short(string);
            }
            if ((class$java$lang$Byte == null ? (class$java$lang$Byte = EnvironmentProperty.class$("java.lang.Byte")) : class$java$lang$Byte).equals(type)) {
                return new Byte(string);
            }
            if ((class$java$lang$Long == null ? (class$java$lang$Long = EnvironmentProperty.class$("java.lang.Long")) : class$java$lang$Long).equals(type)) {
                return new Long(string);
            }
            if ((class$java$lang$Character == null ? (class$java$lang$Character = EnvironmentProperty.class$("java.lang.Character")) : class$java$lang$Character).equals(type)) {
                if (string.length() != 1) {
                    throw new IllegalArgumentException();
                }
                return new Character(string.charAt(0));
            }
        }
        catch (Throwable t2) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncouldnotcreateinstancetype", "Could not create instance of {0} from {1}\n reason: {2}" + t2, new Object[]{type, string, t2}));
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionillegaltypeenvproperty", "Illegal type for environment properties: {0}", new Object[]{type}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

