/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class FileContentsDescriptor {
    private static final char ClassSeparatorChar = '.';
    private static final String ArchSeparator = "/";
    private static final char ArchSeparatorChar = '/';
    private static final String FileSeparator = File.separator;
    private static final char FileSeparatorChar = File.separatorChar;
    private Hashtable rawFileDirectoryMap = new Hashtable();
    private Hashtable fileDirectoryMap = new Hashtable();
    private Set libraryJars = new HashSet();

    public FileContentsDescriptor() {
    }

    public FileContentsDescriptor(String baseDirectory, Vector files) {
        File directory = new File(baseDirectory);
        Enumeration e10 = files.elements();
        while (e10.hasMoreElements()) {
            Object next = e10.nextElement();
            if (next instanceof File) {
                this.fileDirectoryMap.put(next, directory);
                continue;
            }
            File nextFile = new File((String)next);
            this.fileDirectoryMap.put(nextFile, directory);
        }
    }

    public FileContentsDescriptor(FileContentsDescriptor fcd) {
        this.addAll(fcd);
    }

    public void addLibraryJar(File libraryJar) {
        this.getLibraryJars().add(new File(libraryJar.getAbsolutePath()));
    }

    public void removeLibraryJar(File libraryJar) {
        this.getLibraryJars().remove(new File(libraryJar.getAbsolutePath()));
    }

    public Set getLibraryJars() {
        if (this.libraryJars == null) {
            this.libraryJars = new HashSet();
        }
        return this.libraryJars;
    }

    public void removeFile(File file) {
        this.fileDirectoryMap.remove(file);
    }

    public void removeEntry(String entry) {
        this.rawFileDirectoryMap.remove(entry);
        this.removeFile(FileContentsDescriptor.FileEntry(entry));
    }

    public void add(File file, File directory) {
        this.fileDirectoryMap.put(file, directory);
    }

    public void addEntry(String entry, File file) {
        this.rawFileDirectoryMap.put(entry, file);
    }

    public void addEntries(Hashtable entries) {
        if (entries != null) {
            this.rawFileDirectoryMap.putAll(entries);
        }
    }

    public void addAll(FileContentsDescriptor fcd) {
        this.addFiles(fcd);
        this.libraryJars.addAll(fcd.libraryJars);
    }

    public void addFiles(FileContentsDescriptor fcd) {
        this.fileDirectoryMap.putAll(fcd.fileDirectoryMap);
        this.rawFileDirectoryMap.putAll(fcd.rawFileDirectoryMap);
    }

    public Enumeration getFiles() {
        return this.fileDirectoryMap.keys();
    }

    public Enumeration getEntries() {
        return this.rawFileDirectoryMap.keys();
    }

    public Set getFilesSet() {
        HashSet<File> s2 = new HashSet<File>();
        Enumeration e10 = this.getFiles();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            s2.add(f2);
        }
        Enumeration e11 = this.getEntries();
        while (e11.hasMoreElements()) {
            String k2 = (String)e11.nextElement();
            s2.add(FileContentsDescriptor.FileEntry(k2));
        }
        return s2;
    }

    public Set getClassNamesSet() {
        HashSet<String> classNamesSet = new HashSet<String>();
        Enumeration e10 = this.getFiles();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            if (!f2.toString().endsWith(".class")) continue;
            classNamesSet.add(FileUtil.classNameFromFile(f2));
        }
        Enumeration e11 = this.getEntries();
        while (e11.hasMoreElements()) {
            String entry = (String)e11.nextElement();
            if (!entry.endsWith(".class")) continue;
            String className = entry.replace('/', '.');
            classNamesSet.add(className.substring(0, className.lastIndexOf(".class")));
        }
        return classNamesSet;
    }

    public Iterator getDirectories() {
        HashSet<Object> directories = new HashSet<Object>();
        Enumeration e10 = this.fileDirectoryMap.elements();
        while (e10.hasMoreElements()) {
            directories.add(e10.nextElement());
        }
        Enumeration e11 = this.getEntries();
        while (e11.hasMoreElements()) {
            String key = (String)e11.nextElement();
            File dir = this.getDirectoryFor(key);
            if (directories.contains(dir)) continue;
            directories.add(dir);
        }
        return directories.iterator();
    }

    public File getDirectoryFor(File file) {
        Object o2 = this.fileDirectoryMap.get(file);
        if (o2 == null) {
            return null;
        }
        return (File)o2;
    }

    public File getDirectoryFor(String entry) {
        File file = (File)this.rawFileDirectoryMap.get(entry);
        if (file == null) {
            return this.getDirectoryFor(FileContentsDescriptor.FileEntry(entry));
        }
        String val = file.toString();
        if (val.endsWith(entry.replace('/', FileSeparatorChar))) {
            String dir = val.substring(0, val.length() - entry.length());
            if (dir.endsWith(FileSeparator)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            return new File(dir);
        }
        return file.getParentFile();
    }

    public File getFullFileFor(File file) {
        Object o2 = this.fileDirectoryMap.get(file);
        if (o2 == null) {
            return null;
        }
        if (((File)o2).toString().equals("")) {
            return new File(file.toString());
        }
        return new File((File)o2, file.toString());
    }

    public File getFileFor(String entry) {
        File file = (File)this.rawFileDirectoryMap.get(entry);
        if (file == null) {
            file = this.getFullFileFor(FileContentsDescriptor.FileEntry(entry));
        }
        return file;
    }

    protected JarClassLoader getClassLoaderInstance() {
        return new JarClassLoader();
    }

    public ClassLoader getClassLoader() throws IOException {
        JarClassLoader jcl = this.getClassLoaderInstance();
        Iterator itr = this.getDirectories();
        while (itr.hasNext()) {
            File next = (File)itr.next();
            jcl.addJar(next.getAbsolutePath());
        }
        HashSet<File> libjars = new HashSet<File>(this.getLibraryJars());
        Iterator lji = this.getFilesSet().iterator();
        while (lji.hasNext()) {
            File key = (File)lji.next();
            String keyStr = key.toString();
            if (!keyStr.toLowerCase().endsWith(".jar")) continue;
            libjars.add(this.getFileFor(keyStr));
        }
        Iterator itr2 = libjars.iterator();
        while (itr2.hasNext()) {
            File next = (File)itr2.next();
            jcl.addJar(next.getAbsolutePath());
        }
        return jcl;
    }

    public Hashtable getEntryNameMap() {
        Hashtable<String, File> filesMap = new Hashtable<String, File>();
        Enumeration e10 = this.getFiles();
        while (e10.hasMoreElements()) {
            File fileKey = (File)e10.nextElement();
            filesMap.put(FileContentsDescriptor.StringEntry(fileKey), this.getFullFileFor(fileKey));
        }
        filesMap.putAll(this.rawFileDirectoryMap);
        return filesMap;
    }

    public String toString() {
        return this.fileDirectoryMap.toString();
    }

    private static File FileEntry(String entry) {
        return new File(entry.replace('/', FileSeparatorChar));
    }

    private static String StringEntry(File entry) {
        return entry.toString().replace(FileSeparatorChar, '/');
    }
}

