/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.security.acl.Role;

public class MethodPermission {
    private static MethodPermission unchecked;
    private static MethodPermission excluded;
    private boolean isUnchecked = false;
    private boolean isExcluded = false;
    private Role role;

    public MethodPermission(Role role) {
        this.role = role;
    }

    private MethodPermission() {
    }

    public static MethodPermission getUncheckedMethodPermission() {
        if (unchecked == null) {
            unchecked = new MethodPermission();
            MethodPermission.unchecked.isUnchecked = true;
        }
        return unchecked;
    }

    public static MethodPermission getExcludedMethodPermission() {
        if (excluded == null) {
            excluded = new MethodPermission();
            MethodPermission.excluded.isExcluded = true;
        }
        return excluded;
    }

    public boolean isRoleBased() {
        return this.role != null;
    }

    public boolean isUnchecked() {
        return this.isUnchecked;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public Role getRole() {
        return this.role;
    }

    public int hashCode() {
        if (this.role != null) {
            return this.role.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object other) {
        boolean ret = false;
        if (other instanceof MethodPermission) {
            MethodPermission o2 = (MethodPermission)other;
            ret = this.isRoleBased() ? this.role.equals(o2.getRole()) : this.isExcluded == o2.isExcluded() && this.isUnchecked == o2.isUnchecked();
        }
        return ret;
    }

    public String toString() {
        if (this.isRoleBased()) {
            return this.role.toString();
        }
        if (this.isExcluded) {
            return "excluded";
        }
        return "unchecked";
    }
}

