/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.Tag;
import com.sun.enterprise.deployment.web.TagLib;
import com.sun.enterprise.deployment.web.TagLibValidator;
import java.util.Collection;
import java.util.Vector;

public class TagLibDescriptor
extends Descriptor
implements TagLib {
    private String tlibversion = null;
    private String jspversion = null;
    private String uri = null;
    private Vector tagList = null;
    private String displayName = null;
    private TagLibValidator validator = null;
    private Vector listenerList = null;

    public TagLibDescriptor() {
    }

    public TagLibDescriptor(String tlibversion, String shortname) {
        this.setTagLibVersion(tlibversion);
        this.setName(shortname);
    }

    public void setTagLibVersion(String v2) {
        this.tlibversion = v2;
        this.changed();
    }

    public String getTagLibVersion() {
        if (this.tlibversion == null) {
            this.tlibversion = "";
        }
        return this.tlibversion;
    }

    public void setJspVersion(String v2) {
        this.jspversion = v2;
        this.changed();
    }

    public String getJspVersion() {
        if (this.jspversion == null) {
            this.jspversion = "";
        }
        return this.jspversion;
    }

    public void setShortName(String name) {
        this.setName(name);
    }

    public String getShortName() {
        return this.getName();
    }

    public void setUri(String u2) {
        this.uri = u2;
        this.changed();
    }

    public String getUri() {
        if (this.uri == null) {
            this.uri = "";
        }
        return this.uri;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        this.changed();
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.getName();
        }
        return this.displayName;
    }

    public void setInfo(String d10) {
        this.setDescription(d10);
    }

    public String getInfo() {
        return this.getDescription();
    }

    public void setValidator(TagLibValidator val) {
        this.validator = val;
    }

    public TagLibValidator getValidator() {
        return this.validator;
    }

    protected Vector _getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new Vector();
        }
        return this.listenerList;
    }

    public void setListenerList(Collection list) {
        this._getListenerList().clear();
        this._getListenerList().addAll(list);
        this.changed();
    }

    public Vector getListenerList() {
        return (Vector)this._getListenerList().clone();
    }

    public void addListener(AppListenerDescriptor tag) {
        if (!this._getListenerList().contains(tag)) {
            this._getListenerList().add(tag);
            this.changed();
        }
    }

    public void removeListener(AppListenerDescriptor tag) {
        this._getListenerList().remove(tag);
        this.changed();
    }

    protected Vector _getTagList() {
        if (this.tagList == null) {
            this.tagList = new Vector();
        }
        return this.tagList;
    }

    public void setTagList(Collection tags) {
        this._getTagList().clear();
        this._getTagList().addAll(tags);
        this.changed();
    }

    public Vector getTagList() {
        return (Vector)this._getTagList().clone();
    }

    public void addTag(Tag tag) {
        if (!this._getTagList().contains(tag)) {
            this._getTagList().add(tag);
            this.changed();
        }
    }

    public void removeTag(Tag tag) {
        this._getTagList().remove(tag);
        this.changed();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\nTag Library descriptor");
        sb.append("\n").append(super.toString());
        sb.append("\n tlibversion=").append(this.getTagLibVersion());
        sb.append("\n jspversion=").append(this.getJspVersion());
        sb.append("\n shortname=").append(this.getName());
        sb.append("\n uri=").append(this.getUri());
        sb.append("\n info/description=").append(this.getDescription());
        sb.append("\n tag(#count)=").append(this._getTagList().size());
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TagLibDescriptor) {
            TagLibDescriptor tld = (TagLibDescriptor)obj;
            return this.getName().equals(tld.getName()) && this.getUri().equals(tld.getUri());
        }
        return false;
    }
}

