/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.security.acl.Role;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ApplicationNode
extends ElementNode {
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    public static String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    public static String SYSTEM_ID = "http://java.sun.com/dtd/application_1_3.dtd";
    private Hashtable contextRootMap = new Hashtable();
    private Hashtable ejbBundleArchiveMap = new Hashtable();
    private Hashtable webBundleArchiveMap = new Hashtable();
    private Hashtable applicationClientDescriptorArchiveMap = new Hashtable();
    private Hashtable rarDescriptorArchiveMap = new Hashtable();
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$ApplicationNode;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode;

    public ApplicationNode() {
        this.setTag("application");
    }

    public void setDescriptor(Application application) {
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(this.getOwnerDocument());
        DescriptorNodeUtils.appendDescriptorAttributes(factory, application, this, DescriptorNodeUtils.APP_STYLE);
        Iterator itr = application.getArchivableDescriptors().iterator();
        while (itr.hasNext()) {
            ElementNode acNode;
            BundleDescriptor next = (BundleDescriptor)itr.next();
            Archivist nextArchivist = next.getArchivist();
            ElementNode moduleNode = factory.getNode("module");
            this.appendChild(moduleNode);
            if (next instanceof WebBundleDescriptor) {
                ElementNode webNode = factory.getNode("web");
                moduleNode.appendChild(webNode);
                webNode.appendChild(factory.getTextNode("web-uri", next.getArchivist().getArchiveUri()));
                webNode.appendChild(factory.getTextNode("context-root", ((WebBundleDescriptor)next).getContextRoot()));
            } else if (next instanceof EjbBundleDescriptor) {
                ElementNode ejbNode = factory.getTextNode("ejb", next.getArchivist().getArchiveUri());
                moduleNode.appendChild(ejbNode);
            } else if (next instanceof ApplicationClientDescriptor) {
                acNode = factory.getTextNode("java", next.getArchivist().getArchiveUri());
                moduleNode.appendChild(acNode);
            } else if (next instanceof ConnectorDescriptor) {
                acNode = factory.getTextNode("connector", next.getArchivist().getArchiveUri());
                moduleNode.appendChild(acNode);
            }
            if (!nextArchivist.hasExternalDescriptor()) continue;
            moduleNode.appendChild(factory.getTextNode("alt-dd", nextArchivist.getExternalDescriptorArchiveUri()));
        }
        Iterator itr2 = application.getRoles().iterator();
        while (itr2.hasNext()) {
            Role next = (Role)itr2.next();
            ElementNode srNode = factory.getNode("security-role");
            this.appendChild(srNode);
            if (!"".equals(next.getDescription())) {
                srNode.appendChild(factory.getTextNode("description", next.getDescription()));
            }
            srNode.appendChild(factory.getTextNode("role-name", next.getName()));
        }
    }

    public Application getApplication(ClassLoader classLoader) throws ContentTransformationException {
        try {
            Application application = new Application("", new File(""));
            DescriptorNodeUtils.setDescriptorAttributes(this, application, DescriptorNodeUtils.APP_STYLE);
            Enumeration e10 = XMLUtils.getNodesUnder((Node)this, "module");
            while (e10.hasMoreElements()) {
                String acArchiveUri;
                ElementNode acNode;
                ElementNode moduleNode = (ElementNode)e10.nextElement();
                String externalDDUri = "";
                if (XMLUtils.getFirstNodeUnder(moduleNode, "alt-dd") != null) {
                    externalDDUri = XMLUtils.getTextFor(moduleNode, "alt-dd");
                }
                if (XMLUtils.hasNodesUnder(moduleNode, "web")) {
                    ElementNode webNode = XMLUtils.getFirstNodeUnder(moduleNode, "web");
                    String webArchiveUri = XMLUtils.getTextFor(webNode, "web-uri");
                    String contextRoot = XMLUtils.getTextFor(webNode, "context-root");
                    this.contextRootMap.put(webArchiveUri, contextRoot);
                    this.webBundleArchiveMap.put(webArchiveUri, externalDDUri);
                }
                if (XMLUtils.hasNodesUnder(moduleNode, "ejb")) {
                    ElementNode ejbNode = XMLUtils.getFirstNodeUnder(moduleNode, "ejb");
                    String ejbArchiveUri = XMLUtils.getTextFor(moduleNode, "ejb");
                    this.ejbBundleArchiveMap.put(ejbArchiveUri, externalDDUri);
                }
                if (XMLUtils.hasNodesUnder(moduleNode, "java")) {
                    acNode = XMLUtils.getFirstNodeUnder(moduleNode, "java");
                    acArchiveUri = XMLUtils.getTextFor(moduleNode, "java");
                    this.applicationClientDescriptorArchiveMap.put(acArchiveUri, externalDDUri);
                }
                if (!XMLUtils.hasNodesUnder(moduleNode, "connector")) continue;
                acNode = XMLUtils.getFirstNodeUnder(moduleNode, "connector");
                acArchiveUri = XMLUtils.getTextFor(moduleNode, "connector");
                this.rarDescriptorArchiveMap.put(acArchiveUri, externalDDUri);
            }
            Enumeration e11 = XMLUtils.getNodesUnder((Node)this, "security-role");
            while (e11.hasMoreElements()) {
                ElementNode next = (ElementNode)e11.nextElement();
                Role r2 = new Role(XMLUtils.getTextFor(next, "role-name"));
                if (XMLUtils.hasNodesUnder(next, "description")) {
                    r2.setDescription(XMLUtils.getTextFor(next, "description"));
                }
                application.addRole(r2);
            }
            return application;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            throw new ContentTransformationException(iae.getMessage(), this.toString());
        }
    }

    public Hashtable getEjbBundleArchiveMap() {
        return this.ejbBundleArchiveMap;
    }

    public Hashtable getWebBundleArchiveMap() {
        return this.webBundleArchiveMap;
    }

    public Hashtable getApplicationClientDescriptorArchiveMap() {
        return this.applicationClientDescriptorArchiveMap;
    }

    public Hashtable getRarDescriptorArchiveMap() {
        return this.rarDescriptorArchiveMap;
    }

    public static void resolveInterJarEjbReferences(Application application) {
        Enumeration e10 = application.getEjbReferenceDescriptors().elements();
        while (e10.hasMoreElements()) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)e10.nextElement();
            if (!EjbReferenceDescriptor.INTERNAL_UNRESOLVED_STATE.equals(next.getState())) continue;
            String homeClassName = next.getHomeClassName();
            String intfClassName = next.getBeanClassName();
            String linkName = next.getLinkName();
            int ind = linkName.lastIndexOf(35);
            if (ind != -1) {
                String ejbName = linkName.substring(ind + 1);
                String jarPath = linkName.substring(0, ind);
                BundleDescriptor referringJar = next.getReferringBundleDescriptor();
                String referringURI = referringJar.getArchivist().getArchiveUri();
                int slash = referringURI.lastIndexOf(47);
                String refereeURI = referringURI.substring(0, slash + 1) + jarPath;
                EjbBundleDescriptor refereeJar = application.getEjbBundleByUri(refereeURI);
                EjbDescriptor ejbReferee = refereeJar.getEjbByName(ejbName);
                next.setEjbDescriptor(ejbReferee);
            } else if (application.hasEjbByName(linkName)) {
                EjbDescriptor ejbReferee = application.getEjbByName(next.getLinkName());
                next.setEjbDescriptor(ejbReferee);
            } else {
                throw new RuntimeException("Error: Unresolved <ejb-link>: " + linkName);
            }
            if (!homeClassName.equals(next.getHomeClassName())) {
                System.out.println("WARNING " + linkName + " ejb-ref expected home interface to be " + homeClassName + " and got " + next.getHomeClassName());
            }
            if (intfClassName.equals(next.getBeanClassName())) continue;
            System.out.println("WARNING" + linkName + " ejb-ref expected bean interface to be " + intfClassName + " and got " + next.getBeanClassName());
        }
    }

    public String getContextRootFor(String entryName) {
        if (this.contextRootMap.get(entryName) != null) {
            return (String)this.contextRootMap.get(entryName);
        }
        throw new RuntimeException("Cannot find context root for web bundle with entry " + entryName + " in this ear");
    }

    public static Vector readApplicationNodes(InputStream is) throws ParseException {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put(RuntimeDescriptorNode.RUNTIME_TAG, "com.sun.enterprise.deployment.xml.RuntimeDescriptorNode");
            nodeToClass.put("application", "com.sun.enterprise.deployment.xml.ApplicationNode");
            Vector applicationNodes = XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$ApplicationNode == null ? (class$com$sun$enterprise$deployment$xml$ApplicationNode = ApplicationNode.class$("com.sun.enterprise.deployment.xml.ApplicationNode")) : class$com$sun$enterprise$deployment$xml$ApplicationNode, nodeToClass, is);
            return applicationNodes;
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new ParseException(se);
        }
        catch (Throwable t2) {
            throw new ParseException(t2.getMessage());
        }
    }

    public static ApplicationNode read(InputStream is) throws ParseException {
        Vector nodes = ApplicationNode.readApplicationNodes(is);
        if (nodes.size() > 0) {
            return (ApplicationNode)nodes.elementAt(0);
        }
        throw new ParseException("No application nodes were found");
    }

    public static RuntimeDescriptorNode readRtdn(InputStream is) {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put(RuntimeDescriptorNode.RUNTIME_TAG, "com.sun.enterprise.util.xml.RuntimeDescriptorNode");
            Vector rtNodes = XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode == null ? (class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode = ApplicationNode.class$("com.sun.enterprise.deployment.xml.RuntimeDescriptorNode")) : class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode, nodeToClass, is);
            return (RuntimeDescriptorNode)rtNodes.elementAt(0);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            return null;
        }
    }

    public static XmlDocument getDocument(Application application) {
        XmlDocument document = new XmlDocument();
        document.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        ApplicationNode n2 = new ApplicationNode();
        document.appendChild(n2);
        n2.setDescriptor(application);
        return document;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

