/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.util.TypeUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.crimson.tree.ElementNode;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class EjbNode
extends ElementNode {
    private static final boolean debug = false;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$EjbNode;

    public static String[] getTags() {
        String[] tags = new String[]{"session", "entity", "message-driven"};
        return tags;
    }

    public void setDescriptor(EjbDescriptor ejbDescriptor) {
        ElementNode secNode;
        PersistenceDescriptor pers;
        EjbCMPEntityDescriptor cmpEntity;
        EjbEntityDescriptor entity = null;
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(super.getOwnerDocument());
        if (ejbDescriptor instanceof EjbEntityDescriptor) {
            this.setTag("entity");
        } else if (ejbDescriptor instanceof EjbSessionDescriptor) {
            this.setTag("session");
        } else {
            this.setTag("message-driven");
        }
        DescriptorNodeUtils.appendDescriptorAttributes(factory, ejbDescriptor, this, DescriptorNodeUtils.EJB_STYLE);
        this.appendChild(factory.getTextNode("ejb-name", ejbDescriptor.getName()));
        if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                this.appendChild(factory.getTextNode("home", ejbDescriptor.getHomeClassName()));
                this.appendChild(factory.getTextNode("remote", ejbDescriptor.getRemoteClassName()));
            }
            if (ejbDescriptor.isLocalInterfacesSupported()) {
                this.appendChild(factory.getTextNode("local-home", ejbDescriptor.getLocalHomeClassName()));
                this.appendChild(factory.getTextNode("local", ejbDescriptor.getLocalClassName()));
            }
        }
        this.appendChild(factory.getTextNode("ejb-class", ejbDescriptor.getEjbClassName()));
        if (ejbDescriptor instanceof EjbEntityDescriptor) {
            entity = (EjbEntityDescriptor)ejbDescriptor;
            this.appendChild(factory.getTextNode("persistence-type", entity.getPersistenceType()));
            if (!entity.getPrimaryKeyClassName().equals("")) {
                this.appendChild(factory.getTextNode("prim-key-class", entity.getPrimaryKeyClassName()));
            }
            this.appendChild(factory.getTextNode("reentrant", entity.isReentrantAsString()));
            if (entity.getPersistenceType().equals("Container")) {
                cmpEntity = (EjbCMPEntityDescriptor)entity;
                this.appendChild(factory.getTextNode("cmp-version", cmpEntity.getCMPVersion()));
                if (cmpEntity.isEJB20()) {
                    this.appendChild(factory.getTextNode("abstract-schema-name", cmpEntity.getAbstractSchemaName()));
                }
                pers = cmpEntity.getPersistenceDescriptor();
                Iterator itr = pers.getCMPFields().iterator();
                while (itr.hasNext()) {
                    FieldDescriptor nextField = (FieldDescriptor)itr.next();
                    ElementNode fieldNode = factory.getNode("cmp-field");
                    this.appendChild(fieldNode);
                    if (!nextField.getDescription().equals("")) {
                        fieldNode.appendChild(factory.getTextNode("description", nextField.getDescription()));
                    }
                    fieldNode.appendChild(factory.getTextNode("field-name", nextField.getName()));
                }
                if (cmpEntity.getPrimaryKeyFieldDesc() != null) {
                    this.appendChild(factory.getTextNode("primkey-field", cmpEntity.getPrimaryKeyFieldDesc().getName()));
                }
            }
        }
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            ElementNode sessionTypeNode = factory.getTextNode("session-type", ((EjbSessionDescriptor)ejbDescriptor).getSessionTypeString());
            this.appendChild(sessionTypeNode);
        }
        if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbMessageBeanDescriptor) {
            this.appendChild(factory.getTextNode("transaction-type", ejbDescriptor.getTransactionType()));
        }
        if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
            EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)ejbDescriptor;
            if (msgBeanDesc.hasJmsMessageSelector()) {
                this.appendChild(factory.getTextNode("message-selector", msgBeanDesc.getJmsMessageSelector()));
            }
            if (msgBeanDesc.getTransactionType().equals(EjbDescriptor.BEAN_TRANSACTION_TYPE)) {
                String jmsAckModeStr = msgBeanDesc.getJmsAcknowledgeMode() == 1 ? "Auto-acknowledge" : "Dups-ok-acknowledge";
                this.appendChild(factory.getTextNode("acknowledge-mode", jmsAckModeStr));
            }
            ElementNode msgDrivenDestNode = factory.getNode("message-driven-destination");
            this.appendChild(msgDrivenDestNode);
            String destTypeStr = msgBeanDesc.hasQueueDest() ? "javax.jms.Queue" : "javax.jms.Topic";
            msgDrivenDestNode.appendChild(factory.getTextNode("destination-type", destTypeStr));
            if (msgBeanDesc.hasTopicDest()) {
                String durableSubscriptionStr = msgBeanDesc.hasDurableSubscription() ? "Durable" : "NonDurable";
                msgDrivenDestNode.appendChild(factory.getTextNode("subscription-durability", durableSubscriptionStr));
            }
        }
        DescriptorNodeUtils.appendEnvironmentProperties(factory, ejbDescriptor, this);
        DescriptorNodeUtils.appendEjbReferences(factory, ejbDescriptor, this);
        if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
            Iterator itr = ejbDescriptor.getRoleReferences().iterator();
            while (itr.hasNext()) {
                RoleReference nextRoleReference = (RoleReference)itr.next();
                ElementNode roleReferenceNode = factory.getNode("security-role-ref");
                this.appendChild(roleReferenceNode);
                if (!"".equals(nextRoleReference.getDescription())) {
                    roleReferenceNode.appendChild(factory.getTextNode("description", nextRoleReference.getDescription()));
                }
                roleReferenceNode.appendChild(factory.getTextNode("role-name", nextRoleReference.getName()));
                if ("".equals(nextRoleReference.getValue())) continue;
                roleReferenceNode.appendChild(factory.getTextNode("role-link", nextRoleReference.getValue()));
            }
        }
        if (ejbDescriptor.getUsesCallerIdentity()) {
            secNode = factory.getNode("security-identity");
            this.appendChild(secNode);
            secNode.appendChild(factory.getTextNode("description", ejbDescriptor.getSecurityIdentityDescription()));
            secNode.appendChild(factory.getTextNode("use-caller-identity", ""));
        } else if (ejbDescriptor.getRunAsIdentity() != null) {
            secNode = factory.getNode("security-identity");
            this.appendChild(secNode);
            secNode.appendChild(factory.getTextNode("description", ejbDescriptor.getSecurityIdentityDescription()));
            ElementNode runAsNode = factory.getNode("run-as");
            secNode.appendChild(runAsNode);
            RunAsIdentityDescriptor runAs = ejbDescriptor.getRunAsIdentity();
            String description = runAs.getDescription();
            if (description != null) {
                runAsNode.appendChild(factory.getTextNode("description", runAs.getDescription()));
            }
            runAsNode.appendChild(factory.getTextNode("role-name", runAs.getRoleName()));
        }
        DescriptorNodeUtils.appendResourceReferences(factory, ejbDescriptor, this);
        DescriptorNodeUtils.appendJmsDestinationReferences(factory, ejbDescriptor, this);
        if (ejbDescriptor instanceof EjbEntityDescriptor && entity.getPersistenceType().equals("Container") && (cmpEntity = (EjbCMPEntityDescriptor)entity).isEJB20()) {
            pers = cmpEntity.getPersistenceDescriptor();
            EjbNode.writeQueries(this, pers, factory);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EjbDescriptor getDescriptor() throws ContentTransformationException {
        try {
            ElementNode idNode;
            ElementNode scopeNode;
            String persType;
            EjbDescriptor ejbDescriptor = null;
            ejbDescriptor = this.getTagName().equals("entity") ? ((persType = XMLUtils.getTextFor(this, "persistence-type")).equals(EjbEntityDescriptor.BEAN_PERSISTENCE) ? new EjbEntityDescriptor() : new EjbCMPEntityDescriptor()) : (this.getTagName().equals("session") ? new EjbSessionDescriptor() : new EjbMessageBeanDescriptor());
            DescriptorNodeUtils.setDescriptorAttributes(this, ejbDescriptor, DescriptorNodeUtils.EJB_STYLE);
            ejbDescriptor.setName(XMLUtils.getTextFor(this, "ejb-name"));
            if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
                if (XMLUtils.hasImmediateElementChildFor(this, "home")) {
                    ejbDescriptor.setHomeClassName(XMLUtils.getTextFor(this, "home"));
                    ejbDescriptor.setRemoteClassName(XMLUtils.getTextFor(this, "remote"));
                }
                if (XMLUtils.hasImmediateElementChildFor(this, "local-home")) {
                    ejbDescriptor.setLocalHomeClassName(XMLUtils.getTextFor(this, "local-home"));
                    ejbDescriptor.setLocalClassName(XMLUtils.getTextFor(this, "local"));
                }
                if (ejbDescriptor.getHomeClassName() == null && ejbDescriptor.getLocalHomeClassName() == null) {
                    throw new RuntimeException("Invalid XML : Bean " + ejbDescriptor.getName() + " does not define a local home or home interface");
                }
            }
            ejbDescriptor.setEjbClassName(XMLUtils.getTextFor(this, "ejb-class"));
            if (this.getTagName().equals("entity")) {
                persType = XMLUtils.getTextFor(this, "persistence-type");
                ((EjbEntityDescriptor)ejbDescriptor).setPersistenceType(persType);
            }
            if (ejbDescriptor instanceof EjbEntityDescriptor) {
                EjbEntityDescriptor entity = (EjbEntityDescriptor)ejbDescriptor;
                entity.setPrimaryKeyClassName(XMLUtils.getTextFor(this, "prim-key-class"));
                entity.setReentrant(XMLUtils.getTextFor(this, "reentrant"));
                if (entity instanceof EjbCMPEntityDescriptor) {
                    EjbCMPEntityDescriptor cmpEntity = (EjbCMPEntityDescriptor)entity;
                    Document doc = this.getOwnerDocument();
                    DocumentType docType = doc.getDoctype();
                    if (docType == null) {
                        throw new RuntimeException("Invalid XML : No document type for " + doc);
                    }
                    String publicId = docType.getPublicId();
                    boolean isCMP20 = true;
                    String cmpVersion = EjbCMPEntityDescriptor.CMP_2_VERSION;
                    if (publicId.equals(EjbBundleNode.PUBLIC_DTD_ID)) {
                        if (XMLUtils.hasNodesUnder(this, "cmp-version")) {
                            cmpVersion = XMLUtils.getTextFor(this, "cmp-version");
                            isCMP20 = cmpVersion.equals(EjbCMPEntityDescriptor.CMP_2_VERSION);
                        }
                    } else {
                        if (!publicId.equals(EjbBundleNode.PUBLIC_DTD_ID_12)) throw new RuntimeException("Invalid XML : Unknown document type : " + docType);
                        cmpVersion = EjbCMPEntityDescriptor.CMP_1_VERSION;
                        isCMP20 = false;
                    }
                    cmpEntity.setCMPVersion(cmpVersion);
                    if (isCMP20) {
                        cmpEntity.setAbstractSchemaName(XMLUtils.getTextFor(this, "abstract-schema-name"));
                    }
                    PersistenceDescriptor pers = new PersistenceDescriptor();
                    cmpEntity.setPersistenceDescriptor(pers);
                    HashSet<FieldDescriptor> persistentFields = new HashSet<FieldDescriptor>();
                    Enumeration e10 = XMLUtils.getNodesUnder((Node)this, "cmp-field");
                    while (e10.hasMoreElements()) {
                        ElementNode nextFieldNode = (ElementNode)e10.nextElement();
                        String optionalDescription = "";
                        if (XMLUtils.hasNodesUnder(nextFieldNode, "description")) {
                            optionalDescription = XMLUtils.getTextFor(nextFieldNode, "description");
                        }
                        FieldDescriptor field = new FieldDescriptor(XMLUtils.getTextFor(nextFieldNode, "field-name"), optionalDescription);
                        if (isCMP20) {
                            FieldDescriptor.checkFieldName(field.getName());
                        }
                        persistentFields.add(field);
                    }
                    pers.setCMPFields(persistentFields);
                    if (XMLUtils.hasNodesUnder(this, "primkey-field")) {
                        String field = XMLUtils.getTextFor(this, "primkey-field");
                        cmpEntity.setPrimaryKeyFieldDesc(new FieldDescriptor(field, ""));
                    }
                }
            }
            if (ejbDescriptor instanceof EjbSessionDescriptor) {
                String sessionTypeString = XMLUtils.getTextFor(this, "session-type");
                ((EjbSessionDescriptor)ejbDescriptor).setSessionTypeString(sessionTypeString);
            }
            if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                ejbDescriptor.setTransactionType(XMLUtils.getTextFor(this, "transaction-type"));
            }
            if ((scopeNode = XMLUtils.getFirstNodeUnder(this, "transaction-scope")) != null) {
                String txScope = XMLUtils.getTextFor(this, "transaction-scope");
                ejbDescriptor.setDistributedTransactionScope(txScope.equals("Distributed"));
            } else {
                ejbDescriptor.setDistributedTransactionScope(true);
            }
            if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                ElementNode msgDrivenDestNode;
                EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)ejbDescriptor;
                if (XMLUtils.hasNodesUnder(this, "message-selector")) {
                    msgBeanDesc.setJmsMessageSelector(XMLUtils.getTextFor(this, "message-selector"));
                }
                if (XMLUtils.hasNodesUnder(this, "acknowledge-mode")) {
                    String jmsAckModeStr = XMLUtils.getTextFor(this, "acknowledge-mode");
                    if (jmsAckModeStr.equals("Auto-acknowledge")) {
                        msgBeanDesc.setJmsAcknowledgeMode(1);
                    } else {
                        if (!jmsAckModeStr.equals("Dups-ok-acknowledge")) throw new IllegalArgumentException("Invalid jms acknowledge mode : " + jmsAckModeStr);
                        msgBeanDesc.setJmsAcknowledgeMode(3);
                    }
                }
                if ((msgDrivenDestNode = XMLUtils.getFirstNodeUnder(this, "message-driven-destination")) != null) {
                    String destTypeStr = XMLUtils.getTextFor(msgDrivenDestNode, "destination-type");
                    if (destTypeStr.equals("javax.jms.Queue")) {
                        msgBeanDesc.setHasQueueDest();
                    } else {
                        if (!destTypeStr.equals("javax.jms.Topic")) throw new IllegalArgumentException("Invalid jms dest type : " + destTypeStr);
                        msgBeanDesc.setHasTopicDest();
                        if (XMLUtils.hasNodesUnder(msgDrivenDestNode, "subscription-durability")) {
                            String subscriptionDurabilityStr = XMLUtils.getTextFor(msgDrivenDestNode, "subscription-durability");
                            if (subscriptionDurabilityStr.equals("Durable")) {
                                msgBeanDesc.setHasDurableSubscription(true);
                            } else {
                                if (!subscriptionDurabilityStr.equals("NonDurable")) throw new IllegalArgumentException("Invalid subscription durability string : " + subscriptionDurabilityStr);
                                msgBeanDesc.setHasDurableSubscription(false);
                            }
                        }
                    }
                } else {
                    msgBeanDesc.setHasQueueDest();
                }
            }
            DescriptorNodeUtils.setEnvironmentProperties(this, ejbDescriptor);
            if (ejbDescriptor instanceof EjbSessionDescriptor || ejbDescriptor instanceof EjbEntityDescriptor) {
                Enumeration e11 = XMLUtils.getNodesUnder((Node)this, "security-role-ref");
                while (e11.hasMoreElements()) {
                    ElementNode roleReferenceNode = (ElementNode)e11.nextElement();
                    String roleReferenceName = XMLUtils.getTextFor(roleReferenceNode, "role-name");
                    String description = "";
                    if (XMLUtils.hasNodesUnder(roleReferenceNode, "description")) {
                        description = XMLUtils.getTextFor(roleReferenceNode, "description");
                    }
                    RoleReference rr = new RoleReference(roleReferenceName, description);
                    if (XMLUtils.hasNodesUnder(roleReferenceNode, "role-link")) {
                        rr.setValue(XMLUtils.getTextFor(roleReferenceNode, "role-link"));
                    }
                    ejbDescriptor.addRoleReference(rr);
                }
            }
            if ((idNode = XMLUtils.getFirstNodeUnder(this, "security-identity")) != null) {
                ElementNode runAsNode;
                String desc = XMLUtils.getTextFor(idNode, "description");
                if (desc != null) {
                    ejbDescriptor.setSecurityIdentityDescription(desc);
                }
                if ((runAsNode = XMLUtils.getFirstNodeUnder(idNode, "run-as")) != null) {
                    RunAsIdentityDescriptor runAs = new RunAsIdentityDescriptor();
                    String d10 = XMLUtils.getTextFor(runAsNode, "description");
                    if (d10 != null) {
                        runAs.setDescription(d10);
                    }
                    runAs.setRoleName(XMLUtils.getTextFor(runAsNode, "role-name"));
                    ejbDescriptor.setUsesCallerIdentity(false);
                    ejbDescriptor.setRunAsIdentity(runAs);
                } else {
                    ejbDescriptor.setUsesCallerIdentity(true);
                }
            } else if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                ejbDescriptor.setUsesCallerIdentity(false);
            }
            DescriptorNodeUtils.setResourceReferences(this, ejbDescriptor);
            DescriptorNodeUtils.setJmsDestinationReferences(this, ejbDescriptor);
            return ejbDescriptor;
        }
        catch (IllegalArgumentException iae) {
            throw new ContentTransformationException(iae.getMessage(), this.toString());
        }
    }

    public void completeLoadingDescriptor(EjbDescriptor ejbDescriptor) {
        EjbCMPEntityDescriptor cmp;
        if (ejbDescriptor instanceof EjbCMPEntityDescriptor && (cmp = (EjbCMPEntityDescriptor)ejbDescriptor).isEJB20()) {
            EjbNode.parseQueries(this, cmp.getPersistenceDescriptor());
        }
    }

    static void parseQueries(ElementNode node, PersistenceDescriptor pers) {
        Enumeration e10 = XMLUtils.getNodesUnder((Node)node, "query");
        while (e10.hasMoreElements()) {
            String ejbqlQuery;
            Method method;
            ElementNode queryNode = (ElementNode)e10.nextElement();
            QueryDescriptor query = new QueryDescriptor();
            if (XMLUtils.hasNodesUnder(queryNode, "description")) {
                query.setDescription(XMLUtils.getTextFor(queryNode, "description"));
            }
            try {
                method = EjbNode.parseQueryMethod(queryNode, pers.getParentDescriptor());
            }
            catch (Exception ex2) {
                throw new RuntimeException("No method found for XML query element: " + ex2.getMessage());
            }
            query.setQueryMethod(method);
            pers.setQueryFor(method, query);
            if (XMLUtils.hasNodesUnder(queryNode, "result-type-mapping")) {
                String returnTypeMapping = XMLUtils.getTextFor(queryNode, "result-type-mapping");
                if (returnTypeMapping.equals("Remote")) {
                    query.setHasRemoteReturnTypeMapping();
                } else if (returnTypeMapping.equals("Local")) {
                    query.setHasLocalReturnTypeMapping();
                }
            }
            if ((ejbqlQuery = XMLUtils.getTextFor(queryNode, "ejb-ql")) != null && ejbqlQuery.trim().length() > 0) {
                query.setQuery(ejbqlQuery);
                continue;
            }
            query.setQuery(null);
        }
    }

    private static Method parseQueryMethod(ElementNode queryNode, Descriptor desc) throws Exception {
        Class<?> homeIntf = null;
        Class<?> localHomeIntf = null;
        Class<?> beanClass = null;
        ClassLoader loader = null;
        EjbCMPEntityDescriptor dd2 = (EjbCMPEntityDescriptor)desc;
        loader = ((EjbBundleArchivist)dd2.getEjbBundleDescriptor().getArchivist()).getClassLoader();
        if (dd2.isRemoteInterfacesSupported()) {
            homeIntf = loader.loadClass(dd2.getHomeClassName());
        }
        if (dd2.isLocalInterfacesSupported()) {
            localHomeIntf = loader.loadClass(dd2.getLocalHomeClassName());
        }
        beanClass = loader.loadClass(dd2.getEjbClassName());
        ElementNode queryMethod = XMLUtils.getFirstNodeUnder(queryNode, "query-method");
        String methodName = XMLUtils.getTextFor(queryMethod, "method-name");
        ElementNode methodParams = XMLUtils.getFirstNodeUnder(queryMethod, "method-params");
        Vector params = XMLUtils.getVectorOfNodesUnder(queryNode, "method-param");
        String[] types = new String[params.size()];
        int i2 = 0;
        while (i2 < params.size()) {
            ElementNode param = (ElementNode)params.elementAt(i2);
            types[i2] = XMLUtils.getTextFor(param, "method-param");
            ++i2;
        }
        if (methodName.startsWith("ejbSelect")) {
            return TypeUtil.getMethod(beanClass, loader, methodName, types);
        }
        Method localFinder = null;
        Method remoteFinder = null;
        try {
            if (dd2.isRemoteInterfacesSupported()) {
                remoteFinder = TypeUtil.getMethod(homeIntf, loader, methodName, types);
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            if (dd2.isLocalInterfacesSupported()) {
                localFinder = TypeUtil.getMethod(localHomeIntf, loader, methodName, types);
            }
        }
        catch (Exception ex3) {
            // empty catch block
        }
        if (remoteFinder != null) {
            return remoteFinder;
        }
        if (localFinder != null) {
            return localFinder;
        }
        throw new RuntimeException("Ambiguous or invalid <query-method>");
    }

    private static void getClass(String type, ClassLoader loader) {
    }

    static void writeQueries(ElementNode node, PersistenceDescriptor pers, XMLUtils factory) {
        Iterator it = pers.getQueriedMethods().iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            QueryDescriptor query = pers.getQueryFor(method);
            ElementNode qNode = factory.getNode("query");
            if (query.getDescription() != null) {
                qNode.appendChild(factory.getTextNode("description", query.getDescription()));
            }
            EjbNode.writeQueryMethod(qNode, method, pers, factory);
            if (query.getHasLocalReturnTypeMapping() || query.getHasRemoteReturnTypeMapping()) {
                String mapping = query.getHasRemoteReturnTypeMapping() ? "Remote" : "Local";
                qNode.appendChild(factory.getTextNode("result-type-mapping", mapping));
            }
            String ejbqlText = query.getIsEjbQl() ? query.getQuery() : "";
            qNode.appendChild(factory.getTextNode("ejb-ql", ejbqlText));
            node.appendChild(qNode);
        }
    }

    private static void writeQueryMethod(ElementNode queryNode, Method method, PersistenceDescriptor pers, XMLUtils factory) {
        ElementNode queryMethod = factory.getNode("query-method");
        queryNode.appendChild(queryMethod);
        queryMethod.appendChild(factory.getTextNode("method-name", method.getName()));
        EjbCMPEntityDescriptor dd2 = (EjbCMPEntityDescriptor)pers.getParentDescriptor();
        ElementNode methodParamsNode = factory.getNode("method-params");
        queryMethod.appendChild(methodParamsNode);
        Class<?>[] params = method.getParameterTypes();
        int i2 = 0;
        while (i2 < params.length) {
            String param = MethodDescriptor.fixParamClassName(params[i2].getName());
            ElementNode parameterNode = factory.getTextNode("method-param", param);
            methodParamsNode.appendChild(parameterNode);
            ++i2;
        }
    }

    public static Vector readEjbNodes(InputStream is) {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put("entity", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("session", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("message-driven", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$EjbNode == null ? (class$com$sun$enterprise$deployment$xml$EjbNode = EjbNode.class$("com.sun.enterprise.deployment.xml.EjbNode")) : class$com$sun$enterprise$deployment$xml$EjbNode, nodeToClass, is);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            return new Vector();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

