/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.Utility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.apache.crimson.jaxp.SAXParserFactoryImpl;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.SimpleElementFactory;
import org.apache.crimson.tree.TreeWalker;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLUtils {
    private static final boolean debug = false;
    private Document document;
    static String VALIDATING_PARSER = "validating.parser";
    private static boolean validatingParse = false;
    static String WEB_DTD = "web-app_2_3.dtd";
    static String TAGLIB_DTD_11 = "web-jsptaglibrary_1_1.dtd";
    static String TAGLIB_DTD_12 = "web-jsptaglibrary_1_2.dtd";
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$XMLUtils;

    public XMLUtils(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document was null");
        }
        this.document = document;
        validatingParse = false;
    }

    private XMLUtils() {
        validatingParse = false;
    }

    public static void writeDocument(Document documentToWrite, OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        ((XmlDocument)documentToWrite).write(writer, "UTF-8");
    }

    public static void writeDocumentToFile(Document document, File file) throws IOException {
        if (file.getParent() != null) {
            boolean ok = new File(file.getParent()).mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file);
        XMLUtils.writeDocument(document, out);
        out.close();
    }

    public static String documentToString(Document document) throws IOException {
        StringWriter writer = new StringWriter();
        ((XmlDocument)document).write(writer, "UTF-8");
        return writer.toString();
    }

    public ElementNode getNode(String tag) {
        ElementNode n2 = (ElementNode)this.document.createElement(tag);
        return n2;
    }

    public ElementNode getNode(String tag, String valueName, String value) {
        ElementNode n2 = this.getNode(tag);
        if (value != null) {
            n2.setAttribute(valueName, value);
        }
        return n2;
    }

    public ElementNode getNode(String tag, String valueName1, String value1, String valueName2, String value2) {
        ElementNode n2 = this.getNode(tag);
        n2.setAttribute(valueName1, value1);
        n2.setAttribute(valueName2, value2);
        return n2;
    }

    public ElementNode getPropertiesNode(String tag, String propertyTagName, Properties p2) {
        ElementNode root = this.getNode(tag);
        Enumeration<?> e10 = p2.propertyNames();
        while (e10.hasMoreElements()) {
            String nextKey = (String)e10.nextElement();
            String nextValue = (String)((Hashtable)p2).get(nextKey);
            ElementNode nextPropertyNode = this.getNode(propertyTagName);
            nextPropertyNode.setAttribute("name", nextKey);
            nextPropertyNode.setAttribute("value", nextValue);
            root.appendChild(nextPropertyNode);
        }
        return root;
    }

    public ElementNode getTextNode(String tag, String text) {
        ElementNode en2 = this.getNode(tag);
        en2.appendChild(this.document.createTextNode(text));
        return en2;
    }

    public static Properties getProperties(ElementNode root, String tag, String propertyNameTag) {
        Properties p2 = new Properties();
        TreeWalker tw = new TreeWalker(root);
        Element startPropertiesNode = tw.getNextElement(tag);
        tw = new TreeWalker(startPropertiesNode);
        Element nextNode = null;
        while ((nextNode = tw.getNextElement(propertyNameTag)) != null) {
            ElementNode propertyNode = (ElementNode)nextNode;
            String nextKey = propertyNode.getAttribute("name");
            String nextValue = propertyNode.getAttribute("value");
            ((Hashtable)p2).put(nextKey, nextValue);
        }
        return p2;
    }

    public static String getValueOf(Node root, String tag, String key) {
        Node theNode = null;
        if (root instanceof Element && ((Element)root).getTagName().equals(tag)) {
            theNode = root;
        } else {
            TreeWalker tw = new TreeWalker(root);
            theNode = tw.getNextElement(tag);
        }
        if (theNode == null) {
            throw new RuntimeException("can't find a node under " + root + " with tag " + tag);
        }
        Attr n2 = (Attr)theNode.getAttributes().getNamedItem(key);
        return n2.getNodeValue();
    }

    private static String getTextFor_Lib(ElementNode root, String tag) {
        if (root.getTagName().equals(tag) && root.getFirstChild() instanceof Text) {
            return ((Text)root.getFirstChild()).getNodeValue();
        }
        TreeWalker tw = new TreeWalker(root);
        ElementNode n2 = (ElementNode)tw.getNextElement(tag);
        if (n2 == null) {
            throw new IllegalArgumentException(root + " has no sub nodes with tag " + tag);
        }
        Text tn = (Text)n2.getFirstChild();
        if (tn == null) {
            return "";
        }
        return tn.getNodeValue();
    }

    public static String getTextFor(ElementNode root, String tag) {
        return XMLUtils.getTextFor_Lib(root, tag);
    }

    public static ElementNode getFirstNodeUnder(Node root, String tag) {
        TreeWalker tw = new TreeWalker(root);
        Element node = tw.getNextElement(tag);
        if (node != null) {
            return (ElementNode)node;
        }
        return null;
    }

    public static boolean hasImmediateElementChildFor(ElementNode node, String tag) {
        NodeList nl = node.getChildNodes();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            ElementNode nextElementNode;
            Node next = nl.item(i2);
            if (next instanceof ElementNode && (nextElementNode = (ElementNode)next).getTagName().equals(tag)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static boolean hasNodesUnder(Node root, String tag) {
        return XMLUtils.getFirstNodeUnder(root, tag) != null;
    }

    public static Enumeration getNodesUnder(Node root, String tag) {
        return XMLUtils.getVectorOfNodesUnder(root, tag).elements();
    }

    public static Enumeration getNodesUnder(Node root, String[] tags) {
        Vector nodes = new Vector();
        int i2 = 0;
        while (i2 < tags.length) {
            nodes.addAll(XMLUtils.getVectorOfNodesUnder(root, tags[i2]));
            ++i2;
        }
        return nodes.elements();
    }

    public static Vector getVectorOfNodesUnder(Node root, String tag) {
        Vector<Element> nodes = new Vector<Element>();
        Element next = null;
        TreeWalker tw = new TreeWalker(root);
        while ((next = tw.getNextElement(tag)) != null) {
            nodes.addElement(next);
        }
        return nodes;
    }

    public static SAXParserFactory getSAXParserFactory() {
        return new SAXParserFactoryImpl();
    }

    public static Vector getNodesByType(Class type, Dictionary nodeToClassMap, InputStream is) throws Throwable {
        Vector<XmlDocument> nodes = new Vector<XmlDocument>();
        SimpleElementFactory elementFactory = new SimpleElementFactory();
        elementFactory.addMapping(nodeToClassMap, (class$com$sun$enterprise$deployment$xml$XMLUtils == null ? (class$com$sun$enterprise$deployment$xml$XMLUtils = XMLUtils.class$("com.sun.enterprise.deployment.xml.XMLUtils")) : class$com$sun$enterprise$deployment$xml$XMLUtils).getClassLoader());
        XmlDocumentBuilder builder = new XmlDocumentBuilder();
        builder.setIgnoringLexicalInfo(true);
        builder.setElementFactory(elementFactory);
        SAXParserFactory spf = XMLUtils.getSAXParserFactory();
        spf.setValidating(validatingParse);
        XMLReader parser = spf.newSAXParser().getXMLReader();
        String lexHandler = "http://xml.org/sax/properties/lexical-handler";
        parser.setProperty(lexHandler, builder);
        XMLValidationHandler dh2 = new XMLValidationHandler(false);
        parser.setEntityResolver(dh2);
        parser.setErrorHandler(dh2);
        parser.setContentHandler(builder);
        try {
            parser.parse(new InputSource(is));
        }
        catch (UnknownHostException uhe) {
            throw new ParseException("Neither this XML document's public nor system id's could be resolved: " + uhe + " " + uhe.getMessage() + "\n on parsing the doucment corresponding to " + type);
        }
        XmlDocument document = builder.getDocument();
        TreeWalker tw = new TreeWalker(document);
        Node next = document;
        while (next != null) {
            if (type.isInstance(next)) {
                nodes.addElement((XmlDocument)next);
            }
            next = tw.getNext();
        }
        return nodes;
    }

    public static String getAbsoluteFilenameURLForDTD(String dtdFilename) throws Exception {
        String j2ee13 = FileUtil.getAbsolutePath("lib/dtds");
        File f2 = new File(j2ee13 + File.separator + dtdFilename);
        return f2.toURL().toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String validation = null;
        try {
            Properties config = Utility.getPropertiesFromFile("default.properties");
            validation = config.getProperty("validating.parser");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        validatingParse = "true".equals(validation);
    }
}

