/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidationHandler
extends DefaultHandler {
    protected static Hashtable mapping = null;
    private boolean throwsException;

    public XMLValidationHandler(boolean thowsException) {
        this.throwsException = thowsException;
        XMLValidationHandler.Init();
    }

    public XMLValidationHandler() {
        this.throwsException = true;
        XMLValidationHandler.Init();
    }

    private static void Init() {
        if (mapping == null) {
            mapping = new Hashtable();
            mapping.put(ApplicationNode.PUBLIC_DTD_ID, "application_1_3.dtd");
            mapping.put(ApplicationNode.PUBLIC_DTD_ID_12, "application_1_2.dtd");
            mapping.put(EjbBundleNode.PUBLIC_DTD_ID, "ejb-jar_2_0.dtd");
            mapping.put(EjbBundleNode.PUBLIC_DTD_ID_12, "ejb-jar_1_1.dtd");
            mapping.put(ApplicationClientNode.PUBLIC_DTD_ID, "application-client_1_3.dtd");
            mapping.put(ApplicationClientNode.PUBLIC_DTD_ID_12, "application-client_1_2.dtd");
            mapping.put(ConnectorNode.PUBLIC_DTD_ID, "connector_1_0.dtd");
            mapping.put(RuntimeDescriptorNode.PUBLIC_DTD_ID, "sun-j2ee-ri_1_3.dtd");
            mapping.put(WebBundleNode.PUBLIC_DTD_ID, "web-app_2_3.dtd");
            mapping.put(WebBundleNode.PUBLIC_DTD_ID_12, "web-app_2_2.dtd");
        }
    }

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        try {
            if (mapping.containsKey(publicID)) {
                return new InputSource(new FileInputStream(new File(this.getAbsoluteFilenameForDTD((String)mapping.get(publicID)))));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void error(SAXParseException spe) throws SAXParseException {
        System.out.println("XML Error line : " + spe.getLineNumber() + " " + spe.getLocalizedMessage());
        if (this.throwsException) {
            throw spe;
        }
    }

    public void fatalError(SAXParseException spe) throws SAXParseException {
        System.out.println(spe.toString());
        throw spe;
    }

    protected String getAbsoluteFilenameForDTD(String dtdFilename) {
        String j2ee13 = FileUtil.getAbsolutePath("lib/dtds");
        File f2 = new File(j2ee13 + File.separator + dtdFilename);
        return f2.getAbsolutePath();
    }
}

