/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.util.Utility;
import java.util.Vector;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class J2EETransaction
implements Transaction {
    protected static final boolean debug = false;
    private static long txIdCounter = 1L;
    private long txId;
    private J2EEXid xid;
    private J2EETransactionManagerOpt j2eeTM;
    private Transaction jtsTx;
    private ResourceHandle nonXAResource;
    private int localTxStatus;
    private Vector syncs = new Vector();
    private boolean commitStarted = false;
    private static final byte[] bqual = new byte[]{0};

    J2EETransaction(J2EETransactionManagerOpt j2eeTM) {
        this.txId = J2EETransaction.getNewTxId();
        this.xid = new J2EEXid(this.txId);
        this.j2eeTM = j2eeTM;
        this.localTxStatus = 0;
    }

    J2EETransaction(J2EETransactionManagerOpt j2eeTM, Transaction jtsTx) {
        this(j2eeTM);
        this.jtsTx = jtsTx;
    }

    private static synchronized long getNewTxId() {
        long newTxId = txIdCounter++;
        return newTxId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof J2EETransaction) {
            J2EETransaction othertx = (J2EETransaction)other;
            return this.txId == othertx.txId;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.txId;
    }

    Xid getLocalXid() {
        return this.xid;
    }

    ResourceHandle getNonXAResource() {
        return this.nonXAResource;
    }

    void setNonXAResource(ResourceHandle h2) {
        this.nonXAResource = h2;
    }

    boolean isLocalTx() {
        return this.jtsTx == null;
    }

    void setJTSTx(Transaction jtsTx) throws RollbackException, SystemException {
        this.jtsTx = jtsTx;
        if (!this.commitStarted) {
            int i2 = 0;
            while (i2 < this.syncs.size()) {
                jtsTx.registerSynchronization((Synchronization)this.syncs.elementAt(i2));
                ++i2;
            }
        }
    }

    Transaction getJTSTx() {
        return this.jtsTx;
    }

    /*
     * Unable to fully structure code
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block25: {
            this.commitStarted = true;
            if (this.jtsTx != null) {
                try {
                    this.jtsTx.commit();
                    var2_1 = null;
                    this.j2eeTM.clearThreadTx();
                }
                catch (Throwable var1_6) {
                    var2_2 = null;
                    this.j2eeTM.clearThreadTx();
                    throw var1_6;
                }
            }
            try {
                block23: {
                    if (this.isRollbackOnly()) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException("Transaction marked for rollback");
                    }
                    i = 0;
                    while (i < this.syncs.size()) {
                        try {
                            sync = (Synchronization)this.syncs.elementAt(i);
                            sync.beforeCompletion();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ++i;
                    }
                    if (this.isRollbackOnly()) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException("Transaction marked for rollback");
                    }
                    if (this.jtsTx != null) {
                        this.jtsTx.commit();
                        break block23;
                    }
                    if (this.nonXAResource != null) {
                        this.nonXAResource.getXAResource().commit(this.xid, true);
                    }
                    this.localTxStatus = 3;
                }
                var5_9 = null;
                this.j2eeTM.clearThreadTx();
                i = 0;
                ** while (i < this.syncs.size())
            }
            catch (Throwable var4_16) {
                var5_10 = null;
                this.j2eeTM.clearThreadTx();
                i = 0;
                ** while (i < this.syncs.size())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    sync = (Synchronization)this.syncs.elementAt(i);
                    sync.afterCompletion(this.localTxStatus);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
                continue;
            }
lbl-1000:
            // 1 sources

            {
                break block25;
                catch (RollbackException ex) {
                    this.localTxStatus = 4;
                    throw ex;
                }
                catch (SystemException ex) {
                    this.localTxStatus = 4;
                    throw ex;
                }
                catch (Exception ex) {
                    this.localTxStatus = 4;
                    throw new SystemException(ex.toString());
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    sync = (Synchronization)this.syncs.elementAt(i);
                    sync.afterCompletion(this.localTxStatus);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
                continue;
            }
lbl81:
            // 1 sources

            throw var4_16;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void rollback() throws IllegalStateException, SystemException {
        block14: {
            block17: {
                block13: {
                    if (this.jtsTx != null) {
                        this.jtsTx.rollback();
                        break block13;
                    }
                    if (this.nonXAResource != null) {
                        this.nonXAResource.getXAResource().rollback(this.xid);
                    }
                    this.localTxStatus = 4;
                }
                var3_1 = null;
                this.j2eeTM.clearThreadTx();
                if (this.jtsTx != null) break block14;
                i = 0;
                ** while (i < this.syncs.size())
lbl-1000:
                // 1 sources

                {
                    try {
                        sync = (Synchronization)this.syncs.elementAt(i);
                        sync.afterCompletion(4);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    ++i;
                    continue;
                }
lbl-1000:
                // 1 sources

                {
                    break block14;
                    catch (Exception ex) {
                        this.localTxStatus = 4;
                        var3_2 = null;
                        this.j2eeTM.clearThreadTx();
                        if (this.jtsTx != null) break block14;
                        i = 0;
lbl33:
                        // 2 sources

                        ** while (i < this.syncs.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block14;
                    }
                }
lbl35:
                // 1 sources

                try {
                    sync = (Synchronization)this.syncs.elementAt(i);
                    sync.afterCompletion(4);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
                ** GOTO lbl33
                catch (Throwable var2_11) {
                    var3_3 = null;
                    this.j2eeTM.clearThreadTx();
                    if (this.jtsTx != null) break block17;
                    i = 0;
                    ** while (i < this.syncs.size())
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        sync = (Synchronization)this.syncs.elementAt(i);
                        sync.afterCompletion(4);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    ++i;
                    continue;
                }
            }
            throw var2_11;
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.delistResource(xaRes, flag);
        }
        throw new IllegalStateException("J2EETransaction.delistResource called for local tx");
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.enlistResource(xaRes);
        }
        if (this.nonXAResource != null) {
            throw new IllegalStateException("Local transaction already has 1 non-XA Resource: cannot add more resources");
        }
        throw new IllegalStateException("J2EETransaction.enlistResource called for local tx");
    }

    public int getStatus() throws SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.getStatus();
        }
        return this.localTxStatus;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            this.jtsTx.registerSynchronization(sync);
        } else {
            this.syncs.add(sync);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            this.jtsTx.setRollbackOnly();
        } else {
            this.localTxStatus = 1;
        }
    }

    private boolean isRollbackOnly() throws IllegalStateException, SystemException {
        int status = this.jtsTx != null ? this.jtsTx.getStatus() : this.localTxStatus;
        return status == 1;
    }

    public String toString() {
        return "J2EETransaction: txId=" + this.txId + " nonXAResource=" + this.nonXAResource + " jtsTx=" + this.jtsTx + " localTxStatus=" + this.localTxStatus + " syncs=" + this.syncs;
    }

    private class J2EEXid
    implements Xid {
        private static final int formatId = 987654321;
        private byte[] gtrId = new byte[8];

        J2EEXid(long txId) {
            Utility.longToBytes(txId, this.gtrId, 0);
        }

        public int getFormatId() {
            return 987654321;
        }

        public byte[] getGlobalTransactionId() {
            return this.gtrId;
        }

        public byte[] getBranchQualifier() {
            return bqual;
        }
    }
}

