/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.PoolManagerImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.pi.InterceptorImpl;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.SingleThreadModel;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class J2EETransactionManagerImpl
implements J2EETransactionManager {
    protected static final boolean debug = false;
    private static final String TX_TIMEOUT = "transaction.timeout";
    private static final String TX_OPT = "transaction.nonXA.optimization";
    protected TransactionManager tm = TransactionManagerImpl.getTransactionManagerImpl();
    protected InvocationManager invMgr;
    protected PoolManager poolmgr = new PoolManagerImpl();
    protected int transactionTimeout;
    private Hashtable resourceTable;

    public J2EETransactionManagerImpl() {
        Switch.getSwitch().setPoolManager(this.poolmgr);
        ResourceInstaller installer = new ResourceInstaller();
        Switch.getSwitch().setResourceInstaller(installer);
        this.resourceTable = new Hashtable();
        this.invMgr = Switch.getSwitch().getInvocationManager();
        ServerConfiguration sc = ServerConfiguration.getConfiguration();
        try {
            this.transactionTimeout = Integer.parseInt(sc.getProperty(TX_TIMEOUT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static J2EETransactionManager createTransactionManager() {
        ServerConfiguration sc = ServerConfiguration.getConfiguration();
        String txOpt = sc.getProperty(TX_OPT);
        J2EETransactionManagerImpl j2eeTM = txOpt != null && txOpt.equals("false") ? new J2EETransactionManagerImpl() : new J2EETransactionManagerOpt();
        return j2eeTM;
    }

    private static void print(String s2) {
        System.err.println(s2);
    }

    public boolean isNullTransaction() {
        try {
            return InterceptorImpl.isTxCtxtNull();
        }
        catch (Exception ex2) {
            return false;
        }
    }

    public void recover(XAResource[] resourceList) {
        int size = resourceList.length;
        Vector<XAResource> v2 = new Vector<XAResource>();
        int i2 = 0;
        while (i2 < size) {
            v2.addElement(resourceList[i2]);
            ++i2;
        }
        TransactionManagerImpl cfr_ignored_0 = (TransactionManagerImpl)this.tm;
        TransactionManagerImpl.recover(v2.elements());
    }

    public boolean enlistResource(Transaction tran, ResourceHandle h2) throws RollbackException, IllegalStateException, SystemException {
        if (h2.isTransactional()) {
            XAResource res = h2.getXAResource();
            boolean result = tran.enlistResource(res);
            if (result) {
                this.poolmgr.resourceEnlisted(tran, h2);
            }
            return result;
        }
        return true;
    }

    public void enlistComponentResources() throws RemoteException {
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        try {
            Transaction tran = this.getTransaction();
            inv.setTransaction(tran);
            this.enlistComponentResources(inv);
        }
        catch (InvocationException ex2) {
            ex2.printStackTrace();
            ex2.printStackTrace(Log.err);
            throw new RemoteException("", ex2.getNestedException());
        }
        catch (Exception ex3) {
            ex3.printStackTrace();
            ex3.printStackTrace(Log.err);
            throw new RemoteException("", ex3);
        }
    }

    public void delistComponentResources(boolean suspend) throws RemoteException {
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        try {
            this.delistComponentResources(inv, suspend);
        }
        catch (InvocationException ex2) {
            ex2.printStackTrace();
            ex2.printStackTrace(Log.err);
            throw new RemoteException("", ex2.getNestedException());
        }
        catch (Exception ex3) {
            ex3.printStackTrace();
            ex3.printStackTrace(Log.err);
            throw new RemoteException("", ex3);
        }
    }

    public void registerComponentResource(ResourceHandle h2) {
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        Object instance = inv.getInstance();
        if (instance == null) {
            return;
        }
        h2.setComponentInstance(instance);
        Vector v2 = this.getResourceList(instance);
        v2.addElement(h2);
    }

    public void unregisterComponentResource(ResourceHandle h2) {
        Object instance = h2.getComponentInstance();
        if (instance == null) {
            return;
        }
        h2.setComponentInstance(null);
        Vector v2 = this.getResourceList(instance);
        v2.removeElement(h2);
    }

    private void handleResourceError(ResourceHandle h2, Exception ex2, Transaction tran, ComponentInvocation inv) {
        Object instance = inv.getInstance();
        if (instance == null) {
            return;
        }
        Vector v2 = this.getResourceList(instance);
        v2.removeElement(h2);
        try {
            if (tran != null && h2.isTransactional()) {
                tran.delistResource(h2.getXAResource(), 0x4000000);
            }
        }
        catch (Exception ex22) {
            // empty catch block
        }
        if (ex2 instanceof RollbackException) {
            return;
        }
        if (ex2 instanceof IllegalStateException) {
            try {
                h2.getResourceAllocator().closeUserConnection(h2);
            }
            catch (Exception ex23) {}
        } else {
            try {
                h2.getResourceAllocator().destroyResource(h2);
            }
            catch (Exception ex24) {
                // empty catch block
            }
        }
    }

    private void enlistComponentResources(ComponentInvocation inv) throws InvocationException {
        try {
            Transaction tran = inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                Vector v2 = this.getResourceList(inv.getInstance());
                Enumeration e10 = v2.elements();
                while (e10.hasMoreElements()) {
                    ResourceHandle h2 = (ResourceHandle)e10.nextElement();
                    try {
                        this.enlistResource(tran, h2);
                    }
                    catch (Exception ex2) {
                        this.handleResourceError(h2, ex2, tran, inv);
                    }
                }
            }
        }
        catch (Exception ex3) {
            ex3.printStackTrace();
            ex3.printStackTrace(Log.err);
        }
    }

    private void delistComponentResources(ComponentInvocation inv, boolean suspend) throws InvocationException {
        try {
            Transaction tran = inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                Vector v2 = this.getResourceList(inv.getInstance());
                Enumeration e10 = v2.elements();
                int flag = 0x4000000;
                if (suspend) {
                    flag = 0x2000000;
                }
                while (e10.hasMoreElements()) {
                    ResourceHandle h2 = (ResourceHandle)e10.nextElement();
                    try {
                        this.delistResource(tran, h2, flag);
                    }
                    catch (IllegalStateException ex2) {
                    }
                    catch (Exception ex3) {
                        this.handleResourceError(h2, ex3, tran, inv);
                    }
                }
            }
        }
        catch (Exception ex4) {
            ex4.printStackTrace();
            ex4.printStackTrace(Log.err);
        }
    }

    private boolean isTransactionActive(Transaction tran) {
        return tran != null;
    }

    public void preInvoke(ComponentInvocation prev) throws InvocationException {
        if (prev != null && prev.getTransaction() != null) {
            this.delistComponentResources(prev, true);
        }
    }

    public void preInvoke() throws InvocationException {
        ComponentInvocation inv = this.invMgr.getPreviousInvocation();
        if (inv != null) {
            this.delistComponentResources(inv, true);
        }
    }

    public void postInvoke(ComponentInvocation curr, ComponentInvocation prev) throws InvocationException {
        if (curr != null && curr.getTransaction() != null) {
            this.delistComponentResources(curr, false);
        }
        if (prev != null && prev.getTransaction() != null) {
            this.enlistComponentResources(prev);
        }
    }

    public void postInvoke() throws InvocationException {
        ComponentInvocation curr = this.invMgr.getCurrentInvocation();
        ComponentInvocation prev = this.invMgr.getPreviousInvocation();
        this.delistComponentResources(curr, false);
        if (prev != null) {
            this.enlistComponentResources(prev);
        }
    }

    public void componentDestroyed(Object instance) {
        Vector v2 = this.getResourceList(instance);
        Enumeration e10 = v2.elements();
        while (e10.hasMoreElements()) {
            ResourceHandle h2 = (ResourceHandle)e10.nextElement();
            try {
                h2.getResourceAllocator().closeUserConnection(h2);
            }
            catch (PoolingException ex2) {
                // empty catch block
            }
        }
        this.resourceTable.remove(this.getInstanceKey(instance));
    }

    private Object getInstanceKey(Object instance) {
        Vector<Object> key = null;
        if (instance instanceof Servlet || instance instanceof Filter) {
            if (instance instanceof SingleThreadModel) {
                key = instance;
            } else {
                Vector<Object> pair = new Vector<Object>(2);
                pair.addElement(instance);
                pair.addElement(Thread.currentThread());
                key = pair;
            }
        } else {
            key = instance;
        }
        return key;
    }

    public Vector getResourceList(Object instance) {
        Object key = this.getInstanceKey(instance);
        Vector v2 = (Vector)this.resourceTable.get(key);
        if (v2 == null) {
            v2 = new Vector();
            this.resourceTable.put(key, v2);
        }
        return v2;
    }

    public boolean delistResource(Transaction tran, ResourceHandle h2, int flag) throws IllegalStateException, SystemException {
        if (h2.isTransactional()) {
            return tran.delistResource(h2.getXAResource(), flag);
        }
        return true;
    }

    public void registerSynchronization(Synchronization sync) throws IllegalStateException, SystemException {
        try {
            Transaction tran = this.getTransaction();
            if (tran != null) {
                tran.registerSynchronization(sync);
            }
        }
        catch (RollbackException ex2) {
            ex2.printStackTrace();
            ex2.printStackTrace(Log.err);
            throw new IllegalStateException();
        }
    }

    public void begin(int timeout) throws NotSupportedException, SystemException {
        TransactionManager transactionManager = this.tm;
        synchronized (transactionManager) {
            this.tm.setTransactionTimeout(timeout);
            this.tm.begin();
            this.tm.setTransactionTimeout(0);
        }
    }

    public void checkTransactionExport(boolean isLocal) {
    }

    public void checkTransactionImport() {
    }

    public void begin() throws NotSupportedException, SystemException {
        TransactionManager transactionManager = this.tm;
        synchronized (transactionManager) {
            this.tm.setTransactionTimeout(this.transactionTimeout);
            this.tm.begin();
            this.tm.setTransactionTimeout(0);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.tm.commit();
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.tm.getTransaction();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.tm.resume(tobj);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            seconds = 0;
        }
        this.transactionTimeout = seconds;
    }

    public Transaction suspend() throws SystemException {
        return this.tm.suspend();
    }
}

