/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.resource.ResourceHandle;
import java.util.Hashtable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;

public final class J2EETransactionManagerOpt
extends J2EETransactionManagerImpl {
    private ThreadLocal transactions = new ThreadLocal();
    private ThreadLocal localCallCounter = new ThreadLocal();
    private Hashtable globalTransactions = new Hashtable();

    public void clearThreadTx() {
        this.transactions.set(null);
    }

    public boolean enlistResource(Transaction tran, ResourceHandle h2) throws RollbackException, IllegalStateException, SystemException {
        if (!h2.isTransactional()) {
            return true;
        }
        if (!(tran instanceof J2EETransaction)) {
            return super.enlistResource(tran, h2);
        }
        J2EETransaction tx = (J2EETransaction)tran;
        if (tx.getNonXAResource() != null) {
            boolean isSameRM = false;
            try {
                isSameRM = h2.getXAResource().isSameRM(tx.getNonXAResource().getXAResource());
            }
            catch (Exception ex2) {
                throw new SystemException("isSameRM exception: " + ex2);
            }
            if (!isSameRM) {
                throw new IllegalStateException("Local transaction already has 1 non-XA Resource: cannot add more resources");
            }
        }
        if (h2.supportsXA()) {
            if (tx.isLocalTx()) {
                this.startJTSTx(tx);
            }
            return super.enlistResource(tx, h2);
        }
        if (tx.isLocalTx()) {
            tx.setNonXAResource(h2);
            try {
                h2.getXAResource().start(tx.getLocalXid(), 0);
            }
            catch (XAException ex3) {
                throw new RuntimeException("Got exception during XAResource.start:" + ex3);
            }
            this.poolmgr.resourceEnlisted(tx, h2);
            return true;
        }
        return super.enlistResource(tx, h2);
    }

    private void startJTSTx(J2EETransaction tx) throws RollbackException, IllegalStateException, SystemException {
        try {
            super.begin();
        }
        catch (NotSupportedException ex2) {
            throw new RuntimeException("Internal Error: could not start JTS transaction lazily");
        }
        Transaction jtsTx = this.tm.getTransaction();
        tx.setJTSTx(jtsTx);
        jtsTx.registerSynchronization(new JTSSynchronization(jtsTx, this));
        this.globalTransactions.put(jtsTx, tx);
    }

    public boolean delistResource(Transaction tran, ResourceHandle h2, int flag) throws IllegalStateException, SystemException {
        if (!h2.isTransactional()) {
            return true;
        }
        if (!(tran instanceof J2EETransaction)) {
            return super.delistResource(tran, h2, flag);
        }
        J2EETransaction tx = (J2EETransaction)tran;
        if (tx.isLocalTx()) {
            try {
                h2.getXAResource().end(tx.getLocalXid(), flag);
            }
            catch (XAException ex2) {
                throw new RuntimeException("Got exception during XAResource.end:" + ex2);
            }
            return true;
        }
        return super.delistResource(tx, h2, flag);
    }

    public void checkTransactionImport() {
        int[] count = (int[])this.localCallCounter.get();
        if (count != null && count[0] > 0) {
            count[0] = count[0] - 1;
            return;
        }
        this.clearThreadTx();
    }

    public void checkTransactionExport(boolean isLocal) {
        if (isLocal) {
            int[] count = (int[])this.localCallCounter.get();
            if (count == null) {
                count = new int[1];
                this.localCallCounter.set(count);
            }
            count[0] = count[0] + 1;
            return;
        }
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx == null) {
            return;
        }
        if (!tx.isLocalTx()) {
            return;
        }
        if (tx.getNonXAResource() != null) {
            throw new RuntimeException("Cannot export transaction having non-XA resource: 2-phase commit not possible.");
        }
        try {
            this.startJTSTx(tx);
        }
        catch (Exception ex2) {
            throw new RuntimeException("Unable to start JTS transaction");
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.transactions.get() != null) {
            throw new NotSupportedException("Nested transaction not supported");
        }
        if (this.tm.getStatus() != 6) {
            throw new NotSupportedException("Nested transaction not supported");
        }
        if (this.transactionTimeout > 0) {
            super.begin();
        } else {
            J2EETransaction tx = new J2EETransaction(this);
            this.transactions.set(tx);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            J2EETransaction tx = (J2EETransaction)this.transactions.get();
            if (tx != null && tx.isLocalTx()) {
                tx.commit();
            } else {
                this.tm.commit();
            }
            Object var3_2 = null;
            this.transactions.set(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.transactions.set(null);
            throw throwable;
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            J2EETransaction tx = (J2EETransaction)this.transactions.get();
            if (tx != null && tx.isLocalTx()) {
                tx.rollback();
            } else {
                this.tm.rollback();
            }
            Object var3_2 = null;
            this.transactions.set(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.transactions.set(null);
            throw throwable;
        }
    }

    public int getStatus() throws SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null && tx.isLocalTx()) {
            return tx.getStatus();
        }
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null) {
            return tx;
        }
        Transaction jtsTx = this.tm.getTransaction();
        if (jtsTx == null) {
            return null;
        }
        tx = (J2EETransaction)this.globalTransactions.get(jtsTx);
        if (tx == null) {
            tx = new J2EETransaction(this, jtsTx);
            try {
                jtsTx.registerSynchronization(new JTSSynchronization(jtsTx, this));
            }
            catch (Exception ex2) {
                throw new SystemException(ex2.toString());
            }
            this.globalTransactions.put(jtsTx, tx);
        }
        this.transactions.set(tx);
        return tx;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null && tx.isLocalTx()) {
            tx.setRollbackOnly();
        } else {
            this.tm.setRollbackOnly();
        }
    }

    public Transaction suspend() throws SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null) {
            if (!tx.isLocalTx()) {
                this.tm.suspend();
            }
            this.transactions.set(null);
            return tx;
        }
        return this.tm.suspend();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null) {
            throw new IllegalStateException("Transaction exists on current thread");
        }
        if (tobj instanceof J2EETransaction) {
            J2EETransaction j2eeTx = (J2EETransaction)tobj;
            if (!j2eeTx.isLocalTx()) {
                this.tm.resume(j2eeTx.getJTSTx());
            }
            this.transactions.set(tobj);
        } else {
            this.tm.resume(tobj);
        }
    }

    private class JTSSynchronization
    implements Synchronization {
        private Transaction jtsTx;
        private J2EETransactionManagerOpt j2eeTM;

        JTSSynchronization(Transaction jtsTx, J2EETransactionManagerOpt j2eeTM) {
            this.jtsTx = jtsTx;
            this.j2eeTM = j2eeTM;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.j2eeTM.globalTransactions.remove(this.jtsTx);
        }
    }
}

