/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.iiop.CDRInputStream;
import com.sun.corba.ee.internal.iiop.CDROutputStream;
import com.sun.corba.ee.internal.ior.IIOPProfile;
import com.sun.corba.ee.internal.ior.IIOPProfileTemplate;
import com.sun.corba.ee.internal.ior.TaggedComponent;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechList;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechListHelper;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.ServiceConfiguration;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import com.sun.corba.ee.org.omg.CSIIOP.TransportAddress;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.Utility;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class CSIV2TaggedComponentInfo {
    private static final String REALM_NAME = "default";
    private static final boolean debug = false;
    public static final int SUPPORTED_IDENTITY_TOKEN_TYPES = 15;
    private POAEJBORB orb;

    public CSIV2TaggedComponentInfo(POAEJBORB orb) {
        this.orb = orb;
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(int sslPort, EjbDescriptor desc) {
        try {
            CompoundSecMech[] mechList = this.createCompoundSecMechs(sslPort, desc);
            return this.createTaggedComponent(mechList);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            return null;
        }
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(int sslPort, boolean sslRequired) {
        try {
            CompoundSecMech[] mechList = new CompoundSecMech[1];
            org.omg.IOP.TaggedComponent comp = this.createSSLInfo(sslPort, null, sslRequired);
            AS_ContextSec asContext = this.createASContextSec(null);
            SAS_ContextSec sasContext = this.createSASContextSec(null);
            org.omg.IOP.TaggedComponent transportMech = comp;
            mechList[0] = new CompoundSecMech(0, transportMech, asContext, sasContext);
            return this.createTaggedComponent(mechList);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            return null;
        }
    }

    private org.omg.IOP.TaggedComponent createTaggedComponent(CompoundSecMech[] mechList) {
        CDROutputStream out = (CDROutputStream)this.orb.newOutputStream();
        out.putEndian();
        boolean stateful = false;
        CompoundSecMechList list = new CompoundSecMechList(stateful, mechList);
        CompoundSecMechListHelper.write((OutputStream)out, list);
        byte[] buf = out.toByteArray();
        org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(33, buf);
        return tc;
    }

    private CompoundSecMech[] createCompoundSecMechs(int sslPort, EjbDescriptor desc) throws IOException {
        Set permissions;
        Set iorDescSet = desc.getIORConfigurationDescriptors();
        int size = iorDescSet.size();
        if (size == 0 && (permissions = desc.getPermissionedRoles()).size() > 0) {
            System.out.println("Application has protected methods");
            EjbIORConfigurationDescriptor eDesc = new EjbIORConfigurationDescriptor();
            eDesc.setAuthMethodRequired(true);
            iorDescSet.add(eDesc);
            size = 1;
        }
        CompoundSecMech[] mechList = new CompoundSecMech[size];
        Iterator itr = iorDescSet.iterator();
        int i2 = 0;
        while (i2 < size) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            int target_requires = this.getTargetRequires(iorDesc);
            org.omg.IOP.TaggedComponent comp = this.createSSLInfo(sslPort, iorDesc, false);
            AS_ContextSec asContext = this.createASContextSec(iorDesc);
            SAS_ContextSec sasContext = this.createSASContextSec(iorDesc);
            int targ_req = target_requires | asContext.target_requires | sasContext.target_requires;
            org.omg.IOP.TaggedComponent transportMech = comp;
            mechList[i2] = new CompoundSecMech((short)targ_req, transportMech, asContext, sasContext);
            ++i2;
        }
        return mechList;
    }

    public boolean allMechanismsRequireSSL(Set iorDescSet) {
        int size = iorDescSet.size();
        if (size == 0) {
            return false;
        }
        Iterator itr = iorDescSet.iterator();
        int i2 = 0;
        while (i2 < size) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            int target_requires = this.getTargetRequires(iorDesc);
            if (target_requires == 0) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public AS_ContextSec createASContextSec(EjbIORConfigurationDescriptor iorDesc) throws IOException {
        AS_ContextSec asContext = null;
        int target_supports = 0;
        int target_requires = 0;
        byte[] client_authentication_mechanism = new byte[]{};
        byte[] target_name = new byte[]{};
        String authMethod = null;
        boolean authMethodRequired = false;
        if (iorDesc != null) {
            authMethod = iorDesc.getAuthenticationMethod();
            authMethodRequired = iorDesc.isAuthMethodRequired();
        }
        if (authMethod != null && authMethod.equals("none")) {
            asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
            return asContext;
        }
        target_name = GSSUtils.createExportedName(GSSUtils.GSSUP_MECH_OID, REALM_NAME.getBytes());
        target_supports = 64;
        if (authMethodRequired) {
            target_requires = 64;
        }
        client_authentication_mechanism = this.getMechanism();
        asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
        return asContext;
    }

    public SAS_ContextSec createSASContextSec(EjbIORConfigurationDescriptor iorDesc) throws IOException {
        SAS_ContextSec sasContext = null;
        int target_supports = 0;
        boolean target_requires = false;
        ServiceConfiguration[] priv = new ServiceConfiguration[]{};
        String callerPropagation = null;
        Object mechanisms = new byte[][]{};
        int supported_identity_token_type = 0;
        if (iorDesc != null) {
            callerPropagation = iorDesc.getCallerPropagation();
        }
        if (callerPropagation != null && callerPropagation.equals("none")) {
            sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
            return sasContext;
        }
        target_supports = 1024;
        byte[] upm = this.getMechanism();
        mechanisms = new byte[1][upm.length];
        int i2 = 0;
        while (i2 < upm.length) {
            mechanisms[0][i2] = upm[i2];
            ++i2;
        }
        if (target_supports != 0) {
            supported_identity_token_type = 15;
        }
        sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
        return sasContext;
    }

    private org.omg.IOP.TaggedComponent createSSLInfo(int sslport, EjbIORConfigurationDescriptor iorDesc, boolean sslRequired) {
        int targetSupports = 0;
        int targetRequires = 0;
        if (iorDesc == null) {
            targetSupports = 102;
            if (sslRequired) {
                targetRequires = 70;
            }
        } else {
            targetSupports = this.getTargetSupports(iorDesc);
            targetRequires = this.getTargetRequires(iorDesc);
            if ((targetRequires & 0x40) == 64) {
                sslport = this.orb.getServerPort("SSL_MUTUALAUTH");
            }
        }
        if ((targetSupports | targetRequires) == 0) {
            byte[] b10 = new byte[]{};
            org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(34, b10);
            return tc;
        }
        String host_name = "";
        host_name = Utility.getLocalAddress();
        TransportAddress[] listTa = this.generateTransportAddresses(host_name, sslport);
        TLS_SEC_TRANS tls_sec = new TLS_SEC_TRANS((short)targetSupports, (short)targetRequires, listTa);
        CDROutputStream out = (CDROutputStream)this.orb.newOutputStream();
        out.putEndian();
        TLS_SEC_TRANSHelper.write((OutputStream)out, tls_sec);
        byte[] buf = out.toByteArray();
        org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(36, buf);
        return tc;
    }

    private TransportAddress[] generateTransportAddresses(String host, int sslport) {
        short short_port = Utility.intToShort(sslport);
        TransportAddress ta = new TransportAddress(host, short_port);
        TransportAddress[] listTa = new TransportAddress[]{ta};
        return listTa;
    }

    public CompoundSecMech[] getSecurityMechanisms(IOR ior) {
        IIOPProfile prof = ior.getProfile();
        IIOPProfileTemplate ptemp = prof.getTemplate();
        Iterator itr = ptemp.iteratorById(33);
        if (!itr.hasNext()) {
            String msg = "TAG_CSI_SEC_MECH_LIST tagged component not found";
            return null;
        }
        Object o2 = itr.next();
        if (itr.hasNext()) {
            String msg = "More than one TAG_CSI_SEC_MECH_LIST tagged component found ";
            Log.err.println(msg);
            throw new RuntimeException(msg);
        }
        TaggedComponent tcomp = (TaggedComponent)o2;
        org.omg.IOP.TaggedComponent comp = tcomp.getIOPComponent((ORB)this.orb);
        byte[] b10 = comp.component_data;
        CDRInputStream in = (CDRInputStream)this.orb.newInputStream(b10, b10.length);
        in.consumeEndian();
        CompoundSecMechList l2 = CompoundSecMechListHelper.read((InputStream)in);
        CompoundSecMech[] list = l2.mechanism_list;
        return list;
    }

    public TLS_SEC_TRANS getSSLInformation(CompoundSecMech mech) {
        org.omg.IOP.TaggedComponent pcomp = mech.transport_mech;
        TLS_SEC_TRANS ssl = this.getSSLComponent(pcomp);
        return ssl;
    }

    private TLS_SEC_TRANS getSSLComponent(org.omg.IOP.TaggedComponent comp) {
        TLS_SEC_TRANS ssl = null;
        if (comp.tag == 34) {
            return ssl;
        }
        byte[] b10 = comp.component_data;
        CDRInputStream in = (CDRInputStream)this.orb.newInputStream(b10, b10.length);
        in.consumeEndian();
        ssl = TLS_SEC_TRANSHelper.read((InputStream)in);
        return ssl;
    }

    public int getTargetSupports(EjbIORConfigurationDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int supports = 0;
        String integrity = iorDesc.getIntegrity();
        if (!integrity.equals("none")) {
            supports |= 2;
        }
        if (!(confidentiality = iorDesc.getConfidentiality()).equals("none")) {
            supports |= 4;
        }
        if (!(establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equals("none")) {
            supports |= 0x20;
        }
        if (!(establishTrustInClient = iorDesc.getEstablishTrustInClient()).equals("none")) {
            supports |= 0x40;
        }
        return supports;
    }

    public int getTargetRequires(EjbIORConfigurationDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int requires = 0;
        String integrity = iorDesc.getIntegrity();
        if (integrity.equals("required")) {
            requires |= 2;
        }
        if ((confidentiality = iorDesc.getConfidentiality()).equals("required")) {
            requires |= 4;
        }
        if ((establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equals("required")) {
            requires |= 0x20;
        }
        if ((establishTrustInClient = iorDesc.getEstablishTrustInClient()).equals("required")) {
            requires |= 0x40;
        }
        return requires;
    }

    private byte[] getMechanism() throws IOException {
        return GSSUtils.getDER(GSSUtils.GSSUP_MECH_OID);
    }
}

