/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.connection.EndPointInfo;
import com.sun.corba.ee.connection.GetEndPointInfoAgainException;
import com.sun.corba.ee.connection.ORBSocketFactory;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.ior.IIOPAddress;
import com.sun.corba.ee.internal.ior.IIOPProfileTemplate;
import com.sun.enterprise.iiop.EndPointInfoImpl;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.J2EEKeyManager;
import com.sun.enterprise.security.KeyTool;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.Utility;
import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509KeyManager;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Properties;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.omg.CORBA.ORB;

public class IIOPSSLSocketFactory
implements ORBSocketFactory,
Serializable {
    public static final boolean debug = false;
    private static final String SECURE_PROPERTIES = "security.properties";
    private static final String CIPHER_SUITES = "enable.ciphersuites";
    private static final String CLIENT_AUTH = "enable.clientauth";
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String PERSISTENT_SSL = "PERSISTENT_SSL";
    private static final String CLEAR = "IIOP_CLEAR_TEXT";
    private static final String clientStr = "true";
    private String type = null;
    private int sslPort = 0;
    private SSLContext ctx = null;
    private String[] cipherSuites = null;
    private boolean clientAuth = false;
    private static SecureRandom sr;
    private static KeyManagerFactory keyManagerFactory;
    private static TrustManagerFactory trustManagerFactory;

    private void init() {
        try {
            if (keyManagerFactory == null || trustManagerFactory == null) {
                SSLUtils.initKeyStore();
            }
            this.ctx = SSLContext.getInstance("TLS");
            Properties cprops = Utility.getPropertiesFromFile(SECURE_PROPERTIES);
            String cs2 = cprops.getProperty(CIPHER_SUITES);
            String ca2 = cprops.getProperty(CLIENT_AUTH);
            if (cs2 != null && !cs2.trim().equals("")) {
                this.cipherSuites = TypeUtil.stringToArray(cs2, ",");
            }
            if (ca2 != null && !ca2.trim().equals("")) {
                this.clientAuth = new Boolean(ca2);
            }
            KeyManagerFactory kmf = keyManagerFactory;
            TrustManagerFactory tmf = trustManagerFactory;
            this.ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), sr);
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    private void clientInit() {
        try {
            if (keyManagerFactory == null || trustManagerFactory == null) {
                SSLUtils.initKeyStore();
            }
            this.ctx = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = keyManagerFactory;
            TrustManagerFactory tmf = trustManagerFactory;
            KeyManager[] old = kmf.getKeyManagers();
            KeyManager[] mgrs = new J2EEKeyManager[old.length];
            int i2 = 0;
            while (i2 < old.length) {
                mgrs[i2] = new J2EEKeyManager((X509KeyManager)old[i2]);
                ++i2;
            }
            this.ctx.init(mgrs, tmf.getTrustManagers(), sr);
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    public ServerSocket createServerSocket(String type, int port) throws IOException {
        if (type.equals(SSL_MUTUALAUTH) || type.equals(SSL) || type.equals(PERSISTENT_SSL)) {
            return this.createSSLServerSocket(type, port);
        }
        return new ServerSocket(port);
    }

    private ServerSocket createSSLServerSocket(String type, int port) throws IOException {
        if (this.ctx == null) {
            this.init();
        }
        SSLServerSocketFactory ssf = this.ctx.getServerSocketFactory();
        ServerSocket ss = ssf.createServerSocket(port);
        try {
            if (this.cipherSuites != null) {
                ((SSLServerSocket)ss).setEnabledCipherSuites(this.cipherSuites);
                if (type.equals(SSL_MUTUALAUTH)) {
                    ((SSLServerSocket)ss).setNeedClientAuth(true);
                }
            }
        }
        catch (Exception e10) {
            throw new IOException(e10.getMessage());
        }
        return ss;
    }

    public EndPointInfo getEndPointInfo(ORB orb, IOR ior, EndPointInfo endPointInfo) {
        try {
            POAEJBORB myOrb = (POAEJBORB)orb;
            SecurityMechanismSelector selector = new SecurityMechanismSelector();
            IIOPProfileTemplate temp = ior.getProfile().getTemplate();
            IIOPAddress primary = temp.getPrimaryAddress();
            String host = primary.getHost().toLowerCase();
            int port = 0;
            ConnectionContext ctx = new ConnectionContext();
            EndPointInfo info = selector.getSSLPort(ior, ctx);
            selector.setClientConnectionContext(ctx);
            if (info == null) {
                this.type = CLEAR;
                port = primary.getPort();
            } else {
                this.type = info.getType();
                port = info.getPort();
            }
            endPointInfo = new EndPointInfoImpl(this.type, host, port);
            return endPointInfo;
        }
        catch (Exception ex2) {
            throw new RuntimeException(ex2.getMessage());
        }
    }

    public Socket createSocket(EndPointInfo endPointInfo) throws IOException, GetEndPointInfoAgainException {
        try {
            String type = endPointInfo.getType();
            String host = endPointInfo.getHost();
            int port = endPointInfo.getPort();
            if (type.equals(SSL) || type.equals(SSL_MUTUALAUTH)) {
                return this.createSSLSocket(host, port);
            }
            return new Socket(host, port);
        }
        catch (Exception ex2) {
            throw new RuntimeException(ex2.getMessage());
        }
    }

    private Socket createSSLSocket(String host, int port) throws IOException {
        SSLSocket socket = null;
        SSLSocketFactory factory = null;
        try {
            if (clientStr != null && clientStr.equals(clientStr)) {
                if (this.ctx == null) {
                    this.clientInit();
                }
                factory = this.ctx.getSocketFactory();
            } else {
                factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            socket = (SSLSocket)factory.createSocket(host, port);
        }
        catch (Exception e10) {
            throw new IOException(e10.getMessage());
        }
        return socket;
    }

    public static void setFactories(KeyManagerFactory k2, TrustManagerFactory t2) {
        keyManagerFactory = k2;
        trustManagerFactory = t2;
    }

    static {
        KeyTool.initProvider();
        sr = J2EEServer.secureRandom;
        keyManagerFactory = null;
        trustManagerFactory = null;
    }
}

