/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.extension.ServantCachingPolicy;
import com.sun.corba.ee.internal.CosNaming.BootstrapServer;
import com.sun.corba.ee.internal.CosNaming.TransientNameService;
import com.sun.corba.ee.internal.ior.POAId;
import com.sun.corba.ee.internal.ior.POAIdArray;
import com.sun.ejb.ContainerFactory;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public final class POAProtocolMgr
extends LocalObject
implements ServantLocator,
ProtocolManager {
    private static final boolean debug = false;
    private static final int GET_TIE_EXCEPTION_CODE = 9999;
    private static final int MAPEXCEPTION_CODE = 9998;
    private static final String InitialObjectsDb = "initial.db";
    private POAEJBORB orb;
    private Switch theSwitch;
    private ContainerFactory containerFactory;
    private Hashtable codebaseTable = new Hashtable();
    private POA transientPOA;
    private POA persistentPOA;
    private String[] tname = new String[]{"TransientPOA"};
    private String[] pname = new String[]{"PersistentPOA"};
    private POAId transientPOAID = new POAIdArray(this.tname);
    private POAId persistentPOAID = new POAIdArray(this.pname);
    private static final int EJBID_OFFSET = 0;
    private static final int INSTANCEKEYLEN_OFFSET = 8;
    private static final int INSTANCEKEY_OFFSET = 12;

    public POAProtocolMgr(ORB o2) {
        this.orb = (POAEJBORB)o2;
        this.orb.protocolManager = this;
        this.theSwitch = Switch.getSwitch();
        this.containerFactory = this.theSwitch.getContainerFactory();
    }

    public POAEJBORB getORB() {
        return this.orb;
    }

    private ContainerFactory getContainerFactory() {
        if (this.containerFactory == null) {
            this.containerFactory = this.theSwitch.getContainerFactory();
        }
        return this.containerFactory;
    }

    public void initializeNaming(File dbDir, int orbInitialPort) throws Exception {
        TransientNameService nameService = new TransientNameService(this.orb);
        Object rootContext = nameService.initialNamingContext();
        Properties props = new Properties();
        File nameFile = new File(dbDir, File.separator + InitialObjectsDb);
        int initSvcPort = orbInitialPort;
        BootstrapServer bootServer = new BootstrapServer(this.orb, initSvcPort, nameFile, props);
        try {
            bootServer.start();
        }
        catch (Exception e10) {
            throw new RuntimeException("Could not initialize j2ee server. Possible cause could be another instance of the server already running.");
        }
        bootServer.addService("NameService", this.orb.object_to_string(rootContext), false);
    }

    public void initializePOAs() throws Exception {
        POA rootPOA = (POA)this.orb.resolve_initial_references("RootPOA");
        rootPOA.the_POAManager().activate();
        this.transientPOA = this.createPOA(rootPOA, true);
        this.persistentPOA = this.createPOA(rootPOA, false);
        this.persistentPOA.set_servant_manager(this);
        this.transientPOA.set_servant_manager(this);
        this.transientPOA.the_POAManager().activate();
        this.persistentPOA.the_POAManager().activate();
    }

    public boolean isEJBPOA(POAId poaId) {
        return this.transientPOAID.equals(poaId) || this.persistentPOAID.equals(poaId);
    }

    public void setPersistentServerId(int id) {
        this.orb.setPersistentServerId(id);
    }

    public void setPersistentServerPort(int port) {
        this.orb.setPersistentServerPort(port);
    }

    public void initTransactionService(String jtsclass) {
        this.orb.initTransactionService(jtsclass);
    }

    private POA createPOA(POA rootPOA, boolean trans) {
        Policy[] policy = new Policy[]{trans ? rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT) : rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), ServantCachingPolicy.getPolicy()};
        POA poa = null;
        try {
            poa = trans ? rootPOA.create_POA("TransientPOA", null, policy) : rootPOA.create_POA("PersistentPOA", null, policy);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new RuntimeException("Unable to create POA");
        }
        return poa;
    }

    public Servant preinvoke(byte[] ejbKey, POA adapter, String operation, CookieHolder cookieHolder) throws ForwardRequest {
        int keyLen = Utility.bytesToInt(ejbKey, 8);
        byte[] instanceKey = new byte[keyLen];
        System.arraycopy(ejbKey, 12, instanceKey, 0, keyLen);
        long ejbId = Utility.bytesToLong(ejbKey, 0);
        Servant servant = null;
        try {
            Remote rmiobj = this.getContainerFactory().getTargetObject(ejbId, instanceKey);
            servant = (Servant)Util.getTie((Remote)rmiobj);
        }
        catch (NoSuchObjectLocalException e10) {
            Log.err.println(e10);
            throw new OBJECT_NOT_EXIST(9999, CompletionStatus.COMPLETED_NO);
        }
        catch (RuntimeException e11) {
            Log.err.println(e11);
            throw e11;
        }
        return servant;
    }

    public void postinvoke(byte[] ejbKey, POA adapter, String operation, java.lang.Object cookie, Servant servant) {
        Remote target = null;
        if (servant != null) {
            target = ((Tie)servant).getTarget();
        }
        this.getContainerFactory().releaseTargetObject(target);
    }

    public java.lang.Object createReference(Remote remoteObj, long ejbId, byte[] instanceKey) {
        try {
            Servant tie = (Servant)Util.getTie((Remote)remoteObj);
            String repositoryId = tie._all_interfaces(null, null)[0];
            EjbDescriptor ejbDescriptor = this.getContainerFactory().getEjbDescriptor(ejbId);
            this.putCodebase(ejbDescriptor);
            byte[] ejbKey = this.createEJBKey(remoteObj, ejbId, instanceKey);
            if (this.transientPOA == null || this.persistentPOA == null) {
                this.initializePOAs();
            }
            Object obj = ejbDescriptor instanceof EjbEntityDescriptor ? this.persistentPOA.create_reference_with_id(ejbKey, repositoryId) : this.transientPOA.create_reference_with_id(ejbKey, repositoryId);
            return obj;
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new RuntimeException("Unable to create reference " + e10);
        }
    }

    public void destroyReference(Remote remoteObj, long ejbId) {
        try {
            Util.unexportObject((Remote)remoteObj);
        }
        catch (RuntimeException ex2) {
        }
        catch (Exception nsoe) {
            // empty catch block
        }
    }

    public void connectObject(Remote remoteObj) throws RemoteException {
        if (remoteObj instanceof Stub) {
            Stub stub = (Stub)remoteObj;
            stub.connect(ORBManager.getORB());
        }
    }

    public boolean isIdentical(Remote obj1, Remote obj2) {
        Stub stub1 = (Stub)obj1;
        Stub stub2 = (Stub)obj2;
        return stub1._is_equivalent((Object)stub2);
    }

    public Throwable mapException(Throwable exception) {
        if (exception instanceof NoSuchObjectException || exception instanceof NoSuchObjectLocalException) {
            return new OBJECT_NOT_EXIST(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (exception instanceof AccessException || exception instanceof AccessLocalException) {
            return new NO_PERMISSION(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (exception instanceof MarshalException) {
            return new MARSHAL(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (exception instanceof TransactionRolledbackException || exception instanceof TransactionRolledbackLocalException) {
            return new TRANSACTION_ROLLEDBACK(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (exception instanceof TransactionRequiredException || exception instanceof TransactionRequiredLocalException) {
            return new TRANSACTION_REQUIRED(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (exception instanceof InvalidTransactionException) {
            return new INVALID_TRANSACTION(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (exception instanceof EJBException) {
            EJBException ex2 = (EJBException)exception;
            return new RemoteException(ex2.getMessage(), ex2.getCausedByException());
        }
        return exception;
    }

    private byte[] createEJBKey(Remote remoteObj, long ejbId, byte[] instanceKey) {
        byte[] ejbkey = new byte[12 + instanceKey.length];
        Utility.longToBytes(ejbId, ejbkey, 0);
        Utility.intToBytes(instanceKey.length, ejbkey, 8);
        System.arraycopy(instanceKey, 0, ejbkey, 12, instanceKey.length);
        return ejbkey;
    }

    private void putCodebase(EjbDescriptor ed2) throws Exception {
        String httpURL;
        Long ejbId = new Long(ed2.getUniqueId());
        if (this.codebaseTable.containsKey(ejbId)) {
            return;
        }
        String appname = ed2.getApplication().getName();
        String relpath = "repository/" + Utility.getLocalHost() + "/applications/" + appname + "Client.jar";
        File f2 = new File(FileUtil.getAbsolutePath(relpath));
        String fileURL = f2.toURL().toString();
        if (fileURL == null) {
            return;
        }
        String jarFile = fileURL.substring(fileURL.lastIndexOf("/") + 1);
        ServerConfiguration sc = ServerConfiguration.getConfiguration();
        String codebasePort = sc.getProperty("ejb.http.port", "9191");
        String codebase = httpURL = J2EEServer.CODEBASE_PREFIX + codebasePort + "/" + jarFile;
        this.codebaseTable.put(ejbId, codebase);
    }

    String getCodebase(byte[] ejbKey) {
        if (ejbKey.length < 8) {
            return null;
        }
        long ejbId = Utility.bytesToLong(ejbKey, 0);
        return (String)this.codebaseTable.get(new Long(ejbId));
    }

    public EjbDescriptor getEjbDescriptor(byte[] ejbKey) {
        if (ejbKey.length < 8) {
            return null;
        }
        long ejbId = Utility.bytesToLong(ejbKey, 0);
        if (this.getContainerFactory() != null) {
            return this.containerFactory.getEjbDescriptor(ejbId);
        }
        return null;
    }
}

