/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextToken;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextTokenHelper;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.Logger;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import java.io.IOException;
import java.util.StringTokenizer;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;

public class GSSUPToken {
    public static final String DELIMITER = "@";
    private static boolean debug = true;
    private byte[] cdr_encoded_token = new byte[0];
    PasswordCredential pwdcred = null;

    public GSSUPToken(ORB orb, Codec codec, PasswordCredential pwdcred) {
        byte[] name_utf8 = new byte[]{};
        byte[] password_utf8 = new byte[]{};
        POAEJBORB porb = (POAEJBORB)orb;
        Logger.fine("Going to construct a GSSUPToken:");
        Logger.fine(pwdcred.toString());
        try {
            name_utf8 = pwdcred.getUser().getBytes("UTF8");
            password_utf8 = pwdcred.getPassword().getBytes("UTF8");
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
        SecurityMechanismSelector sms = new SecurityMechanismSelector();
        ConnectionContext cc2 = sms.getClientConnectionContext();
        CompoundSecMech mech = cc2.getMechanism();
        byte[] target_name = mech.as_context_mech.target_name;
        Logger.fine("Username (UTF8) " + GSSUtils.dumpHex(name_utf8));
        Logger.fine("Password (UTF8) " + GSSUtils.dumpHex(password_utf8));
        Logger.fine("Targetname      " + GSSUtils.dumpHex(target_name));
        InitialContextToken inctxToken = new InitialContextToken(name_utf8, password_utf8, target_name);
        Any a = orb.create_any();
        InitialContextTokenHelper.insert(a, inctxToken);
        try {
            this.cdr_encoded_token = codec.encode_value(a);
        }
        catch (Exception e11) {
            e11.printStackTrace();
        }
        Logger.fine("Mech specific token length (CDR encoded) = " + this.cdr_encoded_token.length);
    }

    public GSSUPToken(ORB orb, Codec codec, byte[] authtok) throws SecurityMechanismException {
        String name;
        byte[] name_utf8 = new byte[]{};
        byte[] password_utf8 = new byte[]{};
        byte[] target_name = new byte[]{};
        String username = "";
        String userpwd = "";
        String realm = "";
        byte[] encoded_token = new byte[]{};
        Logger.fine("Going to construct a GSSUPToken:");
        Logger.fine("Getting CDR encoded GSSUP mechanism token from client authentication token");
        encoded_token = GSSUtils.getMechToken(GSSUtils.GSSUP_MECH_OID, authtok);
        Logger.fine("CDR encoded mech specific token length = " + encoded_token.length);
        Any a = orb.create_any();
        try {
            a = codec.decode_value(encoded_token, InitialContextTokenHelper.type());
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
        InitialContextToken inctxToken = InitialContextTokenHelper.extract(a);
        password_utf8 = inctxToken.password;
        name_utf8 = inctxToken.username;
        target_name = inctxToken.target_name;
        Logger.fine("Username (UTF8) " + GSSUtils.dumpHex(name_utf8));
        Logger.fine("Password (UTF8) " + GSSUtils.dumpHex(password_utf8));
        Logger.fine("Targetname      " + GSSUtils.dumpHex(target_name));
        try {
            username = new String(name_utf8, "UTF8");
            userpwd = new String(password_utf8, "UTF8");
        }
        catch (Exception e11) {
            e11.printStackTrace();
        }
        int index = username.indexOf(DELIMITER);
        if (index == -1) {
            name = username;
        } else {
            if (index == 0) {
                throw new SecurityMechanismException("No name_value in username");
            }
            StringTokenizer strtok = new StringTokenizer(username, DELIMITER);
            name = strtok.nextToken();
            if (strtok.hasMoreTokens() && !(realm = strtok.nextToken()).equals("default")) {
                throw new SecurityMechanismException("Unknown realm");
            }
        }
        this.pwdcred = new PasswordCredential(name, userpwd, "default", target_name);
        Logger.fine(this.pwdcred.toString());
    }

    public byte[] getGSSToken() throws IOException {
        Logger.finer("GSSUP mech token : " + GSSUtils.dumpHex(this.cdr_encoded_token));
        byte[] gsstoken = GSSUtils.createMechIndToken(GSSUtils.GSSUP_MECH_OID, this.cdr_encoded_token);
        Logger.fine("GSSUP token length : " + gsstoken.length);
        Logger.finer("GSSUP token: " + GSSUtils.dumpHex(gsstoken));
        return gsstoken;
    }

    public PasswordCredential getPwdcred() {
        return this.pwdcred;
    }
}

