/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import java.io.IOException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class GSSUtils {
    public static ObjectIdentifier GSSUP_MECH_OID = null;
    public static ObjectIdentifier GSS_NT_EXPORT_NAME_OID = null;
    public static ObjectIdentifier GSS_NT_SCOPED_USERNAME_OID = null;

    public static String dumpHex(byte[] octets) {
        StringBuffer result = new StringBuffer("");
        int i2 = 0;
        while (i2 < octets.length) {
            String hex;
            int b10;
            if (i2 != 0 && i2 % 16 == 0) {
                result.append("\n    ");
            }
            if ((b10 = octets[i2]) < 0) {
                b10 = 256 + b10;
            }
            if ((hex = Integer.toHexString(b10)).length() == 1) {
                hex = "0" + hex;
            }
            result.append(hex + " ");
            ++i2;
        }
        return result.toString();
    }

    public static byte[] importName(ObjectIdentifier oid, byte[] externalName) throws IOException {
        IOException e10 = new IOException("Invalid Name");
        if (externalName[0] != 4) {
            throw e10;
        }
        if (externalName[1] != 1) {
            throw e10;
        }
        int mechoidlen = (externalName[2] << 8) + externalName[3];
        if (externalName.length < 4 + mechoidlen + 4) {
            throw e10;
        }
        byte[] deroid = new byte[mechoidlen];
        System.arraycopy(externalName, 4, deroid, 0, mechoidlen);
        ObjectIdentifier oid1 = GSSUtils.getOID(deroid);
        if (!oid1.equals(oid)) {
            throw e10;
        }
        int pos = 4 + mechoidlen;
        int namelen = (externalName[pos] << 24) + (externalName[pos + 1] << 16) + (externalName[pos + 2] << 8) + externalName[pos + 3];
        pos += 4;
        if (externalName.length != 4 + mechoidlen + 4 + namelen) {
            throw e10;
        }
        byte[] name = new byte[externalName.length - pos];
        System.arraycopy(externalName, pos, name, 0, externalName.length - pos);
        return name;
    }

    public static boolean verifyMechOID(ObjectIdentifier oid, byte[] externalName) throws IOException {
        IOException e10 = new IOException("Invalid Name");
        if (externalName[0] != 4) {
            throw e10;
        }
        if (externalName[1] != 1) {
            throw e10;
        }
        int mechoidlen = (externalName[2] << 8) + externalName[3];
        if (externalName.length < 4 + mechoidlen + 4) {
            throw e10;
        }
        byte[] deroid = new byte[mechoidlen];
        System.arraycopy(externalName, 4, deroid, 0, mechoidlen);
        ObjectIdentifier oid1 = GSSUtils.getOID(deroid);
        return oid1.equals(oid);
    }

    public static byte[] createExportedName(ObjectIdentifier oid, byte[] extName) throws IOException {
        byte[] oidDER = GSSUtils.getDER(oid);
        int tokensize = 4 + oidDER.length + 4 + extName.length;
        byte[] token = new byte[tokensize];
        int pos = 0;
        token[0] = 4;
        token[1] = 1;
        token[2] = (byte)(oidDER.length & 0xFF00);
        token[3] = (byte)(oidDER.length & 0xFF);
        pos = 4;
        System.arraycopy(oidDER, 0, token, pos, oidDER.length);
        pos += oidDER.length;
        int namelen = extName.length;
        token[pos++] = (byte)(namelen & 0xFF000000);
        token[pos++] = (byte)(namelen & 0xFF0000);
        token[pos++] = (byte)(namelen & 0xFF00);
        token[pos++] = (byte)(namelen & 0xFF);
        System.arraycopy(extName, 0, token, pos, namelen);
        return token;
    }

    public static byte[] getDER(ObjectIdentifier id) throws IOException {
        DerOutputStream dos = new DerOutputStream();
        dos.putOID(id);
        byte[] oid = dos.toByteArray();
        return oid;
    }

    public static ObjectIdentifier getOID(byte[] derOID) throws IOException {
        DerInputStream dis = new DerInputStream(derOID);
        ObjectIdentifier oid = dis.getOID();
        return oid;
    }

    public static byte[] createMechIndToken(ObjectIdentifier mechoid, byte[] mechtok) throws IOException {
        byte[] deroid = GSSUtils.getDER(mechoid);
        byte[] token = new byte[1 + GSSUtils.getDERLengthSize(deroid.length + mechtok.length) + deroid.length + mechtok.length];
        int index = 0;
        token[index++] = 96;
        index = GSSUtils.writeDERLength(token, index, deroid.length + mechtok.length);
        System.arraycopy(deroid, 0, token, index, deroid.length);
        System.arraycopy(mechtok, 0, token, index += deroid.length, mechtok.length);
        return token;
    }

    public static byte[] getMechToken(ObjectIdentifier oid, byte[] token) {
        byte[] mechtoken = null;
        try {
            int index = GSSUtils.verifyTokenHeader(oid, token);
            int mechtoklen = token.length - index;
            mechtoken = new byte[mechtoklen];
            System.arraycopy(token, index, mechtoken, 0, mechtoklen);
        }
        catch (IOException e10) {
            e10.printStackTrace();
        }
        return mechtoken;
    }

    private static int verifyTokenHeader(ObjectIdentifier oid, byte[] token) throws IOException {
        int toklen;
        int index = 0;
        if (token[index++] != 96) {
            throw new IOException("Defective Token");
        }
        if (token[index += GSSUtils.getDERLengthSize(toklen = GSSUtils.readDERLength(token, index))] != 6) {
            throw new IOException("Defective Token");
        }
        byte[] buf = new byte[token.length - index];
        System.arraycopy(token, index, buf, 0, token.length - index);
        ObjectIdentifier mechoid = GSSUtils.getOID(buf);
        if (!mechoid.equals(oid)) {
            throw new IOException("Defective token");
        }
        int mechoidlen = GSSUtils.getDER(oid).length;
        return index + mechoidlen;
    }

    static int getDERLengthSize(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 256) {
            return 2;
        }
        if (length < 65536) {
            return 3;
        }
        if (length < 0x1000000) {
            return 4;
        }
        return 5;
    }

    static int writeDERLength(byte[] token, int index, int length) {
        if (length < 128) {
            token[index++] = (byte)length;
        } else {
            token[index++] = (byte)(GSSUtils.getDERLengthSize(length) + 127);
            if (length >= 0x1000000) {
                token[index++] = (byte)(length >> 24);
            }
            if (length >= 65536) {
                token[index++] = (byte)(length >> 16 & 0xFF);
            }
            if (length >= 256) {
                token[index++] = (byte)(length >> 8 & 0xFF);
            }
            token[index++] = (byte)(length & 0xFF);
        }
        return index;
    }

    static int readDERLength(byte[] token, int index) {
        int sf;
        int ret = 0;
        if (((sf = token[index++]) & 0x80) == 128) {
            int nooctets = sf & 0x7F;
            while (nooctets != 0) {
                ret = (ret << 8) + (token[index++] & 0xFF);
                --nooctets;
            }
        } else {
            ret = sf;
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            byte[] len = new byte[]{-126, 1, -45};
            String name = "default";
            byte[] externalName = GSSUtils.createExportedName(GSSUP_MECH_OID, name.getBytes());
            byte[] m2 = GSSUtils.importName(GSSUP_MECH_OID, externalName);
            System.out.println("BAR:" + new String(m2));
            String msg = "dummy_gss_export_sec_context";
            byte[] foo = GSSUtils.createMechIndToken(GSSUP_MECH_OID, msg.getBytes());
            System.out.println("FOO:" + GSSUtils.dumpHex(foo));
            byte[] msg1 = GSSUtils.getMechToken(GSSUP_MECH_OID, foo);
            System.out.println("BAR:" + GSSUtils.dumpHex(msg1));
            System.out.println("BAR string: " + new String(msg1));
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    static {
        try {
            int i2 = "oid:2.23.130.1.1.1".indexOf(58);
            GSSUP_MECH_OID = new ObjectIdentifier("oid:2.23.130.1.1.1".substring(i2 + 1));
            i2 = "oid:1.3.6.1.5.6.4".indexOf(58);
            GSS_NT_EXPORT_NAME_OID = new ObjectIdentifier("oid:1.3.6.1.5.6.4".substring(i2 + 1));
            i2 = "oid:2.23.130.1.2.1".indexOf(58);
            GSS_NT_SCOPED_USERNAME_OID = new ObjectIdentifier("oid:2.23.130.1.2.1".substring(i2 + 1));
        }
        catch (IOException e10) {
            e10.printStackTrace();
        }
    }
}

