/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSI.AuthorizationElement;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import com.sun.enterprise.iiop.security.Csiv2Manager;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.iiop.security.GSSUPToken;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.Logger;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityService;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;

public class SecClientRequestInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$iiop$security$SecClientRequestInterceptor == null ? (class$com$sun$enterprise$iiop$security$SecClientRequestInterceptor = SecClientRequestInterceptor.class$("com.sun.enterprise.iiop.security.SecClientRequestInterceptor")) : class$com$sun$enterprise$iiop$security$SecClientRequestInterceptor);
    private String name;
    private String prname;
    private Codec codec;
    private ORB orb;
    private SecurityService secsvc;
    private static final boolean debug = true;
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$SecClientRequestInterceptor;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;
    static /* synthetic */ Class class$sun$security$x509$X500Name;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$X509CertificateCredential;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$AnonCredential;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$GSSUPName;

    public SecClientRequestInterceptor(String name, Codec codec) {
        this.name = name;
        this.codec = codec;
        this.prname = name + "::";
    }

    public String name() {
        return this.name;
    }

    private java.lang.Object getCred(Set credset, Class c10) {
        java.lang.Object cred = null;
        String clsname = c10.getName();
        if (credset.size() != 1) {
            Logger.severe("Found " + credset.size() + " instances of class(" + clsname);
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.inv_credlist_size", "Credential list size is not 1."));
        }
        Iterator iter = credset.iterator();
        while (iter.hasNext()) {
            cred = iter.next();
        }
        return cred;
    }

    private byte[] createAuthToken(java.lang.Object cred, Class cls) throws Exception {
        byte[] gsstoken = new byte[]{};
        byte[] cdr_gsstoken = new byte[]{};
        if ((class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecClientRequestInterceptor.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential).isAssignableFrom(cls)) {
            PasswordCredential pwdcred = (PasswordCredential)cred;
            GSSUPToken tok = new GSSUPToken(this.orb, this.codec, pwdcred);
            gsstoken = tok.getGSSToken();
        }
        return gsstoken;
    }

    private IdentityToken createIdToken(java.lang.Object cred, Class cls) throws Exception {
        IdentityToken idtok = null;
        DerOutputStream dos = new DerOutputStream();
        DerValue[] derval = new DerValue[]{};
        Any any = this.orb.create_any();
        idtok = new IdentityToken();
        if ((class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = SecClientRequestInterceptor.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name).isAssignableFrom(cls)) {
            X500Name name = (X500Name)cred;
            name.encode(dos);
            X501DistinguishedNameHelper.insert(any, dos.toByteArray());
            idtok.dn(this.codec.encode_value(any));
        } else if ((class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = SecClientRequestInterceptor.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential).isAssignableFrom(cls)) {
            X509CertificateCredential certcred = (X509CertificateCredential)cred;
            X509Certificate[] certchain = certcred.getX509CertificateChain();
            derval = new DerValue[certchain.length];
            int i2 = 0;
            while (i2 < certchain.length) {
                derval[i2] = new DerValue(certchain[i2].getEncoded());
                ++i2;
            }
            dos.putSequence(derval);
            X509CertificateChainHelper.insert(any, dos.toByteArray());
            idtok.certificate_chain(this.codec.encode_value(any));
        } else if ((class$com$sun$enterprise$iiop$security$AnonCredential == null ? (class$com$sun$enterprise$iiop$security$AnonCredential = SecClientRequestInterceptor.class$("com.sun.enterprise.iiop.security.AnonCredential")) : class$com$sun$enterprise$iiop$security$AnonCredential).isAssignableFrom(cls)) {
            idtok.anonymous(true);
        } else if ((class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecClientRequestInterceptor.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName).isAssignableFrom(cls)) {
            GSSUPName gssname = (GSSUPName)cred;
            byte[] expname = gssname.getExportedName();
            GSS_NT_ExportedNameHelper.insert(any, expname);
            idtok.principal_name(this.codec.encode_value(any));
        }
        return idtok;
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        long cContextId = 0L;
        AuthorizationElement[] cAuthzElem = new AuthorizationElement[]{};
        IdentityToken cIdentityToken = null;
        byte[] cAuthenticationToken = new byte[]{};
        byte[] cdr_encoded_saselm = new byte[]{};
        java.lang.Object cred = null;
        SecurityContext secctxt = null;
        this.secsvc = Csiv2Manager.getSecurityService();
        this.orb = ORBManager.getORB();
        if (this.secsvc == null) {
            Logger.warning("No Security Service registered. Exiting interception point");
            return;
        }
        Object effective_target = ri.effective_target();
        try {
            secctxt = this.secsvc.getSecurityContext(effective_target);
        }
        catch (InvalidMechanismException ime) {
            ime.printStackTrace();
            Logger.severe("Invalid Security Mechanism!");
            throw new RuntimeException(ime.getMessage());
        }
        catch (InvalidIdentityTokenException iite) {
            iite.printStackTrace();
            Logger.severe("Invalid Identity Token!");
            throw new RuntimeException(iite.getMessage());
        }
        if (secctxt == null) {
            return;
        }
        final SecurityContext sCtx = secctxt;
        if (secctxt.authcls != null) {
            cred = AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    return SecClientRequestInterceptor.this.getCred(sCtx.subject.getPrivateCredentials(sCtx.authcls), sCtx.authcls);
                }
            });
            try {
                cAuthenticationToken = this.createAuthToken(cred, secctxt.authcls);
            }
            catch (Exception e10) {
                e10.printStackTrace();
                Logger.severe("Exception while constructing an authentication token");
                throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_authtok_create", "Error while constructing an authentication token."));
            }
        }
        if (secctxt.identcls != null) {
            cred = this.getCred(secctxt.subject.getPublicCredentials(secctxt.identcls), secctxt.identcls);
            try {
                cIdentityToken = this.createIdToken(cred, secctxt.identcls);
            }
            catch (Exception e11) {
                e11.printStackTrace();
                Logger.severe("Exception while constructing an identity token");
                throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_idtok_create", "Error while constructing an identity token."));
            }
        } else {
            cIdentityToken = new IdentityToken();
            cIdentityToken.absent(true);
        }
        EstablishContext ec2 = new EstablishContext(cContextId, cAuthzElem, cIdentityToken, cAuthenticationToken);
        SASContextBody sasctxbody = new SASContextBody();
        sasctxbody.establish_msg(ec2);
        Any SasAny = this.orb.create_any();
        SASContextBodyHelper.insert(SasAny, sasctxbody);
        try {
            cdr_encoded_saselm = this.codec.encode_value(SasAny);
        }
        catch (Exception e12) {
            e12.printStackTrace();
            Logger.severe("CDR Encoding error for a SAS context element.");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_cdr_encode", "CDR Encoding error for a SAS context element."));
        }
        ServiceContext sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        boolean no_replace = false;
        ri.add_request_service_context(sc, no_replace);
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    private void setreplyStatus(int status, Object target) {
        this.secsvc = Csiv2Manager.getSecurityService();
        if (this.secsvc == null) {
            Logger.warning("No Security Service registered. Status not set");
            return;
        }
        this.secsvc.receivedReply(status, target);
    }

    private int mapreplyStatus(int repst) {
        int status;
        switch (repst) {
            case 0: 
            case 2: {
                status = 0;
                break;
            }
            case 3: 
            case 4: {
                status = 2;
                break;
            }
            case 1: {
                status = 1;
                break;
            }
            default: {
                status = repst;
            }
        }
        return status;
    }

    public void receive_reply(ClientRequestInfo ri) {
        ServiceContext sc = null;
        int status = -1;
        this.orb = ORBManager.getORB();
        try {
            sc = ri.get_reply_service_context(15);
        }
        catch (BAD_PARAM e10) {
            this.setreplyStatus(0, ri.effective_target());
            return;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            return;
        }
        Any a = this.orb.create_any();
        try {
            a = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
        }
        catch (Exception e11) {
            e11.printStackTrace();
            Logger.severe("CDR Decoding error for SAS context element.");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_cdr_decode", "CDR Decoding error for SAS context element."));
        }
        SASContextBody sasctxbody = SASContextBodyHelper.extract(a);
        short sasdiscr = sasctxbody.discriminator();
        if (sasdiscr != 1 && sasdiscr != 4) {
            Logger.severe("Reply message not one of  CompleteEstablishContext or ContextError.");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_not_cecec_msg", "Reply message not one of CompleteEstablishContext or ContextError."));
        }
        int st = this.mapreplyStatus(ri.reply_status());
        this.setreplyStatus(st, ri.effective_target());
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

