/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.connection.EndPointInfo;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.ior.IIOPAddress;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.iiop.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.EndPointInfoImpl;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.Utility;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import javax.security.cert.X509Certificate;
import sun.security.x509.X500Name;

public final class SecurityMechanismSelector {
    private static final String SECURE_PROPERTIES = "security.properties";
    private static final String SEND_PASSWORD = "client.sendpassword";
    private static final String CLIENT_TRUSTED_HOSTS = "client.trustedhosts";
    private static final String SERVER_TRUSTED_HOSTS = "server.trustedhosts";
    public static final String CLIENT_CONNECTION_CONTEXT = "ClientConnContext";
    public static final String SERVER_CONNECTION_CONTEXT = "ServerConnContext";
    private static final boolean debug = false;
    private static final String USE_SSL = "com.sun.enterprise.useSSL";
    private static final String NAMESERVICE_KEY = "com.sun.enterprise.nameServiceKey";
    private static boolean sendPassword = false;
    private static String[] clientTrustedHosts = null;
    private static String[] serverTrustedHosts = null;
    private static boolean useSSL = false;
    private static String nameServiceKey;
    private static LocalStringManagerImpl localStrings;
    private static POAProtocolMgr protocolMgr;
    private CompoundSecMech mechanism = null;
    private POAEJBORB orb = (POAEJBORB)ORBManager.getORB();
    private CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(this.orb);
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$GSSUPName;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;
    static /* synthetic */ Class class$com$sun$enterprise$iiop$security$AnonCredential;
    static /* synthetic */ Class class$sun$security$x509$X500Name;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$X509CertificateCredential;

    public static ServerConnectionContext getServerConnectionContext() {
        Hashtable h2 = ConnectionExecutionContext.getContext();
        ServerConnectionContext scc = (ServerConnectionContext)h2.get(SERVER_CONNECTION_CONTEXT);
        return scc;
    }

    public static void setServerConnectionContext(ServerConnectionContext scc) {
        Hashtable h2 = ConnectionExecutionContext.getContext();
        h2.put(SERVER_CONNECTION_CONTEXT, scc);
    }

    public ConnectionContext getClientConnectionContext() {
        Hashtable h2 = ConnectionExecutionContext.getContext();
        ConnectionContext scc = (ConnectionContext)h2.get(CLIENT_CONNECTION_CONTEXT);
        return scc;
    }

    public void setClientConnectionContext(ConnectionContext scc) {
        Hashtable h2 = ConnectionExecutionContext.getContext();
        h2.put(CLIENT_CONNECTION_CONTEXT, scc);
    }

    public EndPointInfo getSSLPort(IOR ior, ConnectionContext ctx) {
        if (this.isNameServiceIOR(ior)) {
            if (!useSSL) {
                return null;
            }
            IIOPAddress addr = ior.getProfile().getTemplate().getPrimaryAddress();
            EndPointInfoImpl info = new EndPointInfoImpl("SSL", addr.getHost(), addr.getPort());
            return info;
        }
        EndPointInfoImpl info = null;
        try {
            this.mechanism = this.selectSecurityMechanism(ior);
        }
        catch (SecurityMechanismException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        ctx.setIOR(ior);
        ctx.setMechanism(this.mechanism);
        if (this.mechanism == null) {
            return null;
        }
        TLS_SEC_TRANS ssl = this.ctc.getSSLInformation(this.mechanism);
        if (ssl == null) {
            return null;
        }
        short targetRequires = ssl.target_requires;
        short targetSupports = ssl.target_supports;
        if (this.isSet(targetRequires, 2) || this.isSet(targetRequires, 4) || this.isSet(targetRequires, 64)) {
            ctx.setSSLUsed(true);
            String type = "SSL";
            if (this.isSet(targetRequires, 64)) {
                type = "SSL_MUTUALAUTH";
                ctx.setSSLClientAuthenticationOccurred(true);
            }
            short sslport = ssl.addresses[0].port;
            int ssl_port = Utility.shortToInt(sslport);
            String host_name = ssl.addresses[0].host_name;
            info = new EndPointInfoImpl(type, host_name, ssl_port);
            return info;
        }
        if (this.isSet(targetSupports, 2) || this.isSet(targetSupports, 4) || this.isSet(targetSupports, 64)) {
            if (this.clientPrefersSSL(ior)) {
                ctx.setSSLUsed(true);
                short sslport = ssl.addresses[0].port;
                String host_name = ssl.addresses[0].host_name;
                int ssl_port = Utility.shortToInt(sslport);
                info = new EndPointInfoImpl("SSL", host_name, ssl_port);
                return info;
            }
            return null;
        }
        return null;
    }

    private boolean isNameServiceIOR(IOR ior) {
        byte[] objKey = ior.getProfile().getObjectId().getId();
        String strKey = new String(objKey);
        return strKey.equals("NameService") || strKey.equals("INIT") || strKey.equals(nameServiceKey);
    }

    private boolean clientPrefersSSL(IOR ior) {
        return useSSL;
    }

    public SecurityContext selectSecurityContext(IOR ior) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext context = null;
        ConnectionContext cc2 = this.getClientConnectionContext();
        if (cc2 == null) {
            return null;
        }
        this.mechanism = cc2.getMechanism();
        if (this.mechanism == null) {
            return null;
        }
        boolean sslUsed = cc2.getSSLUsed();
        boolean clientAuthOccurred = cc2.getSSLClientAuthenticationOccurred();
        InvocationManager im = Switch.getSwitch().getInvocationManager();
        if (im == null) {
            context = this.getSecurityContextForAppClient(null, sslUsed, clientAuthOccurred);
            return context;
        }
        ComponentInvocation ci2 = null;
        try {
            ci2 = im.getCurrentInvocation();
        }
        catch (InvocationException ie) {
            return null;
        }
        Object obj = ci2.getContainerContext();
        context = obj instanceof AppContainer ? this.getSecurityContextForAppClient(ci2, sslUsed, clientAuthOccurred) : this.getSecurityContextForWebOrEJB(ci2, sslUsed, clientAuthOccurred);
        return context;
    }

    public SecurityContext getSecurityContextForAppClient(ComponentInvocation ci2, boolean sslUsed, boolean clientAuthOccurred) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        SecurityContext ctx = null;
        boolean plainIIOP = true;
        if (!sslUsed) {
            ctx = this.sendUsernameAndPassword(plainIIOP, ci2);
        } else if (!clientAuthOccurred) {
            plainIIOP = false;
            ctx = this.sendUsernameAndPassword(plainIIOP, ci2);
        } else {
            return null;
        }
        return ctx;
    }

    public SecurityContext getSecurityContextForWebOrEJB(ComponentInvocation ci2, boolean sslUsed, boolean clientAuthOccurred) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        SecurityContext ctx = null;
        boolean plainIIOP = true;
        boolean sslClientAuth = false;
        if (!sslUsed) {
            ctx = this.propagateIdentity(plainIIOP, sslClientAuth, ci2);
        } else if (!clientAuthOccurred) {
            plainIIOP = false;
            ctx = this.propagateIdentity(plainIIOP, sslClientAuth, ci2);
        } else {
            plainIIOP = false;
            sslClientAuth = true;
            ctx = this.propagateIdentity(plainIIOP, sslClientAuth, ci2);
        }
        return ctx;
    }

    private boolean isMechanismSupported(SAS_ContextSec sas) {
        byte[][] mechanisms = sas.supported_naming_mechanisms;
        byte[] mechSupported = new byte[]{};
        try {
            mechSupported = GSSUtils.getDER(GSSUtils.GSSUP_MECH_OID);
        }
        catch (Exception e10) {
            return false;
        }
        if (mechanisms[0].length != mechSupported.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < mechanisms[0].length) {
            if (mechanisms[0][i2] != mechSupported[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean isIdentityTypeSupported(SAS_ContextSec sas) {
        int ident_token = sas.supported_identity_types;
        int value = ident_token & 0xF;
        return value != 0;
    }

    private SecurityContext sendUsernameAndPassword(boolean plainIIOP, ComponentInvocation ci2) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (this.mechanism == null) {
            return null;
        }
        AS_ContextSec asContext = this.mechanism.as_context_mech;
        if (!this.isSet(asContext.target_requires, 64)) {
            return null;
        }
        ctx = this.setUsernameAndPassword(plainIIOP, ci2);
        return ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityContext propagateIdentity(boolean plainIIOP, boolean clientAuth, ComponentInvocation ci2) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext ctx = null;
        if (this.mechanism == null) {
            return null;
        }
        AS_ContextSec asContext = this.mechanism.as_context_mech;
        SAS_ContextSec sasContext = this.mechanism.sas_context_mech;
        if (this.isSet(asContext.target_requires, 64)) {
            ctx = this.setUsernameAndPassword(plainIIOP, ci2);
            if (ctx.authcls != null) return ctx;
            String errmsg = localStrings.getLocalString("securitymechansimselector.runas_cannot_propagate_username_password", "Cannot propagate username/password required by target when using run as identity");
            Log.err.println(errmsg);
            throw new SecurityMechanismException(errmsg);
        }
        if (this.isSet(sasContext.target_supports, 1024) || this.isSet(sasContext.target_requires, 1024)) {
            if (!this.isIdentityTypeSupported(sasContext)) {
                String errmsg = localStrings.getLocalString("securitymechanismselector.invalid_identity_type", "The given identity token is unsupported.");
                throw new InvalidIdentityTokenException(errmsg);
            }
            if (sasContext.target_supports != 1024) return this.getIdentity();
            if (this.isMechanismSupported(sasContext)) return this.getIdentity();
            String errmsg = localStrings.getLocalString("securitymechanismselector.invalid_mechanism", "The given mechanism type is unsupported.");
            Log.err.println(errmsg);
            throw new InvalidMechanismException(errmsg);
        }
        if (!this.isSet(asContext.target_supports, 64)) return null;
        if (!clientAuth) return null;
        ctx = this.setUsernameAndPassword(plainIIOP, ci2);
        if (ctx.authcls != null) return ctx;
        return null;
    }

    private SecurityContext setUsernameAndPassword(boolean plainIIOP, ComponentInvocation ci2) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (plainIIOP && sendPassword && this.isServerTrusted()) {
            ctx = this.getUsernameAndPassword(ci2);
        } else if (!plainIIOP && this.isServerTrusted()) {
            ctx = this.getUsernameAndPassword(ci2);
        } else {
            String msg = "Cannot send authentication information because ";
            msg = plainIIOP && !sendPassword ? msg + " client policy does not allow password to " + " be sent over plain IIOP" : msg + " client does not trust the server " + " to send password over IIOP";
            throw new SecurityMechanismException(msg);
        }
        return ctx;
    }

    private boolean isServerTrusted() {
        String star = "*";
        int i2 = 0;
        while (i2 < serverTrustedHosts.length) {
            if (serverTrustedHosts[i2].length() == 1 && serverTrustedHosts[i2].equals(star)) {
                return true;
            }
            ++i2;
        }
        ConnectionContext scc = this.getClientConnectionContext();
        if (scc != null) {
            Socket skt = scc.getSocket();
            InetAddress adr = skt.getInetAddress();
            return this.isDomainInTrustedList(adr, serverTrustedHosts);
        }
        return false;
    }

    private boolean isDomainInTrustedList(InetAddress inetAddress, String[] trusted) throws SecurityException {
        boolean isTrusted = false;
        String domain = null;
        String star = "*";
        String dot = ".";
        try {
            domain = inetAddress.getHostName();
        }
        catch (Exception e10) {
            System.err.println(" Could not lookup the domain name of IP  address = " + inetAddress.getHostAddress());
            return false;
        }
        String[] domainTok = TypeUtil.stringToArray(domain, dot);
        int i2 = 0;
        while (i2 < trusted.length) {
            String[] toksList = TypeUtil.stringToArray(trusted[i2], dot);
            if (toksList.length != domainTok.length) {
                isTrusted = false;
            } else {
                int j2 = toksList.length - 1;
                while (j2 >= 0) {
                    if (toksList[j2].equals(domainTok[j2])) {
                        isTrusted = true;
                    } else if (toksList[j2].equals(star)) {
                        isTrusted = true;
                    } else {
                        isTrusted = false;
                        break;
                    }
                    --j2;
                }
                if (isTrusted) {
                    return isTrusted;
                }
            }
            ++i2;
        }
        return isTrusted;
    }

    private SecurityContext getUsernameAndPassword(ComponentInvocation ci2) throws SecurityMechanismException {
        try {
            Subject s2 = null;
            if (ci2 == null) {
                ClientSecurityContext sc = ClientSecurityContext.getCurrent();
                if (sc == null) {
                    return null;
                }
                s2 = sc.getSubject();
            } else {
                ClientSecurityContext sc;
                Object obj = ci2.getContainerContext();
                s2 = obj instanceof AppContainer ? ((sc = ClientSecurityContext.getCurrent()) == null ? LoginContextDriver.doClientLogin(1, AppContainer.handler) : sc.getSubject()) : this.getSubjectFromSecurityCurrent();
            }
            SecurityContext ctx = new SecurityContext();
            final Subject sub = s2;
            ctx.subject = s2;
            Set privateCredSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return sub.getPrivateCredentials();
                }
            });
            if (privateCredSet.isEmpty()) {
                ctx.authcls = null;
                ctx.identcls = class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName;
            } else {
                ctx.authcls = class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential;
            }
            return ctx;
        }
        catch (Exception e10) {
            e10.printStackTrace();
            return null;
        }
    }

    private SecurityContext getIdentity() throws SecurityMechanismException {
        Subject s2;
        SecurityContext ctx;
        final SecurityContext sCtx = ctx = new SecurityContext();
        com.sun.enterprise.security.SecurityContext scontext = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (scontext == null || scontext.didServerGenerateCredentials()) {
            sCtx.identcls = class$com$sun$enterprise$iiop$security$AnonCredential == null ? (class$com$sun$enterprise$iiop$security$AnonCredential = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.AnonCredential")) : class$com$sun$enterprise$iiop$security$AnonCredential;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject sub;
                    sCtx.subject = sub = new Subject();
                    sCtx.subject.getPublicCredentials().add(new AnonCredential());
                    return null;
                }
            });
            return sCtx;
        }
        ctx.subject = s2 = this.getSubjectFromSecurityCurrent();
        final Subject sub = s2;
        Set credSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;

            public Object run() {
                return sub.getPrivateCredentials(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = 3.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        if (credSet.size() == 1) {
            Subject subj;
            ctx.identcls = class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName;
            final Set cs2 = credSet;
            ctx.subject = subj = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject ss = new Subject();
                    Iterator iter = cs2.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    GSSUPName gssname = new GSSUPName(pc.getUser(), pc.getRealm());
                    ss.getPublicCredentials().add(gssname);
                    return ss;
                }
            });
            return ctx;
        }
        credSet = s2.getPublicCredentials();
        if (credSet.size() != 1) {
            System.err.println("Principal propagation: Cannot find principal information in subject");
            return null;
        }
        Iterator credIter = credSet.iterator();
        if (credIter.hasNext()) {
            Object o2 = credIter.next();
            ctx.identcls = o2 instanceof GSSUPName ? (class$com$sun$enterprise$iiop$security$GSSUPName == null ? (class$com$sun$enterprise$iiop$security$GSSUPName = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.GSSUPName")) : class$com$sun$enterprise$iiop$security$GSSUPName) : (o2 instanceof X500Name ? (class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = SecurityMechanismSelector.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name) : (class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential));
        } else {
            System.err.println("Principal propagation: Cannot find credential information in subject. ");
            return null;
        }
        return ctx;
    }

    private Subject getSubjectFromSecurityCurrent() throws SecurityMechanismException {
        com.sun.enterprise.security.SecurityContext sc = null;
        sc = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (sc == null) {
            System.out.println(" SETTING GUEST ---");
            sc = com.sun.enterprise.security.SecurityContext.init();
        }
        if (sc == null) {
            throw new SecurityMechanismException("Could not find  security information");
        }
        Subject s2 = sc.getSubject();
        if (s2 == null) {
            throw new SecurityMechanismException("Could not find  subject information in the security context.");
        }
        return s2;
    }

    public CompoundSecMech selectSecurityMechanism(IOR ior) throws SecurityMechanismException {
        CompoundSecMech[] mechList = this.ctc.getSecurityMechanisms(ior);
        CompoundSecMech mech = this.selectSecurityMechanism(mechList);
        return mech;
    }

    private CompoundSecMech selectSecurityMechanism(CompoundSecMech[] mechList) throws SecurityMechanismException {
        if (mechList == null || mechList.length == 0) {
            return null;
        }
        CompoundSecMech mech = null;
        int i2 = 0;
        while (i2 < mechList.length) {
            mech = mechList[i2];
            boolean useMech = this.useMechanism(mech);
            if (useMech) {
                return mech;
            }
            ++i2;
        }
        throw new SecurityMechanismException("Cannot use any of the  target's supported mechanisms");
    }

    private boolean useMechanism(CompoundSecMech mech) {
        boolean val = true;
        TLS_SEC_TRANS tls = this.ctc.getSSLInformation(mech);
        if (tls == null) {
            return true;
        }
        short targetRequires = tls.target_requires;
        if (this.isSet(targetRequires, 64) && !SSLUtils.isClientKeyStoreAvailable()) {
            val = false;
        }
        return val;
    }

    private byte[] getTargetName(Subject subj) {
        byte[] tgt_name = new byte[]{};
        final Subject sub = subj;
        final Set credset = (Set)AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;

            public Object run() {
                return sub.getPrivateCredentials(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = 5.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        if (credset.size() == 1) {
            tgt_name = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iter = credset.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    return pc.getTargetName();
                }
            });
        }
        return tgt_name;
    }

    private boolean evaluate_client_conformance_ssl(EjbIORConfigurationDescriptor iordesc, boolean ssl_used, X509Certificate[] certchain) {
        boolean ssl_required = false;
        boolean ssl_supported = false;
        int ssl_target_requires = 0;
        int ssl_target_supports = 0;
        ssl_target_requires = this.ctc.getTargetRequires(iordesc);
        ssl_target_supports = this.ctc.getTargetSupports(iordesc);
        ssl_required = this.isSet(ssl_target_requires, 2) || this.isSet(ssl_target_requires, 4) || this.isSet(ssl_target_requires, 64);
        ssl_supported = ssl_target_supports != 0;
        if (ssl_used ? !ssl_required && !ssl_supported : ssl_required) {
            return false;
        }
        return !(certchain != null ? !this.isSet(ssl_target_requires, 64) && !this.isSet(ssl_target_supports, 64) : this.isSet(ssl_target_requires, 64));
    }

    private boolean evaluate_client_conformance_ascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc) {
        boolean client_authenticated = false;
        AS_ContextSec ascontext = null;
        try {
            ascontext = this.ctc.createASContextSec(iordesc);
        }
        catch (Exception e10) {
            return false;
        }
        if (ascontext == null) {
            return false;
        }
        client_authenticated = ctx != null && ctx.authcls != null && ctx.subject != null;
        if (client_authenticated) {
            if (!this.isSet(ascontext.target_requires, 64) && !this.isSet(ascontext.target_supports, 64)) {
                return false;
            }
            byte[] client_tgtname = this.getTargetName(ctx.subject);
            if (ascontext.target_name.length != client_tgtname.length) {
                return false;
            }
            int i2 = 0;
            while (i2 < ascontext.target_name.length) {
                if (ascontext.target_name[i2] != client_tgtname[i2]) {
                    return false;
                }
                ++i2;
            }
        } else if (this.isSet(ascontext.target_requires, 64)) {
            return false;
        }
        return true;
    }

    private boolean evaluate_client_conformance_sascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc) {
        boolean caller_propagated = false;
        SAS_ContextSec sascontext = null;
        try {
            sascontext = this.ctc.createSASContextSec(iordesc);
        }
        catch (Exception e10) {
            return false;
        }
        if (sascontext == null) {
            return false;
        }
        caller_propagated = ctx != null && ctx.identcls != null && ctx.subject != null;
        if (caller_propagated) {
            return this.isSet(sascontext.target_supports, 1024);
        }
        return true;
    }

    private boolean evaluate_client_conformance(SecurityContext ctx, byte[] object_id, boolean ssl_used, X509Certificate[] certchain) {
        if (object_id == null) {
            return true;
        }
        if (protocolMgr == null) {
            protocolMgr = (POAProtocolMgr)Switch.getSwitch().getProtocolManager();
        }
        if (protocolMgr == null) {
            return true;
        }
        EjbDescriptor ejbDesc = protocolMgr.getEjbDescriptor(object_id);
        if (ejbDesc == null) {
            return true;
        }
        Set iorDescSet = ejbDesc.getIORConfigurationDescriptors();
        if (iorDescSet.isEmpty()) {
            return true;
        }
        Iterator itr = iorDescSet.iterator();
        while (itr.hasNext()) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            if (!this.evaluate_client_conformance_ssl(iorDesc, ssl_used, certchain) || !this.evaluate_client_conformance_ascontext(ctx, iorDesc) || !this.evaluate_client_conformance_sascontext(ctx, iorDesc)) continue;
            return true;
        }
        return false;
    }

    public SecurityContext evaluateTrust(SecurityContext ctx, byte[] object_id) throws SecurityMechanismException {
        SecurityContext ssc = null;
        Socket socket = null;
        boolean ssl_used = false;
        X509Certificate[] certChain = null;
        ServerConnectionContext scc = SecurityMechanismSelector.getServerConnectionContext();
        if (scc != null && (socket = scc.getSocket()) != null && socket instanceof SSLSocket) {
            ssl_used = true;
            SSLSocket sslSock = (SSLSocket)socket;
            SSLSession sslSession = sslSock.getSession();
            try {
                certChain = sslSession.getPeerCertificateChain();
            }
            catch (Exception e10) {
                // empty catch block
            }
        }
        if (socket == null && ctx == null) {
            return null;
        }
        if (!this.evaluate_client_conformance(ctx, object_id, ssl_used, certChain)) {
            String msg = "Trust evaluation failed because ";
            msg = msg + "client does not conform to configured security policies";
            throw new SecurityMechanismException(msg);
        }
        if (ctx == null) {
            if (socket == null || !ssl_used || certChain == null) {
                return null;
            }
            ssc = new SecurityContext();
            X500Name x500Name = (X500Name)certChain[0].getSubjectDN();
            ssc.subject = new Subject();
            ssc.subject.getPublicCredentials().add(x500Name);
            ssc.identcls = class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = SecurityMechanismSelector.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name;
            ssc.authcls = null;
            return ssc;
        }
        ssc = ctx;
        Class authCls = ctx.authcls;
        Class identCls = ctx.identcls;
        ssc.subject = ctx.subject;
        ssc.authcls = null;
        ssc.identcls = null;
        if (identCls != null) {
            ssc.identcls = identCls;
        } else if (authCls != null) {
            ssc.authcls = authCls;
        } else {
            ssc.identcls = class$com$sun$enterprise$iiop$security$AnonCredential == null ? (class$com$sun$enterprise$iiop$security$AnonCredential = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.AnonCredential")) : class$com$sun$enterprise$iiop$security$AnonCredential;
        }
        return ssc;
    }

    private boolean isSet(int val1, int val2) {
        return (val1 & val2) == val2;
    }

    private void debug(String msg) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor == null ? (class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor = SecurityMechanismSelector.class$("com.sun.enterprise.iiop.security.SecServerRequestInterceptor")) : class$com$sun$enterprise$iiop$security$SecServerRequestInterceptor);
        protocolMgr = null;
        Properties props = null;
        try {
            String sth;
            String cth;
            props = Utility.getPropertiesFromFile(SECURE_PROPERTIES);
            String sp = props.getProperty(SEND_PASSWORD);
            if (sp != null && !sp.trim().equals("")) {
                sendPassword = new Boolean(sp);
            }
            if ((cth = props.getProperty(CLIENT_TRUSTED_HOSTS)) != null && !cth.trim().equals("")) {
                clientTrustedHosts = TypeUtil.stringToArray(cth, ",");
            }
            if ((sth = props.getProperty(SERVER_TRUSTED_HOSTS)) != null && !sth.trim().equals("")) {
                serverTrustedHosts = TypeUtil.stringToArray(sth, ",");
            }
            useSSL = new Boolean(System.getProperty(USE_SSL));
            nameServiceKey = System.getProperty(NAMESERVICE_KEY);
        }
        catch (IOException e10) {
            e10.printStackTrace();
        }
    }
}

