/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.jms.spi.ExternalManager;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;

public class ExternalManagerImpl
implements ExternalManager {
    private PrintWriter errorLog;
    private PrintWriter outputLog;
    private PrintWriter eventLog;
    private boolean autoRecover;
    private static final String JMS_APP_NAME = "jms";
    private static final String JMS_APP_TYPE = "jms";
    private static final String AUTO_RECOVERABLE_PROP = "distributed.transaction.recovery";

    public ExternalManagerImpl() throws Exception {
        File logDir = LogUtil.getLogDirectory("jms", "jms");
        this.errorLog = new PrintWriter((Writer)LogUtil.getLog(logDir, "error.log"), true);
        LogUtil.printInfo(this.errorLog);
        this.outputLog = new PrintWriter((Writer)LogUtil.getLog(logDir, "output.log"), true);
        LogUtil.printInfo(this.outputLog);
        this.eventLog = new PrintWriter((Writer)LogUtil.getLog(logDir, "event.log"), true);
        LogUtil.printInfo(this.eventLog);
        ServerConfiguration serverConfig = ServerConfiguration.getConfiguration();
        String autoRecoverProp = serverConfig.getProperty(AUTO_RECOVERABLE_PROP);
        this.autoRecover = autoRecoverProp.equals("true");
    }

    public void authenticate(String username, String password) throws GeneralSecurityException {
        final String uname = username;
        final String pass = password;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LoginContextDriver.login(uname, pass);
                    return null;
                }
            });
        }
        catch (LoginException le) {
            Log.err.println(le);
            throw new GeneralSecurityException(le.getMessage());
        }
    }

    public boolean getAutoRecover() {
        return this.autoRecover;
    }

    public PrintWriter getErrorLog() {
        return this.errorLog;
    }

    public PrintWriter getOutputLog() {
        return this.outputLog;
    }

    public PrintWriter getEventLog() {
        return this.eventLog;
    }
}

