/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.jms.ExternalManagerImpl;
import com.sun.enterprise.jms.JmsConfig;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jms.spi.JMSAdmin;
import com.sun.jms.spi.JMSAdminFactory;
import com.sun.jms.spi.JMSManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class JmsUtil {
    public static final String CONTAINER_XA_QUEUE_CF = "ContainerXAQueueConnectionFactory";
    public static final String CONTAINER_XA_TOPIC_CF = "ContainerXATopicConnectionFactory";
    private static final String JMS_MANAGER_CLASS = "service.jmsmanager.class";
    private static final String JMS_ADMIN_FACTORY_CLASS = "service.jmsadminfactory.class";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$jms$JmsUtil == null ? (class$com$sun$enterprise$jms$JmsUtil = JmsUtil.class$("com.sun.enterprise.jms.JmsUtil")) : class$com$sun$enterprise$jms$JmsUtil);
    private static final boolean debug = false;
    static /* synthetic */ Class class$com$sun$enterprise$jms$JmsUtil;

    public static String getXAConnectionFactoryName(String connectionFactoryName) {
        return "JMSXA" + connectionFactoryName;
    }

    public static String getDestinationName(Destination destination) {
        String name = null;
        try {
            name = destination instanceof Queue ? ((Queue)destination).getQueueName() : ((Topic)destination).getTopicName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public static JMSManager getJMSManager() throws Exception {
        JMSManager jmsManager = null;
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String jmsManagerClassName = config.getProperty(JMS_MANAGER_CLASS);
        Class<?> jmsManagerClass = Class.forName(jmsManagerClassName);
        jmsManager = (JMSManager)jmsManagerClass.newInstance();
        ExternalManagerImpl externalManager = new ExternalManagerImpl();
        jmsManager.setExternalManager(externalManager);
        return jmsManager;
    }

    public static JMSAdminFactory getJMSAdminFactory() throws Exception {
        JMSAdminFactory jmsAdminFactory = null;
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String jmsAdminFactoryClassName = config.getProperty(JMS_ADMIN_FACTORY_CLASS);
        Class<?> jmsAdminFactoryClass = Class.forName(jmsAdminFactoryClassName);
        jmsAdminFactory = (JMSAdminFactory)jmsAdminFactoryClass.newInstance();
        return jmsAdminFactory;
    }

    public static void validateJMSSelector(String selector) throws Exception, JMSException {
        JMSAdminFactory jmsAdminFactory = JmsUtil.getJMSAdminFactory();
        JMSAdmin jmsAdmin = jmsAdminFactory.getJMSAdmin("dummy");
        jmsAdmin.validateJMSSelector(selector);
    }

    public static Destination getDestinationByName(String destName, Set destinations) {
        Destination destination = null;
        Iterator iter = destinations.iterator();
        while (iter.hasNext()) {
            Destination next = (Destination)iter.next();
            String nextName = null;
            nextName = JmsUtil.getDestinationName(next);
            if (nextName == null || !nextName.equals(destName)) continue;
            destination = next;
            break;
        }
        return destination;
    }

    public static JMSManager startJmsService() throws Exception {
        JMSManager jmsManager;
        System.out.println(localStrings.getLocalString("jms.start", "Starting JMS service... "));
        try {
            jmsManager = JmsUtil.getJMSManager();
            jmsManager.startJMSService();
            JmsConfig jmsConfig = new JmsConfig(1);
            J2EEResourceFactory resourceFactory = ServerConfiguration.getJ2EEResourceFactory();
            J2EEResourceCollection resources = resourceFactory.loadDefaultResourceCollection();
            Set jmsDestinations = resources.getResourcesByType(1);
            Iterator iter = jmsDestinations.iterator();
            while (iter.hasNext()) {
                JmsDestinationResource next = (JmsDestinationResource)iter.next();
                jmsConfig.createDestination(next.getName(), next.getIsQueue());
                System.out.println(localStrings.getLocalString("jms.binding", "Binding: ") + next);
            }
            Set jmsCnxFactories = resources.getResourcesByType(2);
            Iterator iter2 = jmsCnxFactories.iterator();
            while (iter2.hasNext()) {
                JmsCnxFactoryResource next = (JmsCnxFactoryResource)iter2.next();
                HashMap<String, Object> propsMap = new HashMap<String, Object>();
                Iterator propsIter = next.getProperties().iterator();
                while (propsIter.hasNext()) {
                    ResourceProperty nextProp = (ResourceProperty)propsIter.next();
                    propsMap.put(nextProp.getName(), nextProp.getValue());
                }
                jmsConfig.createConnectionFactory(next.getName(), next.getIsQueue(), propsMap);
                System.out.println(localStrings.getLocalString("jms.binding", "Binding: ") + next);
            }
            jmsConfig.createXAConnectionFactory(CONTAINER_XA_QUEUE_CF, true);
            jmsConfig.createXAConnectionFactory(CONTAINER_XA_TOPIC_CF, false);
        }
        catch (Exception e10) {
            System.out.println(localStrings.getLocalString("jms.start.failed", "Couldn't start JMS service... "));
            e10.printStackTrace();
            throw e10;
        }
        return jmsManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

