/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.jms.ConnectionWrapper;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.jms.SessionWrapper;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jms.spi.xa.JMSXAQueueSession;
import com.sun.jms.spi.xa.JMSXASession;
import com.sun.jms.spi.xa.JMSXATopicSession;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class SessionWrapperBase
implements SessionWrapper {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$jms$SessionWrapperBase == null ? (class$com$sun$enterprise$jms$SessionWrapperBase = SessionWrapperBase.class$("com.sun.enterprise.jms.SessionWrapperBase")) : class$com$sun$enterprise$jms$SessionWrapperBase);
    private static final boolean debug = false;
    private JMSXASession delegateXA_;
    private JmsWrapperFactory wrapperFactory_;
    private ConnectionWrapper parent_;
    private ResourceHandle resourceHandle_;
    private boolean closed_;
    static /* synthetic */ Class class$com$sun$enterprise$jms$SessionWrapperBase;

    public SessionWrapperBase(JMSXASession delegate, JmsWrapperFactory wrapperFactory, ConnectionWrapper parent) {
        this.delegateXA_ = delegate;
        this.wrapperFactory_ = wrapperFactory;
        this.parent_ = parent;
        this.resourceHandle_ = null;
        this.closed_ = false;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getDelegate().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getDelegate().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getDelegate().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getDelegate().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.getDelegate().createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getDelegate().createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getDelegate().createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.getDelegate().createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        return this.getDelegate().getTransacted();
    }

    public void commit() throws JMSException {
        this.getDelegate().commit();
    }

    public void rollback() throws JMSException {
        this.getDelegate().rollback();
    }

    public void close() throws JMSException {
        SessionWrapperBase sessionWrapperBase = this;
        synchronized (sessionWrapperBase) {
            if (this.closed_) {
                return;
            }
            this.closed_ = true;
        }
        Switch theSwitch = Switch.getSwitch();
        if (this.resourceHandle_ != null) {
            PoolManager poolMgr = theSwitch.getPoolManager();
            poolMgr.unregisterResource(this.resourceHandle_, 0x4000000);
            this.resourceHandle_ = null;
        }
        JMSException jmsException = null;
        try {
            this.getDelegateXA().close();
        }
        catch (JMSException jmse) {
            jmsException = jmse;
        }
        this.parent_.sessionClosed(this);
        if (jmsException != null) {
            throw jmsException;
        }
    }

    public void recover() throws JMSException {
        this.getDelegate().recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getDelegate().getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.getDelegate().setMessageListener(listener);
    }

    public void run() {
        String errorMsg = localStrings.getLocalString("jms.invalid.operation", "Operation not allowed");
        throw new IllegalStateException(errorMsg);
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.getQueueDelegate().createQueue(queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        QueueReceiver receiver = this.getQueueDelegate().createReceiver(queue);
        return this.wrapperFactory_.createQueueReceiverWrapper(receiver);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        QueueReceiver receiver = this.getQueueDelegate().createReceiver(queue, messageSelector);
        return this.wrapperFactory_.createQueueReceiverWrapper(receiver);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return this.getQueueDelegate().createSender(queue);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.getQueueDelegate().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.getQueueDelegate().createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getQueueDelegate().createTemporaryQueue();
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.getTopicDelegate().createTopic(topicName);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        TopicSubscriber subscriber = this.getTopicDelegate().createSubscriber(topic);
        return this.wrapperFactory_.createTopicSubscriberWrapper(subscriber);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        TopicSubscriber subscriber = this.getTopicDelegate().createSubscriber(topic, messageSelector, noLocal);
        return this.wrapperFactory_.createTopicSubscriberWrapper(subscriber);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        TopicSubscriber subscriber = this.getTopicDelegate().createDurableSubscriber(topic, name);
        return this.wrapperFactory_.createTopicSubscriberWrapper(subscriber);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        TopicSubscriber subscriber = this.getTopicDelegate().createDurableSubscriber(topic, name, messageSelector, noLocal);
        return this.wrapperFactory_.createTopicSubscriberWrapper(subscriber);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return this.getTopicDelegate().createPublisher(topic);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getTopicDelegate().createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.getTopicDelegate().unsubscribe(name);
    }

    public void setResourceHandle(ResourceHandle resourceHandle) {
        this.resourceHandle_ = resourceHandle;
    }

    public ResourceHandle getResourceHandle() {
        return this.resourceHandle_;
    }

    public Session getDelegate() throws JMSException {
        JMSXASession delegateXA = this.getDelegateXA();
        return delegateXA instanceof JMSXAQueueSession ? this.getQueueDelegate() : this.getTopicDelegate();
    }

    public JMSXASession getDelegateXA() {
        return this.delegateXA_;
    }

    public JMSXAQueueSession getQueueDelegateXA() {
        return (JMSXAQueueSession)this.getDelegateXA();
    }

    public JMSXATopicSession getTopicDelegateXA() {
        return (JMSXATopicSession)this.getDelegateXA();
    }

    public QueueSession getQueueDelegate() throws JMSException {
        return this.getQueueDelegateXA().getQueueSession();
    }

    public TopicSession getTopicDelegate() throws JMSException {
        return this.getTopicDelegateXA().getTopicSession();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

