/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.jms.SessionWrapper;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.jms.spi.xa.JMSXASession;
import javax.jms.JMSException;
import javax.transaction.xa.XAResource;

public class SimpleAllocator
implements ResourceAllocator {
    private static final boolean debug = false;
    private static final String QUEUE_RESOURCE_TYPE = "javax.jms.QueueSession";
    private static final String TOPIC_RESOURCE_TYPE = "javax.jms.TopicSession";
    private static final String JMS_RESOURCE_FACTORY = "JMS";
    private String resourceType_;

    public SimpleAllocator(boolean pointToPoint) {
        this.resourceType_ = pointToPoint ? QUEUE_RESOURCE_TYPE : TOPIC_RESOURCE_TYPE;
    }

    public ResourceHandle createResource() throws PoolingException {
        throw new PoolingException("Not supported");
    }

    public ResourceHandle createResource(SessionWrapper sessionWrapper) throws PoolingException {
        ResourceHandle resourceHandle;
        try {
            Switch theSwitch = Switch.getSwitch();
            PoolManager poolMgr = theSwitch.getPoolManager();
            ResourceSpec spec = new ResourceSpec(JMS_RESOURCE_FACTORY, 2);
            JMSXASession sessionXA = sessionWrapper.getDelegateXA();
            resourceHandle = new ResourceHandle(sessionXA, spec, this, null);
            XAResource xaResource = sessionXA.getXAResource();
            resourceHandle.fillInResourceObjects(sessionWrapper, xaResource);
        }
        catch (Exception e10) {
            e10.printStackTrace(Log.err);
            throw new PoolingException(e10);
        }
        return resourceHandle;
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        throw new PoolingException("Not supported");
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
        this.cleanup(resourceHandle);
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        this.cleanup(resourceHandle);
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        return false;
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
        try {
            SessionWrapper sessionWrapper = (SessionWrapper)resourceHandle.getUserConnection();
            if (sessionWrapper == null) {
                throw new PoolingException("Invalid resource handle " + resourceHandle);
            }
            sessionWrapper.close();
        }
        catch (JMSException e10) {
            throw new PoolingException(e10);
        }
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle h2) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }
}

