/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.log;

import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.log.LogWriter;
import com.sun.enterprise.log.NullLogWriter;
import com.sun.enterprise.security.application.EJBSecurityManager;
import java.io.PrintWriter;

public class Log
extends PrintWriter {
    public static Log out = new Log(new LogWriter(System.out));
    public static Log err = new Log(new LogWriter(System.err));
    public static Log event = new Log(new NullLogWriter());

    protected Log(LogWriter logwriter) {
        super(logwriter);
    }

    public static synchronized void setOutputLog(LogWriter logwriter) {
        out = Log.getLog(logwriter);
    }

    public static synchronized void setErrorLog(LogWriter logwriter) {
        err = Log.getLog(logwriter);
    }

    public static Log getLog(LogWriter logwriter) {
        Log aLog = new Log(logwriter);
        LogUtil.printInfo(aLog);
        return aLog;
    }

    public void print(Throwable throwable) {
        throwable.printStackTrace(this);
    }

    public void println(Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            this.print(throwable);
            this.println();
            this.flush();
        }
    }

    private void finalFlush() {
        this.println(LogUtil.getShutdownInfo());
        this.flush();
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAll() {
        Log audit;
        if (System.out != null) {
            System.out.flush();
        }
        if (System.err != null) {
            System.err.flush();
        }
        if (out != null) {
            out.finalFlush();
        }
        if (err != null) {
            err.finalFlush();
        }
        if (event != null) {
            event.finalFlush();
        }
        if ((audit = EJBSecurityManager.getAuditLog().getLog()) != null) {
            audit.finalFlush();
        }
    }
}

