/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.ejb.Container;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.jms.ConnectionFactoryWrapperStandalone;
import com.sun.enterprise.jms.JmsUtil;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.naming.BindingsEnum;
import com.sun.enterprise.naming.J2EEEnvWrapper;
import com.sun.enterprise.naming.NamePairsEnum;
import com.sun.enterprise.naming.SerialContextProvider;
import com.sun.enterprise.naming.SerialNameParser;
import com.sun.enterprise.naming.java.javaURLContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.ObjectInputStreamWithLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.mail.Session;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public final class NamingManagerImpl
implements NamingManager {
    public static final String SERIALOBJECT_FACTORY = "com.sun.enterprise.naming.factory.SerialObjectFactory";
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.factory.IIOPObjectFactory";
    public static final String MAIL_COMPONENT_FACTORY = "com.sun.enterprise.naming.factory.MailSessionObjectFactory";
    public static final String JMS_CONNECTION_FACTORY_FACTORY = "com.sun.enterprise.naming.factory.JmsConnectionFactoryFactory";
    public static final String LOCAL_HOME_FACTORY = "com.sun.enterprise.naming.factory.LocalHomeFactory";
    public static final String JAVA_COMP_STRING = "java:comp/env/";
    private static final String CONTEXT_SEPARATOR = "/";
    private static final String ID_SEPARATOR = "_";
    private static final int UNKNOWN_COMPONENT = 0;
    private static final int EJB_COMPONENT = 1;
    private static final int WEB_COMPONENT = 2;
    private static final int APP_CLIENT_COMPONENT = 3;
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$naming$NamingManagerImpl == null ? (class$com$sun$enterprise$naming$NamingManagerImpl = NamingManagerImpl.class$("com.sun.enterprise.naming.NamingManagerImpl")) : class$com$sun$enterprise$naming$NamingManagerImpl);
    private SerialContextProvider serialContext;
    private InitialContext initialContext;
    private InitialContext cosContext;
    private InvocationManager im = null;
    private Switch theSwitch = null;
    private NameParser nameParser = new SerialNameParser();
    private Hashtable namespaces;
    static /* synthetic */ Class class$com$sun$enterprise$naming$NamingManagerImpl;
    static /* synthetic */ Class class$com$sun$enterprise$naming$SerialContextProvider;

    public NamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    public NamingManagerImpl(InitialContext ic) throws NamingException {
        this.initialContext = ic;
        this.namespaces = new Hashtable();
        this.theSwitch = Switch.getSwitch();
        this.im = this.theSwitch.getInvocationManager();
        Hashtable<String, String> cosNamingEnv = new Hashtable<String, String>();
        cosNamingEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        ORB orb = ORBManager.getORB();
        cosNamingEnv.put("java.naming.corba.orb", (String)orb);
        this.cosContext = new InitialContext(cosNamingEnv);
        try {
            NamingContext nctx = NamingContextHelper.narrow((Object)orb.resolve_initial_references("NameService"));
            NameComponent[] path = new NameComponent[]{new NameComponent("SerialContextProvider", "")};
            this.serialContext = (SerialContextProvider)PortableRemoteObject.narrow((java.lang.Object)nctx.resolve(path), (Class)(class$com$sun$enterprise$naming$SerialContextProvider == null ? (class$com$sun$enterprise$naming$SerialContextProvider = NamingManagerImpl.class$("com.sun.enterprise.naming.SerialContextProvider")) : class$com$sun$enterprise$naming$SerialContextProvider));
        }
        catch (Exception r2) {
            throw new NamingException("Serial Context failure");
        }
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    public NameParser getNameParser() {
        return this.nameParser;
    }

    public void publishObject(String name, java.lang.Object obj, boolean rebind) throws NamingException {
        CompositeName nameobj = new CompositeName(name);
        this.publishObject(nameobj, obj, rebind);
    }

    public void publishObject(Name name, java.lang.Object obj, boolean rebind) throws NamingException {
        java.lang.Object serialObj = obj;
        if (this.isCOSNamingObj(obj)) {
            this.createSubContexts(name, this.cosContext);
            if (rebind) {
                this.cosContext.rebind(name, obj);
            } else {
                this.cosContext.bind(name, obj);
            }
            serialObj = new Reference("reference", new StringRefAddr("url", name.toString()), IIOPOBJECT_FACTORY, null);
        }
        if (rebind) {
            this.initialContext.rebind(name, serialObj);
        } else {
            this.initialContext.bind(name, serialObj);
        }
    }

    public void unpublishObject(String name) throws NamingException {
        java.lang.Object obj = this.initialContext.lookup(name);
        if (this.isCOSNamingObj(obj)) {
            this.cosContext.unbind(name);
        }
        this.initialContext.unbind(name);
    }

    public void unpublishObject(Name name) throws NamingException {
        this.unpublishObject(name.toString());
    }

    private void createSubContexts(Name name, Context rootCtx) throws NamingException {
        int numSubContexts = name.size() - 1;
        Context currentCtx = rootCtx;
        int subCtxIndex = 0;
        while (subCtxIndex < numSubContexts) {
            block5: {
                Context newCtx;
                String subCtxName = name.get(subCtxIndex);
                try {
                    java.lang.Object obj = currentCtx.lookup(subCtxName);
                    if (obj == null) {
                        currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
                        break block5;
                    }
                    if (obj instanceof Context) {
                        currentCtx = (Context)obj;
                        break block5;
                    }
                    throw new NameAlreadyBoundException(subCtxName);
                }
                catch (NameNotFoundException e10) {
                    currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
                }
            }
            ++subCtxIndex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized String bindObjects(JndiNameEnvironment env) throws NamingException {
        String componentId = this.getMangledIdName(env);
        HashMap<String, java.lang.Object> namespace = new HashMap<String, java.lang.Object>();
        this.namespaces.put(componentId, namespace);
        namespace.put("java:", new javaURLContext("java:", null, this));
        namespace.put("java:comp", new javaURLContext("java:comp", null, this));
        namespace.put("java:comp/env", new javaURLContext("java:comp/env", null, this));
        Iterator itr = env.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty next = (EnvironmentProperty)itr.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            java.lang.Object valueObject = next.getValueObject();
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            namespace.put(logicalJndiName, valueObject);
            this.bindIntermediateContexts(namespace, logicalJndiName);
        }
        Iterator itr2 = env.getJmsDestinationReferenceDescriptors().iterator();
        while (itr2.hasNext()) {
            JmsDestinationReferenceDescriptor next = (JmsDestinationReferenceDescriptor)itr2.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            String destinationName = next.getJndiName();
            java.lang.Object destinationObject = null;
            try {
                destinationObject = this.initialContext.lookup(destinationName);
            }
            catch (NamingException ne) {
                throw new InvalidNameException(localStrings.getLocalString("naming.invalidDestination", "Invalid Destination:'{0}'", new java.lang.Object[]{destinationName}));
            }
            if (destinationObject instanceof Queue ? !next.getRefType().equals("javax.jms.Queue") : destinationObject instanceof Topic && !next.getRefType().equals("javax.jms.Topic")) {
                throw new InvalidNameException(localStrings.getLocalString("naming.destinationRefTypeMismatch", "", new java.lang.Object[]{next.getName(), next.getRefType()}));
            }
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            namespace.put(logicalJndiName, destinationObject);
            this.bindIntermediateContexts(namespace, logicalJndiName);
        }
        Iterator itr3 = env.getEjbReferenceDescriptors().iterator();
        while (itr3.hasNext()) {
            EjbReferenceDescriptor next = (EjbReferenceDescriptor)itr3.next();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            String jndiName = next.getValue();
            J2EEEnvWrapper home = null;
            home = next.isLocal() ? new J2EEEnvWrapper(jndiName, 4) : new J2EEEnvWrapper(jndiName, 3);
            namespace.put(logicalJndiName, home);
            this.bindIntermediateContexts(namespace, logicalJndiName);
        }
        Iterator itr4 = env.getResourceReferenceDescriptors().iterator();
        while (itr4.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr4.next();
            String logicalResRef = next.getName();
            String logicalJndiName = this.descriptorToLogicalJndiName(next);
            System.out.println(localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            String resJndi = next.getValue();
            if (resJndi == null || resJndi.equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + logicalResRef);
            }
            java.lang.Object obj = null;
            if (next.isMailResource()) {
                obj = new J2EEEnvWrapper(next.getMailConfiguration(), 2);
            } else if (next.isURLResource()) {
                String url = next.getJndiName();
                try {
                    obj = new URL(url);
                }
                catch (MalformedURLException e10) {
                    throw new InvalidNameException(localStrings.getLocalString("naming.malformedURL", "Malformed URL:'{0}'", new java.lang.Object[]{url}));
                }
                obj = new J2EEEnvWrapper(obj, 1);
            } else if (next.isJMSConnectionFactory()) {
                int componentType = this.getComponentType(env);
                JmsWrapperFactory jmsWrapperFactory = null;
                switch (componentType) {
                    case 1: {
                        jmsWrapperFactory = JmsWrapperFactory.getFactoryForEjb();
                        break;
                    }
                    case 2: {
                        jmsWrapperFactory = JmsWrapperFactory.getFactoryForWeb();
                        break;
                    }
                    case 3: {
                        jmsWrapperFactory = JmsWrapperFactory.getFactoryForAppClient();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid component type = " + componentType);
                    }
                }
                ConnectionFactoryWrapperStandalone wrapper = null;
                ConnectionFactory factory = null;
                try {
                    wrapper = (ConnectionFactoryWrapperStandalone)this.initialContext.lookup(resJndi);
                    factory = wrapper.getDelegate();
                }
                catch (NamingException ne) {
                    throw new InvalidNameException(localStrings.getLocalString("naming.invalidConnection", "Connection Factory Not Found:'{0}'", new java.lang.Object[]{resJndi}));
                }
                String xaCnxFactoryName = JmsUtil.getXAConnectionFactoryName(resJndi);
                if (factory instanceof QueueConnectionFactory) {
                    if (!next.getType().equals("javax.jms.QueueConnectionFactory")) throw new InvalidNameException(localStrings.getLocalString("naming.jmsConnectionFactoryRefTypeMismatch", "", new java.lang.Object[]{logicalResRef, next.getType()}));
                    obj = jmsWrapperFactory.createQueueConnectionFactoryWrapper(xaCnxFactoryName, next);
                } else {
                    if (!next.getType().equals("javax.jms.TopicConnectionFactory")) throw new InvalidNameException(localStrings.getLocalString("naming.jmsConnectionFactoryRefTypeMismatch", "", new java.lang.Object[]{logicalResRef, next.getType()}));
                    obj = jmsWrapperFactory.createTopicConnectionFactoryWrapper(xaCnxFactoryName, next);
                }
                obj = new J2EEEnvWrapper(obj, 1);
            } else {
                try {
                    java.lang.Object res = this.initialContext.lookup(resJndi);
                    obj = new J2EEEnvWrapper(res, 1);
                }
                catch (NamingException ne) {
                    String msg = localStrings.getLocalString("naming.unresolved.warning", "", new java.lang.Object[]{logicalJndiName, resJndi});
                    System.out.println(msg);
                }
                if (obj == null) {
                    obj = new J2EEEnvWrapper(resJndi, 5);
                }
            }
            namespace.put(logicalJndiName, obj);
            this.bindIntermediateContexts(namespace, logicalJndiName);
        }
        return componentId;
    }

    private void bindIntermediateContexts(HashMap namespace, String name) throws NamingException {
        name = name.substring("java:comp/".length());
        StringTokenizer toks = new StringTokenizer(name, CONTEXT_SEPARATOR, false);
        String partialName = "java:comp";
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            if (namespace.get(partialName = partialName + CONTEXT_SEPARATOR + tok) != null) continue;
            namespace.put(partialName, new javaURLContext(partialName, null, this));
        }
    }

    public void unbindObjects(JndiNameEnvironment env) throws NamingException {
        String componentId = this.getMangledIdName(env);
        this.namespaces.remove(componentId);
    }

    public java.lang.Object lookup(String name) throws NamingException {
        String componentId = this.getComponentId();
        HashMap namespace = (HashMap)this.namespaces.get(componentId);
        java.lang.Object obj = namespace.get(name);
        if (obj == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (obj instanceof J2EEEnvWrapper) {
            J2EEEnvWrapper wr = (J2EEEnvWrapper)obj;
            switch (wr.type) {
                case 1: {
                    obj = this.copyMutableObject(wr.object);
                    break;
                }
                case 2: {
                    MailConfiguration config = (MailConfiguration)wr.object;
                    obj = Session.getInstance(config.getMailProperties(), null);
                    break;
                }
                case 3: {
                    obj = this.cosContext.lookup((String)wr.object);
                    namespace.put(name, obj);
                    break;
                }
                case 4: {
                    obj = this.theSwitch.getLocalHome((String)wr.object);
                    if (obj == null) {
                        throw new NamingException("EJBLocalHome lookup failed");
                    }
                    namespace.put(name, obj);
                    break;
                }
                case 5: {
                    obj = this.initialContext.lookup((String)wr.object);
                    wr = new J2EEEnvWrapper(obj, 1);
                    namespace.put(name, wr);
                }
            }
        }
        return obj;
    }

    private java.lang.Object copyMutableObject(java.lang.Object obj) {
        if (obj instanceof Serializable) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(obj);
                oos.flush();
                byte[] data = bos.toByteArray();
                oos.close();
                bos.close();
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                ClassLoader cl2 = Thread.currentThread().getContextClassLoader();
                ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader(bis, cl2);
                return ois.readObject();
            }
            catch (Exception ex2) {
                throw new RuntimeException("Cant copy Serializable object:" + ex2);
            }
        }
        return obj;
    }

    public NamingEnumeration list(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new NamePairsEnum(this, ((AbstractList)list).iterator());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new BindingsEnum(this, ((AbstractList)list).iterator());
    }

    private ArrayList listNames(String name) throws NamingException {
        String componentId = this.getComponentId();
        HashMap namespace = (HashMap)this.namespaces.get(componentId);
        java.lang.Object obj = namespace.get(name);
        if (obj == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (!(obj instanceof javaURLContext)) {
            throw new NotContextException(name + " cannot be listed");
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator itr = namespace.keySet().iterator();
        if (!name.endsWith(CONTEXT_SEPARATOR)) {
            name = name + CONTEXT_SEPARATOR;
        }
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(name) || key.indexOf(47, name.length()) != -1) continue;
            list.add(key);
        }
        return list;
    }

    private String getComponentId() throws NamingException {
        String id = null;
        try {
            ComponentInvocation ci2 = this.im.getCurrentInvocation();
            java.lang.Object containerContext = ci2.getContainerContext();
            if (containerContext == null) {
                throw new NamingException("No container context");
            }
            if (containerContext instanceof Container) {
                return ((Container)containerContext).getComponentId();
            }
            JndiNameEnvironment desc = (JndiNameEnvironment)this.theSwitch.getDescriptorFor(containerContext);
            id = this.getMangledIdName(desc);
        }
        catch (InvocationException e10) {
            throw new NamingException("invocation exception " + e10);
        }
        return id;
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        return JAVA_COMP_STRING + descriptor.getName();
    }

    private int getComponentType(JndiNameEnvironment env) {
        int componentType = 0;
        if (env instanceof EjbDescriptor) {
            componentType = 1;
        } else if (env instanceof WebBundleDescriptor) {
            componentType = 2;
        } else if (env instanceof ApplicationClientDescriptor) {
            componentType = 3;
        } else {
            throw new IllegalArgumentException("Unknown component type");
        }
        return componentType;
    }

    private String getMangledIdName(JndiNameEnvironment env) {
        String id = null;
        int componentType = this.getComponentType(env);
        switch (componentType) {
            case 1: {
                EjbDescriptor ejbEnv = (EjbDescriptor)env;
                String flattedJndiName = ejbEnv.getJndiName().replace('/', '.');
                EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
                Archivist archivist = ejbBundle.getArchivist();
                id = ejbEnv.getApplication().getName() + ID_SEPARATOR + archivist.getArchiveUri() + ID_SEPARATOR + ejbEnv.getName() + ID_SEPARATOR + flattedJndiName;
                break;
            }
            case 2: {
                WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
                id = webEnv.getApplication().getName() + ID_SEPARATOR + webEnv.getContextRoot();
                break;
            }
            case 3: {
                ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
                id = "client_" + appEnv.getName() + ID_SEPARATOR + appEnv.getMainClassName();
            }
        }
        return id;
    }

    private boolean isCOSNamingObj(java.lang.Object obj) {
        return obj instanceof Remote || obj instanceof Object;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

