/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.java;

import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.UserTransactionImpl;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.util.ORBManager;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public final class javaURLContext
implements Context {
    private static final String ORB_STRING = "java:comp/ORB";
    private static final String HANDLE_DELEGATE = "java:comp/HandleDelegate";
    private static final String USER_TX = "java:comp/UserTransaction";
    private static final String TRANSACTION_MGR = "java:pm/TransactionManager";
    private static final boolean debug = false;
    private NamingManagerImpl namingManager;
    private Hashtable myEnv;
    private String myName = "";

    javaURLContext(Hashtable environment, NamingManagerImpl nm) throws NamingException {
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        this.namingManager = nm;
    }

    public javaURLContext(String name, Hashtable env, NamingManagerImpl nm) throws NamingException {
        this(env, nm);
        this.myName = name;
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new javaURLContext(this.myName, this.myEnv, this.namingManager);
        }
        String fullName = name;
        if (!this.myName.equals("")) {
            fullName = this.myName.equals("java:") ? this.myName + name : this.myName + "/" + name;
        }
        try {
            if (fullName.startsWith("java:comp/env")) {
                return this.namingManager.lookup(fullName);
            }
            if (fullName.equals(ORB_STRING)) {
                return ORBManager.getORB();
            }
            if (fullName.equals(USER_TX)) {
                return new UserTransactionImpl();
            }
            if (fullName.equals(HANDLE_DELEGATE)) {
                return Switch.getSwitch().getHandleDelegate();
            }
            if (fullName.equals(TRANSACTION_MGR)) {
                return Switch.getSwitch().getContainerFactory().getTransactionMgr();
            }
            return this.namingManager.lookup(fullName);
        }
        catch (NamingException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new NameNotFoundException("No object bound for " + fullName);
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void unbind(String name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void unbind(Name name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rename(String oldname, String newname) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            if (this.namingManager == null) {
                throw new NamingException();
            }
            return this.namingManager.list(this.myName);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            if (this.namingManager == null) {
                throw new NamingException();
            }
            return this.namingManager.listBindings(this.myName);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (this.namingManager == null) {
            throw new NamingException();
        }
        return this.namingManager.getNameParser();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Context.getNameInNamespace() not implemented");
    }
}

