/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.repository.Repository;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;

public class ConfigurationImpl
implements Configuration {
    private static String OBJECT_STORE_DIR = "repository" + File.separator + Utility.getLocalHost() + File.separator + "objects" + File.separator;
    private static String SERVER_CONFIG_DIR = "repository" + File.separator + Utility.getLocalHost() + File.separator;
    private static final String OBJECT_FILE_EXT = ".ser";
    private Hashtable table;
    private Repository defaultRepository;

    public ConfigurationImpl() {
        File dir = new File(FileUtil.getAbsolutePath(OBJECT_STORE_DIR));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.table = new Hashtable();
        this.defaultRepository = this.getRepository("default");
        this.getServerRepository();
    }

    private String getIndex(String key) {
        int index = key.indexOf(".");
        if (index < 0) {
            return "default";
        }
        return key.substring(0, index);
    }

    private String getEffectiveKey(String key) {
        int index = key.indexOf(".");
        if (index < 0) {
            return key;
        }
        return key.substring(index + 1);
    }

    private Repository getRepository(String repName) {
        Repository rep = (Repository)this.table.get(repName);
        if (rep == null) {
            rep = new Repository(repName);
            if (rep.getName().equals(repName)) {
                this.table.put(repName, rep);
            } else {
                rep = this.defaultRepository;
            }
        }
        return rep;
    }

    private Repository getServerRepository() {
        Repository rep = (Repository)this.table.get("server");
        if (rep == null) {
            File f2;
            File dir = new File(FileUtil.getAbsolutePath(SERVER_CONFIG_DIR));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(f2 = new File(dir, "server.properties")).exists()) {
                try {
                    f2.createNewFile();
                }
                catch (IOException e10) {
                    e10.printStackTrace();
                }
            }
            rep = new Repository("server", FileUtil.getAbsolutePath(SERVER_CONFIG_DIR) + File.separator);
            this.table.put("server", rep);
        }
        return rep;
    }

    public String getProperty(String key) throws RemoteException {
        String index = this.getIndex(key);
        String newKey = this.getEffectiveKey(key);
        Repository rep = this.getRepository(index);
        String val = null;
        val = rep.getName().equals(index) ? rep.find(newKey) : rep.find(key);
        return val;
    }

    public void setProperty(String key, String value) throws RemoteException {
        String index = this.getIndex(key);
        String newKey = this.getEffectiveKey(key);
        Repository rep = this.getRepository(index);
        if (rep.getName().equals(index)) {
            rep.add(newKey, value);
        } else {
            rep.add(key, value);
        }
    }

    public void removeProperty(String key) throws RemoteException {
        String index = this.getIndex(key);
        String newKey = this.getEffectiveKey(key);
        Repository rep = this.getRepository(index);
        if (rep.getName().equals(index)) {
            rep.remove(newKey);
        } else {
            rep.remove(key);
        }
    }

    public Object getObject(String key) throws RemoteException {
        String fname = this.getProperty(key);
        Object obj = null;
        if (fname != null) {
            try {
                FileInputStream fstream = new FileInputStream(fname);
                ObjectInputStream objstream = new ObjectInputStream(fstream);
                obj = objstream.readObject();
                fstream.close();
            }
            catch (Exception e10) {
                e10.printStackTrace(System.out);
            }
        }
        return obj;
    }

    public void setObject(String key, Object obj) throws RemoteException {
        String className = obj.getClass().getName();
        String instanceId = String.valueOf(obj.hashCode());
        String fname = OBJECT_STORE_DIR + className + instanceId + OBJECT_FILE_EXT;
        try {
            String absFileName = FileUtil.getAbsolutePath(fname);
            FileOutputStream fstream = new FileOutputStream(absFileName);
            ObjectOutputStream objstream = new ObjectOutputStream(fstream);
            objstream.writeObject(obj);
            objstream.flush();
            fstream.close();
            this.setProperty(key, absFileName);
        }
        catch (Exception e10) {
            e10.printStackTrace(System.out);
        }
    }

    public void removeObject(String key) throws RemoteException {
        String fname = this.getProperty(key);
        if (fname != null) {
            try {
                File file = new File(fname);
                if (file.exists()) {
                    file.delete();
                }
                this.removeProperty(key);
            }
            catch (Exception e10) {
                e10.printStackTrace(System.out);
            }
        }
    }

    public String[] getKeys(String index) throws RemoteException {
        Repository rep = this.getRepository(index);
        return rep.keys();
    }
}

