/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DataSourceParser {
    private static final String DS = "xadatasource";
    private static final String JNDINAME = "jndiname";
    private static final String CLASSNAME = "classname";
    private static final String PROP = "prop";
    private static final String DBUSER = "dbuser";
    private static final String DBPASSWORD = "dbpassword";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$repository$DataSourceParser == null ? (class$com$sun$enterprise$repository$DataSourceParser = DataSourceParser.class$("com.sun.enterprise.repository.DataSourceParser")) : class$com$sun$enterprise$repository$DataSourceParser);
    static /* synthetic */ Class class$com$sun$enterprise$repository$DataSourceParser;
    static /* synthetic */ Class class$java$lang$String;

    private DataSourceParser() {
    }

    public Vector parseProperties(Properties props) {
        Vector<DataSourceInfo> list = new Vector<DataSourceInfo>();
        int count = 0;
        while (true) {
            String jndiName = props.getProperty("xadatasource." + count + "." + JNDINAME);
            String className = props.getProperty("xadatasource." + count + "." + CLASSNAME);
            String dbUser = props.getProperty("xadatasource." + count + "." + DBUSER);
            String dbPassword = props.getProperty("xadatasource." + count + "." + DBPASSWORD);
            if (jndiName == null || className == null) break;
            try {
                DataSourceInfo dsi = new DataSourceInfo();
                dsi.jndiName = jndiName;
                dsi.dbUser = dbUser;
                dsi.dbPassword = dbPassword;
                Object obj = Class.forName(className).newInstance();
                dsi.dataSource = obj;
                list.addElement(dsi);
            }
            catch (Exception ex2) {
                Object[] args = new Object[]{className};
                System.err.println(localStrings.getLocalString("enterprise.repository.init.class.err", "", args));
                System.err.println("");
            }
            ++count;
        }
        Enumeration e10 = ((Hashtable)props).keys();
        while (e10.hasMoreElements()) {
            String key = (String)e10.nextElement();
            String val = props.getProperty(key);
            if (!key.startsWith(DS) || key.indexOf(PROP) == -1) continue;
            try {
                String s2 = key.substring(DS.length() + 1, key.indexOf(".", DS.length() + 1));
                int idx = Integer.parseInt(s2);
                String prop = key.substring(key.lastIndexOf("prop.") + PROP.length() + 1);
                DataSourceInfo dsi = (DataSourceInfo)list.elementAt(idx);
                Object obj = dsi.dataSource;
                this.invokeSetMethod(obj, prop, val);
            }
            catch (Exception ex3) {
                Object[] args = new Object[]{key, val};
                System.err.println(localStrings.getLocalString("enterprise.repository.prop.err", "", args));
                System.err.println("");
            }
        }
        return list;
    }

    private void invokeSetMethod(Object obj, String prop, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> cl2 = obj.getClass();
        String setMeth = "set" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
        try {
            Class[] cldef = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DataSourceParser.class$("java.lang.String")) : class$java$lang$String};
            Method meth = cl2.getMethod(setMeth, cldef);
            Object[] params = new Object[]{value};
            meth.invoke(obj, params);
            return;
        }
        catch (NoSuchMethodException ex2) {
            Class[] cldef = new Class[]{Integer.TYPE};
            Method meth = cl2.getMethod(setMeth, cldef);
            Object[] params = new Object[]{Integer.valueOf(value)};
            meth.invoke(obj, params);
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DataSourceInfo {
        public String jndiName;
        public String dbUser;
        public String dbPassword;
        public Object dataSource;
    }
}

