/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public abstract class AbstractSystemJdbcAllocator
implements ResourceAllocator {
    protected PoolManager poolMgr;
    protected ResourceSpec spec;
    protected ClientSecurityInfo info;

    public AbstractSystemJdbcAllocator(PoolManager poolMgr, ResourceSpec spec, ClientSecurityInfo info) {
        this.poolMgr = poolMgr;
        this.spec = spec;
        this.info = info;
    }

    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            XAConnection xacon = (XAConnection)resource.getResource();
            Connection con = xacon.getConnection();
            XAResource xares = xacon.getXAResource();
            resource.fillInResourceObjects(con, xares);
        }
        catch (SQLException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public void closeUserConnection(ResourceHandle resource) throws PoolingException {
        try {
            Connection con = (Connection)resource.getUserConnection();
            con.close();
        }
        catch (SQLException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            this.closeUserConnection(resource);
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            XAConnection xacon = (XAConnection)resource.getResource();
            xacon.close();
        }
        catch (SQLException ex3) {
            throw new PoolingException(ex3);
        }
    }

    public boolean matchConnection(ResourceHandle h2) {
        return h2.getClientSecurityInfo().equals(this.info);
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle h2) throws PoolingException {
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle h2) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }

    public abstract ResourceHandle createResource() throws PoolingException;

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resource) {
            this.resource = resource;
        }

        public void connectionClosed(ConnectionEvent evt) {
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            try {
                Transaction tran = tm.getTransaction();
                if (tran != null) {
                    tm.delistResource(tran, this.resource, 0x4000000);
                }
            }
            catch (SystemException ex2) {
                Log.err.println(ex2);
            }
            catch (IllegalStateException ex3) {
                // empty catch block
            }
            AbstractSystemJdbcAllocator.this.poolMgr.putbackResourceToPool(this.resource, false);
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            XAConnection con = (XAConnection)evt.getSource();
            con.removeConnectionEventListener(this);
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            try {
                Transaction tran = tm.getTransaction();
                if (tran != null) {
                    tm.delistResource(tran, this.resource, 0x20000000);
                    tran.setRollbackOnly();
                }
            }
            catch (SystemException ex2) {
                Log.err.println(ex2);
            }
            catch (IllegalStateException ex3) {
                // empty catch block
            }
            AbstractSystemJdbcAllocator.this.poolMgr.putbackResourceToPool(this.resource, true);
            try {
                con.close();
            }
            catch (SQLException ex4) {
                // empty catch block
            }
        }
    }
}

