/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import javax.resource.spi.ManagedConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ConnectorXAResource
implements XAResource {
    private Object userHandle;
    private ResourceSpec spec;
    private ResourceAllocator alloc;
    private PoolManager poolMgr = Switch.getSwitch().getPoolManager();
    private ManagedConnection localConnection;
    private ClientSecurityInfo info;

    public ConnectorXAResource(ManagedConnection mc, Object userHandle, ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) {
        this.userHandle = userHandle;
        this.spec = spec;
        this.alloc = alloc;
        this.info = info;
        this.localConnection = mc;
    }

    private void handleResourceException(Exception ex2) throws XAException {
        Log.err.println(ex2);
        XAException xae = new XAException(ex2.toString());
        xae.errorCode = -3;
        throw xae;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            ManagedConnection mc = this.getManagedConnection(xid);
            mc.getLocalTransaction().commit();
            this.freeManagedConnection(xid);
        }
        catch (Exception ex2) {
            this.handleResourceException(ex2);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            ManagedConnection mc = this.getManagedConnection(xid);
            mc.associateConnection(this.userHandle);
        }
        catch (Exception ex2) {
            this.handleResourceException(ex2);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            this.localConnection.associateConnection(this.userHandle);
        }
        catch (Exception ex2) {
            this.handleResourceException(ex2);
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource other) throws XAException {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof ConnectorXAResource) {
            ConnectorXAResource obj = (ConnectorXAResource)other;
            return this.spec.equals(obj.spec) && this.info.equals(obj.info);
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        try {
            ManagedConnection mc = this.getManagedConnection(xid);
            mc.getLocalTransaction().rollback();
            this.freeManagedConnection(xid);
        }
        catch (Exception ex2) {
            this.handleResourceException(ex2);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    ManagedConnection getManagedConnection(Xid xid) throws PoolingException {
        boolean existBefore = this.poolMgr.sharedResourceExists(this.spec, this.info, xid);
        ResourceHandle resource = this.poolMgr.getSharedResource(this.spec, this.alloc, this.info, xid);
        ManagedConnection mc = (ManagedConnection)resource.getResource();
        if (!existBefore) {
            try {
                mc.getLocalTransaction().begin();
            }
            catch (Exception ex2) {
                ex2.printStackTrace(Log.err);
                Log.err.flush();
                throw new PoolingException(ex2.toString(), ex2);
            }
        }
        return mc;
    }

    void freeManagedConnection(Xid xid) throws PoolingException {
        ResourceHandle resource = this.poolMgr.getSharedResource(this.spec, this.alloc, this.info, xid);
        this.poolMgr.freeSharedResource(resource, xid);
    }
}

