/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class JdbcUrlAllocator
implements ResourceAllocator {
    private PoolManager poolMgr;
    private ResourceSpec spec;
    private ClientSecurityInfo info;
    private String jdbcUrl;

    public JdbcUrlAllocator(PoolManager poolMgr, String jdbcUrl, ResourceSpec spec, ClientSecurityInfo info) {
        this.poolMgr = poolMgr;
        this.jdbcUrl = jdbcUrl;
        this.spec = spec;
        this.info = info;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ResourceHandle resource = null;
            ResourcePrincipal prin = this.info.getPrincipal();
            String user = prin.getName();
            String password = prin.getPassword();
            Connection con = DriverManager.getConnection(this.jdbcUrl, user, password);
            con.setAutoCommit(false);
            resource = new ResourceHandle(con, this.spec, this, this.info);
            return resource;
        }
        catch (Exception ex2) {
            if (ex2 instanceof PoolingException) {
                throw (PoolingException)ex2;
            }
            throw new PoolingException(ex2);
        }
    }

    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
    }

    public void closeUserConnection(ResourceHandle resource) throws PoolingException {
    }

    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            Connection con = (Connection)resource.getResource();
            con.close();
        }
        catch (SQLException ex2) {
            throw new PoolingException(ex2);
        }
    }

    public boolean matchConnection(ResourceHandle h2) {
        return h2.getClientSecurityInfo().equals(this.info);
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle h2) throws PoolingException {
    }

    public boolean isTransactional() {
        return false;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle h2) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }
}

