/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.JdbcUrlAllocator;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JdbcXAConnection
implements XAConnection {
    public static boolean debug = false;
    private JdbcConnection con;
    private JdbcXAResource xares;
    private Vector listeners;
    private boolean closed;
    private ResourceSpec spec;
    private ClientSecurityInfo info;
    private PoolManager poolMgr;
    private ResourceAllocator alloc;
    private Connection currentCon;
    private Xid currentXid;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$JdbcXAConnection == null ? (class$com$sun$enterprise$resource$JdbcXAConnection = JdbcXAConnection.class$("com.sun.enterprise.resource.JdbcXAConnection")) : class$com$sun$enterprise$resource$JdbcXAConnection);
    private static Hashtable jdbcCons = new Hashtable();
    static /* synthetic */ Class class$com$sun$enterprise$resource$JdbcXAConnection;

    public JdbcXAConnection(ResourceSpec spec, String jdbcUrl, ClientSecurityInfo info, PoolManager poolMgr) throws PoolingException {
        this.spec = spec;
        this.info = info;
        this.listeners = new Vector();
        this.closed = false;
        this.poolMgr = poolMgr;
        this.alloc = new JdbcUrlAllocator(poolMgr, jdbcUrl, spec, info);
        ResourceHandle h2 = poolMgr.getResourceFromPool(spec, this.alloc, info, null);
        poolMgr.putbackResourceToPool(h2, false);
    }

    public XAResource getXAResource() throws SQLException {
        if (this.closed) {
            throw new SQLException(localStrings.getLocalString("ejbcon.already_closed", "Connection has been previously closed, open a new Connection"));
        }
        return this.xares;
    }

    public Connection getConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException(localStrings.getLocalString("ejbcon.already_closed", "Connection has been previously closed, open a new Connection"));
        }
        if (this.con != null) {
            this.con.setClosed();
        }
        try {
            this.con = new JdbcConnection();
            this.xares = new JdbcXAResource(this.spec, this.info);
        }
        catch (PoolingException ex2) {
            ex2.printStackTrace();
            ex2.printStackTrace(Log.err);
            throw new SQLException();
        }
        return this.con;
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.removeElement(listener);
    }

    void connectionClosed() {
        ConnectionEvent evt = new ConnectionEvent(this);
        Vector clone = (Vector)this.listeners.clone();
        int size = clone.size();
        int i2 = 0;
        while (i2 < size) {
            ((ConnectionEventListener)clone.elementAt(i2)).connectionClosed(evt);
            ++i2;
        }
    }

    void connectionErrorOccurred(SQLException ex2) {
        ConnectionEvent evt = new ConnectionEvent(this, ex2);
        Vector clone = (Vector)this.listeners.clone();
        int size = clone.size();
        int i2 = 0;
        while (i2 < size) {
            ((ConnectionEventListener)clone.elementAt(i2)).connectionErrorOccurred(evt);
            ++i2;
        }
    }

    Connection getJdbcConnection(Xid xid) throws PoolingException {
        Vector<Object> v2 = new Vector<Object>(3);
        v2.addElement(this.spec);
        v2.addElement(this.info);
        v2.addElement(xid);
        ResourceHandle resource = (ResourceHandle)jdbcCons.get(v2);
        if (resource == null) {
            resource = this.poolMgr.getResourceFromPool(this.spec, this.alloc, this.info, null);
            jdbcCons.put(v2, resource);
        }
        return (Connection)resource.getResource();
    }

    void freeJdbcConnection(Xid xid) throws SQLException {
        Vector<Object> v2 = new Vector<Object>(3);
        v2.addElement(this.spec);
        v2.addElement(this.info);
        v2.addElement(xid);
        ResourceHandle resource = (ResourceHandle)jdbcCons.get(v2);
        jdbcCons.remove(v2);
        this.poolMgr.putbackResourceToPool(resource, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JdbcConnection
    implements Connection {
        private boolean closed;
        private ResourceHandle localCon;

        public Statement createStatement() throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            Statement dbStatement = dbCon.createStatement();
            return dbStatement;
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            PreparedStatement pStmt = dbCon.prepareStatement(sql);
            return pStmt;
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            CallableStatement cStmt = dbCon.prepareCall(sql);
            return cStmt;
        }

        public String nativeSQL(String sql) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            return dbCon.nativeSQL(sql);
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.errorIfClosed();
            if (this.checkIfTx()) {
                throw new SQLException(localStrings.getLocalString("ejbcon.wrongoperation", "Operation not allowed under global transaction context"));
            }
            Connection dbCon = this.getCurrentConnection();
            dbCon.setAutoCommit(autoCommit);
        }

        public boolean getAutoCommit() throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            return dbCon.getAutoCommit();
        }

        public void commit() throws SQLException {
            this.errorIfClosed();
            if (this.checkIfTx()) {
                throw new SQLException(localStrings.getLocalString("ejbcon.nocommitallowed", "No call to commit allowed with a transaction context"));
            }
            Connection dbCon = this.getCurrentConnection();
            dbCon.commit();
        }

        public void rollback() throws SQLException {
            this.errorIfClosed();
            if (this.checkIfTx()) {
                throw new SQLException(localStrings.getLocalString("ejbcon.norollbackallowed", "No call to rollback allowed within a transaction context"));
            }
            Connection dbCon = this.getCurrentConnection();
            dbCon.rollback();
        }

        public void close() throws SQLException {
            if (this.closed) {
                return;
            }
            JdbcXAConnection.this.connectionClosed();
            this.closed = true;
            if (this.localCon == null) {
                return;
            }
            Connection con = (Connection)this.localCon.getResource();
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            } else {
                if (debug) {
                    System.err.println("Jdbc10: rollback local connection due to close");
                }
                con.rollback();
            }
            JdbcXAConnection.this.poolMgr.putbackResourceToPool(this.localCon, false);
        }

        public boolean isClosed() {
            return this.closed;
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            return dbCon.getMetaData();
        }

        public void setReadOnly(boolean readOnly) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            dbCon.setReadOnly(readOnly);
        }

        public boolean isReadOnly() throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            return dbCon.isReadOnly();
        }

        public void setCatalog(String catalog) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            dbCon.setCatalog(catalog);
        }

        public String getCatalog() throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            return dbCon.getCatalog();
        }

        public void setTransactionIsolation(int level) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            dbCon.setTransactionIsolation(level);
        }

        public int getTransactionIsolation() throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            return dbCon.getTransactionIsolation();
        }

        public SQLWarning getWarnings() throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            return dbCon.getWarnings();
        }

        public void clearWarnings() throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            dbCon.clearWarnings();
        }

        public void setTypeMap(Map map) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            dbCon.setTypeMap(map);
        }

        public Map getTypeMap() throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            return dbCon.getTypeMap();
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            PreparedStatement pStmt = dbCon.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return pStmt;
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            Statement dbStatement = dbCon.createStatement(resultSetType, resultSetConcurrency);
            return dbStatement;
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.errorIfClosed();
            Connection dbCon = this.getCurrentConnection();
            CallableStatement cStmt = dbCon.prepareCall(sql, resultSetType, resultSetConcurrency);
            return cStmt;
        }

        void setClosed() {
            this.closed = true;
        }

        private void errorIfClosed() throws SQLException {
            if (JdbcXAConnection.this.currentXid != null) {
                Vector<Object> v2 = new Vector<Object>(3);
                v2.addElement(JdbcXAConnection.this.spec);
                v2.addElement(JdbcXAConnection.this.info);
                v2.addElement(JdbcXAConnection.this.currentXid);
                if (jdbcCons.get(v2) == null) {
                    throw new SQLException(localStrings.getLocalString("ejbcon.already_rollbacked", ""));
                }
            }
            if (this.closed) {
                throw new SQLException(localStrings.getLocalString("ejbcon.already_closed", "Connection has been previously closed, open a new Connection"));
            }
        }

        private boolean checkIfTx() {
            return JdbcXAConnection.this.currentCon != null;
        }

        private Connection getCurrentConnection() throws SQLException {
            if (JdbcXAConnection.this.currentCon != null) {
                return JdbcXAConnection.this.currentCon;
            }
            if (this.localCon == null) {
                if (debug) {
                    System.err.println("Jdbc10: Using Local connection");
                    Thread.dumpStack();
                }
                try {
                    this.localCon = JdbcXAConnection.this.poolMgr.getResourceFromPool(JdbcXAConnection.this.spec, JdbcXAConnection.this.alloc, JdbcXAConnection.this.info, null);
                    Connection con = (Connection)this.localCon.getResource();
                    con.setAutoCommit(true);
                }
                catch (PoolingException ex2) {
                    ex2.printStackTrace();
                    ex2.printStackTrace(Log.err);
                    throw new SQLException();
                }
            }
            return (Connection)this.localCon.getResource();
        }
    }

    class JdbcXAResource
    implements XAResource {
        private ResourceSpec spec;
        private ClientSecurityInfo info;

        JdbcXAResource(ResourceSpec spec, ClientSecurityInfo info) {
            this.spec = spec;
            this.info = info;
        }

        public void start(Xid xid, int flags) throws XAException {
            if (debug) {
                System.err.println("Jdbc10: XAResource.start" + xid);
            }
            try {
                JdbcXAConnection.this.currentXid = xid;
                JdbcXAConnection.this.currentCon = JdbcXAConnection.this.getJdbcConnection(xid);
            }
            catch (PoolingException ex2) {
                throw new XAException();
            }
        }

        public void end(Xid xid, int flags) throws XAException {
            if (debug) {
                System.err.println("Jdbc10: XAResource.end" + xid);
            }
            JdbcXAConnection.this.currentCon = null;
            JdbcXAConnection.this.currentXid = null;
        }

        public int prepare(Xid xid) throws XAException {
            if (debug) {
                System.err.println("Jdbc10: XAResource.prepare " + xid);
            }
            return 0;
        }

        public void commit(Xid xid, boolean one_phase) throws XAException {
            if (debug) {
                System.err.println("Jdbc10: XAResource.commit" + xid);
            }
            try {
                Connection con = JdbcXAConnection.this.getJdbcConnection(xid);
                con.commit();
                JdbcXAConnection.this.freeJdbcConnection(xid);
            }
            catch (Exception ex2) {
                throw new XAException();
            }
        }

        public void rollback(Xid xid) throws XAException {
            if (debug) {
                System.err.println("Jdbc10: XAResource.rollback" + xid);
            }
            try {
                Connection con = JdbcXAConnection.this.getJdbcConnection(xid);
                con.rollback();
                JdbcXAConnection.this.freeJdbcConnection(xid);
            }
            catch (Exception ex2) {
                throw new XAException();
            }
        }

        public void forget(Xid xid) throws XAException {
            throw new XAException();
        }

        public Xid[] recover(int flag) throws XAException {
            throw new XAException();
        }

        public boolean isSameRM(XAResource other) throws XAException {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other instanceof JdbcXAResource) {
                JdbcXAResource obj = (JdbcXAResource)other;
                return this.spec.equals(obj.spec) && this.info.equals(obj.info);
            }
            return false;
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean setTransactionTimeout(int seconds) throws XAException {
            return false;
        }

        public String toString() {
            return "JDBCXAConnection$JdbcXAResource, hashCode=" + this.hashCode() + " spec=" + this.spec + " info=" + this.info;
        }
    }
}

