/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.NonSharedResourcePool;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PoolManagerImpl
implements PoolManager {
    private static final boolean debug = false;
    private static final long DEFAULT_SLEEPTIME = 10L;
    private Hashtable poolTable = new Hashtable();
    private HashSet pendingTxns = new HashSet();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$PoolManagerImpl == null ? (class$com$sun$enterprise$resource$PoolManagerImpl = PoolManagerImpl.class$("com.sun.enterprise.resource.PoolManagerImpl")) : class$com$sun$enterprise$resource$PoolManagerImpl);
    private long sleeptime = 0L;
    private Hashtable xid2Connections = new Hashtable();
    static /* synthetic */ Class class$com$sun$enterprise$resource$PoolManagerImpl;

    public PoolManagerImpl() {
        ServerConfiguration sconfig = ServerConfiguration.getConfiguration();
        String val = sconfig.getProperty("idle.resource.threshold", String.valueOf(10L));
        String ex2 = localStrings.getLocalString("idle_resource_threshold_error", "The value of idle.resource.threshold in default.properties file should be a positive integer:");
        try {
            this.sleeptime = Long.parseLong(val);
            if (this.sleeptime < 0L) {
                throw new RuntimeException(ex2);
            }
        }
        catch (NumberFormatException nfe) {
            Log.err.println(ex2);
            Log.err.flush();
            throw new RuntimeException(ex2);
        }
        Timer timer = Switch.getSwitch().getTimer();
        Resizer timerTask = new Resizer();
        long sleepTimeInMillis = this.sleeptime * 1000L;
        timer.scheduleAtFixedRate((TimerTask)timerTask, sleepTimeInMillis, sleepTimeInMillis);
    }

    private boolean isTransactionActive(Transaction tran) {
        return tran != null;
    }

    public Object getResource(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) throws PoolingException {
        Transaction tran = null;
        boolean transactional = alloc.isTransactional();
        InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
        ComponentInvocation inv = invmgr.getCurrentInvocation();
        if (transactional) {
            tran = inv.getTransaction();
        }
        if (alloc.shareableWithinComponent()) {
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            Object comp = inv.getInstance();
            if (comp != null) {
                Vector resList = tm.getResourceList(comp);
                Enumeration e10 = resList.elements();
                while (e10.hasMoreElements()) {
                    ResourceHandle h2 = (ResourceHandle)e10.nextElement();
                    if (!h2.getResourceSpec().equals(spec) || !h2.getClientSecurityInfo().equals(info)) continue;
                    return h2.getResourceAllocator().getSharedConnection(h2);
                }
            }
        }
        ResourceHandle handle = this.getResourceFromPool(spec, alloc, info, tran);
        this.registerResource(handle);
        return handle.getUserConnection();
    }

    public void registerResource(ResourceHandle handle) throws PoolingException {
        try {
            InvocationManager invmgr;
            ComponentInvocation inv;
            Transaction tran;
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            if (handle.isTransactional() && this.isTransactionActive(tran = (inv = (invmgr = Switch.getSwitch().getInvocationManager()).getCurrentInvocation()).getTransaction())) {
                tm.enlistResource(tran, handle);
            }
            tm.registerComponentResource(handle);
        }
        catch (Exception ex2) {
            ex2.printStackTrace(Log.err);
            Log.err.flush();
            throw new PoolingException(ex2.toString(), ex2);
        }
    }

    public ResourceHandle getResourceFromPool(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info, Transaction tran) throws PoolingException {
        ResourcePool pool = null;
        Hashtable hashtable = this.poolTable;
        synchronized (hashtable) {
            pool = (ResourcePool)this.poolTable.get(spec);
            if (pool == null) {
                pool = new NonSharedResourcePool(this.sleeptime, spec.toString());
                this.poolTable.put(spec, pool);
            }
        }
        ResourceHandle resource = pool.getResource(spec, alloc, tran);
        if (resource == null) {
            resource = alloc.createResource();
            pool.addResource(spec, resource);
        }
        alloc.fillInResourceObjects(resource);
        return resource;
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle res) throws IllegalStateException {
        HashSet hashSet = this.pendingTxns;
        synchronized (hashSet) {
            if (!this.pendingTxns.contains(tran)) {
                this.pendingTxns.add(tran);
                SynchronizationListener sync = new SynchronizationListener(tran);
                try {
                    tran.registerSynchronization(sync);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
        ResourceSpec spec = res.getResourceSpec();
        ResourcePool pool = (ResourcePool)this.poolTable.get(spec);
        if (pool != null) {
            pool.resourceEnlisted(tran, res);
        }
    }

    public void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        HashSet hashSet = this.pendingTxns;
        synchronized (hashSet) {
            this.pendingTxns.remove(tran);
        }
        Hashtable cloneTable = (Hashtable)this.poolTable.clone();
        Enumeration e10 = cloneTable.elements();
        while (e10.hasMoreElements()) {
            ResourcePool pool = (ResourcePool)e10.nextElement();
            pool.transactionCompleted(tran, status);
        }
    }

    public void resourceClosed(ResourceHandle resource) {
        this.unregisterResource(resource, 0x4000000);
        this.putbackResourceToPool(resource, false);
    }

    public void resourceErrorOccurred(ResourceHandle resource) {
        InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
        try {
            ComponentInvocation inv;
            Transaction tran;
            if (resource.isTransactional() && this.isTransactionActive(tran = (inv = invmgr.getCurrentInvocation()).getTransaction())) {
                tran.setRollbackOnly();
            }
        }
        catch (SystemException ex2) {
        }
        catch (IllegalStateException ex3) {
            // empty catch block
        }
        this.unregisterResource(resource, 0x20000000);
        this.putbackResourceToPool(resource, true);
    }

    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        try {
            InvocationManager invmgr;
            ComponentInvocation inv;
            Transaction tran;
            if (resource.isTransactional() && this.isTransactionActive(tran = (inv = (invmgr = Switch.getSwitch().getInvocationManager()).getCurrentInvocation()).getTransaction())) {
                tm.delistResource(tran, resource, xaresFlag);
            }
        }
        catch (SystemException ex2) {
            ex2.printStackTrace(Log.err);
            Log.err.flush();
        }
        catch (IllegalStateException ex3) {
        }
        catch (InvocationException ex4) {
            // empty catch block
        }
        tm.unregisterComponentResource(resource);
    }

    public void putbackResourceToPool(ResourceHandle h2, boolean errorOccurred) {
        try {
            ResourceAllocator alloc = h2.getResourceAllocator();
            alloc.cleanup(h2);
        }
        catch (PoolingException ex2) {
            ex2.printStackTrace(Log.err);
            Log.err.flush();
            errorOccurred = true;
        }
        ResourcePool pool = (ResourcePool)this.poolTable.get(h2.getResourceSpec());
        if (pool != null) {
            if (errorOccurred) {
                pool.resourceErrorOccurred(h2);
            } else {
                pool.resourceClosed(h2);
            }
        }
    }

    public ResourceHandle getSharedResource(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info, Xid xid) throws PoolingException {
        if (xid == null) {
            throw new PoolingException("xid cannot be null");
        }
        Vector<Object> v2 = new Vector<Object>(3);
        v2.addElement(spec);
        v2.addElement(info);
        v2.addElement(xid);
        ResourceHandle resource = (ResourceHandle)this.xid2Connections.get(v2);
        if (resource == null) {
            resource = this.getResourceFromPool(spec, alloc, info, null);
            this.xid2Connections.put(v2, resource);
        }
        return resource;
    }

    public void freeSharedResource(ResourceHandle h2, Xid xid) throws PoolingException {
        Vector<Object> v2 = new Vector<Object>(3);
        v2.addElement(h2.getResourceSpec());
        v2.addElement(h2.getClientSecurityInfo());
        v2.addElement(xid);
        this.xid2Connections.remove(v2);
        this.putbackResourceToPool(h2, false);
    }

    public boolean sharedResourceExists(ResourceSpec spec, ClientSecurityInfo info, Xid xid) {
        Vector<Object> v2 = new Vector<Object>(3);
        v2.addElement(spec);
        v2.addElement(info);
        v2.addElement(xid);
        return this.xid2Connections.get(v2) != null;
    }

    public void emptyResourcePool(ResourceSpec spec) {
        ResourcePool pool = (ResourcePool)this.poolTable.get(spec);
        if (pool != null) {
            pool.emptyPool();
        }
    }

    public ResourceReferenceDescriptor getResourceReference(String jndiName) {
        InvocationManager i2 = Switch.getSwitch().getInvocationManager();
        if (i2 == null) {
            return null;
        }
        ComponentInvocation inv = null;
        try {
            inv = i2.getCurrentInvocation();
        }
        catch (InvocationException ex2) {
            return null;
        }
        int invType = inv.getInvocationType();
        Set refs = null;
        Object container = inv.getContainerContext();
        JndiNameEnvironment env = (JndiNameEnvironment)Switch.getSwitch().getDescriptorFor(container);
        if (env == null) {
            return null;
        }
        refs = env.getResourceReferenceDescriptors();
        Iterator iter = refs.iterator();
        while (iter.hasNext()) {
            ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)iter.next();
            String name = ref.getJndiName();
            if (!jndiName.equals(name)) continue;
            return ref;
        }
        return null;
    }

    private static void assert(boolean value) {
        if (!value) {
            Exception e10 = new Exception();
            e10.printStackTrace();
        }
    }

    public void resizeAllPools(boolean forced) {
        Hashtable cloneTable = (Hashtable)this.poolTable.clone();
        Enumeration e10 = cloneTable.elements();
        while (e10.hasMoreElements()) {
            try {
                ((ResourcePool)e10.nextElement()).resizePool(forced);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Resizer
    extends TimerTask {
        Resizer() {
        }

        public void run() {
            PoolManagerImpl.this.resizeAllPools(false);
        }
    }

    class SynchronizationListener
    implements Synchronization {
        private Transaction tran;

        SynchronizationListener(Transaction tran) {
            this.tran = tran;
        }

        public void afterCompletion(int status) {
            try {
                PoolManagerImpl.this.transactionCompleted(this.tran, status);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void beforeCompletion() {
        }
    }
}

