/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.jms.JmsUtil;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.repository.ConnectorResource;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.repository.JdbcDriver;
import com.sun.enterprise.repository.JdbcResource;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.ResourceAdapter;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.resource.ConfigurationPropertyException;
import com.sun.enterprise.resource.ConnectorInfo;
import com.sun.enterprise.resource.DuplicateNameException;
import com.sun.enterprise.resource.JdbcDataSource;
import com.sun.enterprise.resource.NameNotFoundException;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.SystemJdbcDataSource;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.enterprise.util.EJBClassLoader;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jms.spi.xa.JMSXAConnection;
import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.jms.spi.xa.JMSXAQueueConnectionFactory;
import com.sun.jms.spi.xa.JMSXATopicConnectionFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ResourceInstaller {
    public static final String CONNECTOR_ADAPTER_DIR = "connector" + File.separator + "adapters";
    public static final String CONNECTOR_PROPS = "connector" + File.separator + "connector.properties";
    private static final String XA_JNDI_EXTENSION = "__xa";
    private static final String PM_JNDI_EXTENSION = "__pm";
    private static final String OBSOLETE_JDBC_DRIVER_PROP = "jdbc.drivers";
    private static final String OBSOLETE_JDBC10_PROP = "jdbc.datasources";
    private static final String OBSOLETE_JDBC20_PROP = "jdbc20.datasources";
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$ResourceInstaller == null ? (class$com$sun$enterprise$resource$ResourceInstaller = ResourceInstaller.class$("com.sun.enterprise.resource.ResourceInstaller")) : class$com$sun$enterprise$resource$ResourceInstaller);
    private Hashtable connectorDescriptors = new Hashtable();
    private J2EEResourceFactory resFactory;
    private J2EEResourceCollection resourceInfo;
    static /* synthetic */ Class class$com$sun$enterprise$resource$ResourceInstaller;

    public ResourceInstaller() {
        try {
            this.resFactory = ServerConfiguration.getJ2EEResourceFactory();
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
        }
        catch (J2EEResourceException re) {
            String msg = localStrings.getLocalString("cannot.load.j2ee.resources", "");
            System.err.println(msg);
            re.printStackTrace(Log.err);
            Log.err.flush();
        }
        final Set jdbcDrivers = this.resourceInfo.getResourcesByType(5);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceInstaller.registerJDBCDrivers(jdbcDrivers);
                return null;
            }
        });
    }

    public void recoverXAResources() {
        try {
            Vector xaresList = new Vector();
            Vector jdbcConnList = new Vector();
            Vector jmsConnList = new Vector();
            Vector connectorConnList = new Vector();
            Context ic = Switch.getSwitch().getNamingManager().getInitialContext();
            this.recoverJdbcXAResources(ic, xaresList, jdbcConnList);
            this.recoverJMSXAResources(ic, xaresList, jmsConnList);
            this.recoverConnectorXAResources(ic, xaresList, connectorConnList);
            int size = xaresList.size();
            XAResource[] xaresArray = new XAResource[size];
            int i2 = 0;
            while (i2 < size) {
                xaresArray[i2] = (XAResource)xaresList.elementAt(i2);
                ++i2;
            }
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            String msg = localStrings.getLocalString("xaresource.recovering", "Recovering {0} XA resources...", new Object[]{String.valueOf(size)});
            System.out.println(msg);
            tm.recover(xaresArray);
            this.closeJdbcXAResources(jdbcConnList);
            this.closeJMSXAResources(jmsConnList);
            this.closeConnectorXAResources(connectorConnList);
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            String errString = localStrings.getLocalString("xaresource.recover.error", "Error in XA recovery");
            System.err.println(errString);
        }
    }

    private void recoverJdbcXAResources(Context ic, Vector xaresList, Vector connList) {
        Set xaDatasources = this.resourceInfo.getResourcesByType(4);
        String jndiName = null;
        Iterator iter = xaDatasources.iterator();
        while (iter.hasNext()) {
            JdbcXAResource next = (JdbcXAResource)iter.next();
            try {
                jndiName = ResourceInstaller.getXAJndiName(next.getName());
                String dbUser = next.getDbuser();
                String dbPassword = next.getDbpassword();
                XADataSource ds2 = (XADataSource)ic.lookup(jndiName);
                XAConnection con = ds2.getXAConnection(dbUser, dbPassword);
                connList.addElement(con);
                XAResource xares = con.getXAResource();
                xaresList.addElement(xares);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                String errString = localStrings.getLocalString("datasource.xadatasource.err", "", new Object[]{jndiName, ex2.toString()});
                System.err.println(errString);
                Log.err.println(errString);
            }
        }
    }

    private void recoverJMSXAResources(Context ic, Vector xaresList, Vector connList) {
        Set jmsRes = this.resourceInfo.getResourcesByType(2);
        String jndiName = null;
        Iterator iter = jmsRes.iterator();
        while (iter.hasNext()) {
            JmsCnxFactoryResource next = (JmsCnxFactoryResource)iter.next();
            try {
                XAResource xares;
                JMSXAConnection con;
                JMSXAConnectionFactory fac;
                jndiName = JmsUtil.getXAConnectionFactoryName(next.getName());
                Object obj = ic.lookup(jndiName);
                if (obj instanceof JMSXAQueueConnectionFactory) {
                    fac = (JMSXAQueueConnectionFactory)obj;
                    con = fac.createXAQueueConnection("", "");
                    connList.addElement(con);
                    xares = con.createXAQueueSession(true, 1).getXAResource();
                    xaresList.addElement(xares);
                    continue;
                }
                fac = (JMSXATopicConnectionFactory)obj;
                con = fac.createXATopicConnection("", "");
                connList.addElement(con);
                xares = con.createXATopicSession(true, 1).getXAResource();
                xaresList.addElement(xares);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                String errString = localStrings.getLocalString("datasource.xadatasource.err", "", new Object[]{jndiName, ex2.toString()});
                System.err.println(errString);
                Log.err.println(errString);
            }
        }
    }

    private void recoverConnectorXAResources(Context ic, Vector xaresList, Vector connList) {
        Set connectorRes = this.resourceInfo.getResourcesByType(6);
        String jndiName = null;
        Iterator iter = connectorRes.iterator();
        while (iter.hasNext()) {
            ConnectorResource next = (ConnectorResource)iter.next();
            try {
                jndiName = next.getName();
                String dbUser = next.getDbuser();
                String dbPassword = next.getDbpassword();
                String appName = next.getApplicationName();
                EJBClassLoader jcl = null;
                if (appName == null || appName.equals("")) {
                    jcl = ConnectorClassLoader.getInstance();
                } else {
                    String serverJar = JarRepository.getServerJarFilename(appName);
                    jcl = new JarClassLoader();
                    ((JarClassLoader)jcl).addJar(serverJar);
                }
                ManagedConnectionFactory fac = next.createManagedConnectionFactory(jcl);
                Subject subject = new Subject();
                PasswordCredential pc = new PasswordCredential(dbUser, dbPassword.toCharArray());
                pc.setManagedConnectionFactory(fac);
                ResourcePrincipal prin = new ResourcePrincipal(dbUser, dbPassword);
                subject.getPrincipals().add(prin);
                subject.getPrivateCredentials().add(pc);
                ManagedConnection mc = fac.createManagedConnection(subject, null);
                try {
                    XAResource xares = mc.getXAResource();
                    if (xares == null) continue;
                    connList.addElement(mc);
                    xaresList.addElement(xares);
                }
                catch (ResourceException ex2) {}
            }
            catch (Exception ex3) {
                Log.err.println(ex3);
                String errString = localStrings.getLocalString("datasource.xadatasource.err", "", new Object[]{jndiName, ex3.toString()});
                System.err.println(errString);
                Log.err.println(errString);
            }
        }
    }

    private void closeJdbcXAResources(Vector connList) {
        int size = connList.size();
        int i2 = 0;
        while (i2 < size) {
            try {
                XAConnection con = (XAConnection)connList.elementAt(i2);
                con.close();
            }
            catch (SQLException ex2) {
                Log.err.println(ex2);
            }
            ++i2;
        }
    }

    private void closeJMSXAResources(Vector connList) {
        int size = connList.size();
        int i2 = 0;
        while (i2 < size) {
            try {
                Object obj = connList.elementAt(i2);
                ((JMSXAConnection)obj).close();
            }
            catch (JMSException ex2) {
                Log.err.println(ex2);
            }
            ++i2;
        }
    }

    private void closeConnectorXAResources(Vector connList) {
        int size = connList.size();
        int i2 = 0;
        while (i2 < size) {
            try {
                Object obj = connList.elementAt(i2);
                ((ManagedConnection)obj).destroy();
            }
            catch (ResourceException ex2) {
                Log.err.println(ex2);
            }
            ++i2;
        }
    }

    public static void registerJDBCDrivers(Set jdbcDrivers) {
        Iterator iter = jdbcDrivers.iterator();
        while (iter.hasNext()) {
            JdbcDriver next = (JdbcDriver)iter.next();
            String classname = next.getName();
            try {
                Class.forName(classname).newInstance();
            }
            catch (Exception cnf) {
                try {
                    Class<?> c10 = ClassLoader.getSystemClassLoader().loadClass(classname);
                    try {
                        Object d10 = c10.newInstance();
                    }
                    catch (Exception ex2) {}
                }
                catch (ClassNotFoundException ex3) {
                    Log.err.println(localStrings.getLocalString("poolmgr.loaderror", "Cannot load class " + classname, new Object[]{classname}));
                }
            }
        }
    }

    public void installJdbcDataSources() {
        this.checkObsoleteJdbcConfig(OBSOLETE_JDBC_DRIVER_PROP);
        this.checkObsoleteJdbcConfig(OBSOLETE_JDBC10_PROP);
        this.checkObsoleteJdbcConfig(OBSOLETE_JDBC20_PROP);
        this.installJdbc10DataSources();
        this.installJdbcXADataSources();
    }

    private void checkObsoleteJdbcConfig(String prop) {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String value = config.getProperty(prop);
        if (value != null) {
            String msg = localStrings.getLocalString("obsolete.jdbc.config", "", new Object[]{prop, value});
            System.err.println(msg);
            Log.err.println(msg);
        }
    }

    private static String getXAJndiName(String userJndiName) {
        return userJndiName + XA_JNDI_EXTENSION;
    }

    public static String getPMJndiName(String userJndiName) {
        return userJndiName + PM_JNDI_EXTENSION;
    }

    private void installJdbc10DataSources() {
        NamingManager nm = Switch.getSwitch().getNamingManager();
        int jdbcVersion = 1;
        Set datasources = this.resourceInfo.getResourcesByType(3);
        Iterator iter = datasources.iterator();
        while (iter.hasNext()) {
            String bindName = null;
            try {
                String jndiName;
                J2EEResource next = (J2EEResource)iter.next();
                bindName = jndiName = next.getName();
                JdbcResource jdbcResource = (JdbcResource)next;
                String url = jdbcResource.getUrl();
                JdbcDataSource ds2 = new JdbcDataSource();
                ds2.setDataSourceName(url);
                ds2.setJndiName(jndiName);
                ds2.setJdbcMajorVersion(jdbcVersion);
                System.out.println(localStrings.getLocalString("binding.datasource", "", new Object[]{jndiName, url}));
                nm.publishObject(bindName, (Object)ds2, true);
                SystemJdbcDataSource sds = new SystemJdbcDataSource();
                sds.setDataSourceName(url);
                bindName = ResourceInstaller.getPMJndiName(jndiName);
                sds.setJndiName(bindName);
                sds.setJdbcMajorVersion(jdbcVersion);
                sds.setDescription("J2EE internal use only");
                nm.publishObject(bindName, (Object)sds, true);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                String msg = localStrings.getLocalString("poolmgr.datasourceerror", "Error in creating data source object", new Object[]{bindName});
                System.err.println(msg);
            }
        }
    }

    private void installJdbcXADataSources() {
        Set xaDatasources = this.resourceInfo.getResourcesByType(4);
        NamingManager nm = Switch.getSwitch().getNamingManager();
        int jdbcVersion = 2;
        Iterator iter = xaDatasources.iterator();
        while (iter.hasNext()) {
            String bindName = null;
            try {
                String jndiName;
                JdbcXAResource next = (JdbcXAResource)iter.next();
                bindName = jndiName = next.getName();
                String url = ResourceInstaller.getXAJndiName(jndiName);
                JdbcDataSource ds2 = new JdbcDataSource();
                ds2.setDataSourceName(url);
                ds2.setJndiName(jndiName);
                ds2.setJdbcMajorVersion(jdbcVersion);
                System.out.println(localStrings.getLocalString("binding.datasource", "", new Object[]{jndiName, url}));
                nm.publishObject(bindName, (Object)ds2, true);
                bindName = ResourceInstaller.getXAJndiName(jndiName);
                Object xads = next.createDataSource();
                System.out.println(localStrings.getLocalString("binding.datasource2", "", new Object[]{bindName, xads}));
                nm.publishObject(bindName, xads, true);
                bindName = ResourceInstaller.getPMJndiName(jndiName);
                SystemJdbcDataSource sds = new SystemJdbcDataSource();
                sds.setDataSourceName(url);
                sds.setJndiName(bindName);
                sds.setJdbcMajorVersion(jdbcVersion);
                sds.setDescription("J2EE internal use only");
                nm.publishObject(bindName, (Object)sds, true);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                String msg = localStrings.getLocalString("poolmgr.datasourceerror", "Error in creating data source object", new Object[]{bindName});
                System.err.println(msg);
            }
        }
    }

    public void installResourceAdapters() {
        ConnectorClassLoader cl2 = ConnectorClassLoader.getInstance();
        Set set = this.resourceInfo.getResourcesByType(7);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ResourceAdapter cr2 = (ResourceAdapter)iter.next();
            cl2.addResourceAdapter(cr2.getName());
        }
    }

    public void installResourceAdapter(byte[] data, String name) throws PoolingException {
        try {
            J2EEResource res = this.resourceInfo.getResourceByName(7, name);
            if (res != null) {
                throw new DuplicateNameException(name);
            }
            File dir = new File(FileUtil.getAbsolutePath(CONNECTOR_ADAPTER_DIR));
            File tempFile = File.createTempFile("rar", "temp-rar", dir);
            tempFile.deleteOnExit();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
            out.write(data, 0, data.length);
            out.flush();
            out.close();
            JarFile jarFile = new JarFile(tempFile);
            JarEntry ddEntry = jarFile.getJarEntry(ConnectorArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
            if (ddEntry == null) {
                throw new PoolingException("Cannot find ra.xml file");
            }
            Archivist.validate(jarFile.getInputStream(ddEntry));
            InputStream xmlInput = jarFile.getInputStream(ddEntry);
            ConnectorNode node = ConnectorNode.read(xmlInput);
            ConnectorDescriptor desc = node.getDescriptor();
            this.registerConnectorDescriptor(desc, null, name);
            xmlInput.close();
            File rarFile = new File(FileUtil.getAbsolutePath(CONNECTOR_ADAPTER_DIR + File.separator + name));
            JarOutputStream rarOut = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(rarFile)));
            ApplicationArchivist.expandRarFile(jarFile, rarOut);
            xmlInput = jarFile.getInputStream(ddEntry);
            rarOut.putNextEntry(new JarEntry(ddEntry));
            Archivist.copy(xmlInput, rarOut);
            ((FilterOutputStream)rarOut).flush();
            rarOut.close();
            xmlInput.close();
            jarFile.close();
            tempFile.delete();
            ResourceAdapter ra = new ResourceAdapter(name);
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
            this.resourceInfo.addResource(ra);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
            ConnectorClassLoader.getInstance().addResourceAdapter(name);
        }
        catch (PoolingException ex2) {
            ex2.printStackTrace(Log.err);
            Log.err.flush();
            throw ex2;
        }
        catch (Exception ex3) {
            ex3.printStackTrace(Log.err);
            Log.err.flush();
            throw new PoolingException(localStrings.getLocalString("poolmgr.resourceadaptererror", "Error in installing resource adapters: {0}", new Object[]{ex3.getLocalizedMessage()}));
        }
    }

    public void uninstallResourceAdapter(String name) throws PoolingException {
        try {
            ResourceAdapter res = (ResourceAdapter)this.resourceInfo.getResourceByName(7, name);
            if (res == null) {
                throw new NameNotFoundException(name);
            }
            this.forceResourcePoolCleanup(null, name);
            this.unregisterConnectorDescriptor(null, name);
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
            this.resourceInfo.removeResource(res);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
            File rarFile = new File(FileUtil.getAbsolutePath(CONNECTOR_ADAPTER_DIR + File.separator + name));
            rarFile.delete();
        }
        catch (J2EEResourceException ex2) {
            Log.err.println(ex2);
            throw new PoolingException("Error accessing configuration file: " + ex2);
        }
    }

    private String[] getAllConnectionFactories() {
        Set res = this.resourceInfo.getResourcesByType(6);
        int size = res.size();
        String[] result = new String[size];
        Iterator iter = res.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            result[i2++] = ((J2EEResource)iter.next()).getName();
        }
        return result;
    }

    private String[] getAllConnectors() {
        Set set = this.resourceInfo.getResourcesByType(7);
        int size = set.size();
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ResourceAdapter cr2 = (ResourceAdapter)iter.next();
            result.add(cr2.getName());
        }
        Vector appNames = JarRepository.getApplicationList();
        Enumeration e10 = appNames.elements();
        while (e10.hasMoreElements()) {
            String appName = (String)e10.nextElement();
            this.findEmbeddedAdapters(appName, result);
        }
        int resultSize = result.size();
        String[] arr = new String[resultSize];
        int i2 = 0;
        while (i2 < resultSize) {
            arr[i2] = (String)result.get(i2);
            ++i2;
        }
        return arr;
    }

    private void findEmbeddedAdapters(String appName, List list) {
        String appJarFile = JarRepository.getJarFilename(appName);
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(new File(appJarFile));
        }
        catch (IOException ex2) {
            Log.err.println(ex2);
            return;
        }
        Enumeration<JarEntry> e10 = jarFile.entries();
        while (e10.hasMoreElements()) {
            ZipEntry zipEntry = e10.nextElement();
            String name = zipEntry.getName();
            if (!name.endsWith(".rar")) continue;
            list.add(this.getFullConnectorName(appName, name));
        }
    }

    public ConnectorInfo listResourceAdapters() throws PoolingException {
        ConnectorInfo info = new ConnectorInfo();
        info.connectors = this.getAllConnectors();
        info.connectionFactories = this.getAllConnectionFactories();
        return info;
    }

    public Set listConnectorResources() {
        Set res = this.resourceInfo.getResourcesByType(6);
        return res;
    }

    public void installConnectionFactories() throws PoolingException {
        try {
            Set res = this.resourceInfo.getResourcesByType(6);
            NamingManager nm = Switch.getSwitch().getNamingManager();
            Iterator iter = res.iterator();
            while (iter.hasNext()) {
                ConnectorResource cr2 = (ConnectorResource)iter.next();
                String jndiName = cr2.getName();
                String msg = localStrings.getLocalString("binding.connection.factory", "", new Object[]{jndiName});
                System.out.println(msg);
                Reference ref = cr2.createConnectionFactoryReference();
                nm.publishObject(jndiName, (Object)ref, true);
            }
        }
        catch (Exception ex2) {
            System.err.println("Error in installing connection factories " + ex2.toString());
            ex2.printStackTrace(Log.err);
            Log.err.flush();
        }
    }

    public void addConnectionFactory(String appName, String connectorName, String jndiName, String user, String password, Properties props) throws PoolingException {
        ConnectorDescriptor desc;
        if (props == null) {
            props = new Properties();
        }
        if ((desc = this.getDescriptorByConnectorName(appName, connectorName)) == null) {
            throw new NameNotFoundException(this.getFullConnectorName(appName, connectorName));
        }
        ConnectorResource cr2 = (ConnectorResource)this.resourceInfo.getResourceByName(6, jndiName);
        if (cr2 != null) {
            throw new DuplicateNameException(jndiName);
        }
        HashSet<String> propNames = new HashSet<String>();
        Iterator iter = desc.getConfigProperties().iterator();
        while (iter.hasNext()) {
            EnvironmentProperty envProp = (EnvironmentProperty)iter.next();
            propNames.add(envProp.getName());
        }
        Enumeration e10 = ((Hashtable)props).keys();
        while (e10.hasMoreElements()) {
            String propName = (String)e10.nextElement();
            if (propNames.contains(propName)) continue;
            throw new ConfigurationPropertyException(propName);
        }
        cr2 = new ConnectorResource(jndiName);
        cr2.setApplicationName(appName);
        cr2.setConnectorName(connectorName);
        cr2.setDbuser(user);
        cr2.setDbpassword(password);
        cr2.setConnectionFactoryClass(desc.getConnectionFactoryImpl());
        iter = desc.getConfigProperties().iterator();
        while (iter.hasNext()) {
            EnvironmentProperty envProp = (EnvironmentProperty)iter.next();
            String name = envProp.getName();
            String userValue = props.getProperty(name);
            if (userValue == null) {
                userValue = envProp.getValue();
            }
            ResourcePropertyImpl rp = new ResourcePropertyImpl(name, userValue);
            cr2.addProperty(rp);
        }
        try {
            Reference ref = cr2.createConnectionFactoryReference();
            NamingManager nm = Switch.getSwitch().getNamingManager();
            nm.publishObject(jndiName, (Object)ref, true);
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
            this.resourceInfo.addResource(cr2);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
        }
        catch (Exception ex2) {
            ex2.printStackTrace(Log.err);
            Log.err.flush();
            throw new PoolingException(ex2.toString());
        }
    }

    public void removeConnectionFactory(String jndiName) throws PoolingException {
        try {
            ConnectorResource cr2 = (ConnectorResource)this.resourceInfo.getResourceByName(6, jndiName);
            if (cr2 == null) {
                throw new NameNotFoundException(jndiName);
            }
            NamingManager nm = Switch.getSwitch().getNamingManager();
            Context ctx = nm.getInitialContext();
            ctx.unbind(jndiName);
            this.resourceInfo = this.resFactory.loadDefaultResourceCollection();
            this.resourceInfo.removeResource(cr2);
            this.resFactory.storeDefaultResourceCollection(this.resourceInfo);
        }
        catch (Exception ex2) {
            if (ex2 instanceof PoolingException) {
                throw (PoolingException)ex2;
            }
            ex2.printStackTrace(Log.err);
            Log.err.flush();
            throw new PoolingException(ex2.toString());
        }
    }

    public void registerConnectorDescriptor(ConnectorDescriptor desc, String appName, String connectorName) {
        if (appName != null) {
            ResourceInstaller.assert(desc.getArchivist().getArchiveUri().equals(connectorName));
        }
        String fullName = this.getFullConnectorName(appName, connectorName);
        this.connectorDescriptors.put(fullName, desc);
    }

    public void unregisterConnectorDescriptor(String appName, String connectorName) {
        String fullName = this.getFullConnectorName(appName, connectorName);
        this.connectorDescriptors.remove(fullName);
    }

    public void forceResourcePoolCleanup(String appName, String connectorName) {
        String fullName = this.getFullConnectorName(appName, connectorName);
        PoolManager poolMgr = Switch.getSwitch().getPoolManager();
        Set res = this.resourceInfo.getResourcesByType(6);
        Iterator iter = res.iterator();
        while (iter.hasNext()) {
            ConnectorResource cr2 = (ConnectorResource)iter.next();
            String crFullName = this.getFullConnectorName(cr2.getApplicationName(), cr2.getConnectorName());
            if (!crFullName.equals(fullName)) continue;
            ResourceSpec spec = new ResourceSpec(cr2.getName(), 1);
            poolMgr.emptyResourcePool(spec);
        }
    }

    public ConnectorDescriptor getDescriptorByJndiName(String jndiName) {
        ConnectorResource cr2 = (ConnectorResource)this.resourceInfo.getResourceByName(6, jndiName);
        if (cr2 == null) {
            return null;
        }
        return this.getDescriptorByConnectorName(cr2.getApplicationName(), cr2.getConnectorName());
    }

    public ConnectorDescriptor getDescriptorByConnectorName(String appName, String connectorName) {
        try {
            String name = this.getFullConnectorName(appName, connectorName);
            ConnectorDescriptor result = (ConnectorDescriptor)this.connectorDescriptors.get(name);
            if (result != null) {
                return result;
            }
            ResourceAdapter ra = (ResourceAdapter)this.resourceInfo.getResourceByName(7, name);
            ConnectorDescriptor desc = null;
            if (ra != null) {
                File rarFile = new File(FileUtil.getAbsolutePath(CONNECTOR_ADAPTER_DIR + File.separator + ra.getName()));
                JarFile jarFile = new JarFile(rarFile);
                JarEntry entry = jarFile.getJarEntry(ConnectorArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                InputStream xmlInput = jarFile.getInputStream(entry);
                ConnectorNode node = ConnectorNode.read(xmlInput);
                desc = node.getDescriptor();
                xmlInput.close();
                jarFile.close();
            } else {
                Application app = JarRepository.getApplicationForName(appName);
                if (app == null) {
                    return null;
                }
                try {
                    desc = app.getRarDescriptorByUri(connectorName);
                }
                catch (IllegalArgumentException ex2) {
                    return null;
                }
            }
            if (desc != null) {
                this.connectorDescriptors.put(name, desc);
            }
            return desc;
        }
        catch (Exception ex3) {
            Log.err.println(ex3);
            return null;
        }
    }

    public Object createConnectionFactory(String jndiName) {
        ConnectorResource cr2 = (ConnectorResource)this.resourceInfo.getResourceByName(6, jndiName);
        try {
            Object result = cr2.createConnectionFactory();
            return result;
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            return null;
        }
    }

    private String getFullConnectorName(String appName, String connectorName) {
        if (connectorName == null) {
            throw new NullPointerException("Null connectorName");
        }
        if (appName == null || appName.equals("")) {
            return connectorName;
        }
        return appName + ":" + connectorName;
    }

    private static void assert(boolean value) {
        if (!value) {
            Thread.dumpStack();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

