/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.AbstractSystemJdbcAllocator;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.SystemJdbc10XaAllocator;
import com.sun.enterprise.resource.SystemJdbc20XaAllocator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class SystemJdbcDataSource
implements DataSource,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$JdbcDataSource == null ? (class$com$sun$enterprise$resource$JdbcDataSource = SystemJdbcDataSource.class$("com.sun.enterprise.resource.JdbcDataSource")) : class$com$sun$enterprise$resource$JdbcDataSource);
    private transient PoolManager poolMgr;
    private static final boolean debug = false;
    private String dataSourceName;
    private String desc;
    private String jndiName;
    private int jdbcMajorVersion;
    static /* synthetic */ Class class$com$sun$enterprise$resource$JdbcDataSource;

    public Connection getConnection() throws SQLException {
        throw new SQLException("Not supported. Use getConnection(user, password)");
    }

    public Connection getConnection(String username, String password) throws SQLException {
        this.initPoolManager();
        return this.internalGetConnection(username, password);
    }

    private Connection internalGetConnection(String username, String password) throws SQLException {
        AbstractSystemJdbcAllocator alloc = null;
        ResourceSpec spec = new ResourceSpec(this.jndiName, 1);
        ResourcePrincipal prin = new ResourcePrincipal(username, password);
        ClientSecurityInfo info = new ClientSecurityInfo(prin);
        alloc = this.jdbcMajorVersion == 1 ? new SystemJdbc10XaAllocator(this.poolMgr, this.dataSourceName, spec, info) : new SystemJdbc20XaAllocator(this.poolMgr, this.dataSourceName, spec, info);
        try {
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            Transaction tran = tm.getTransaction();
            ResourceHandle handle = this.poolMgr.getResourceFromPool(spec, alloc, new ClientSecurityInfo(prin), tran);
            if (tran != null) {
                tm.enlistResource(tran, handle);
            }
            return (Connection)handle.getUserConnection();
        }
        catch (PoolingException ex2) {
            Exception nex = ex2.getNestedException();
            if (nex instanceof SQLException) {
                throw (SQLException)nex;
            }
            if (nex instanceof RuntimeException) {
                throw (RuntimeException)nex;
            }
            nex.printStackTrace();
            nex.printStackTrace(Log.err);
            throw new SQLException(nex.toString());
        }
        catch (SystemException ex3) {
            Log.err.println(ex3);
            throw new SQLException(ex3.toString());
        }
        catch (IllegalStateException ex4) {
            Log.err.println(ex4);
            throw new SQLException(ex4.toString());
        }
        catch (RollbackException ex5) {
            Log.err.println(ex5);
            throw new SQLException(ex5.toString());
        }
    }

    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public void setJdbcMajorVersion(int version) {
        this.jdbcMajorVersion = version;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public int getLoginTimeout() throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    private void initPoolManager() {
        if (this.poolMgr == null) {
            this.poolMgr = Switch.getSwitch().getPoolManager();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

