/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.net.ssl.X509KeyManager;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.security.auth.Subject;

public final class J2EEKeyManager
implements X509KeyManager {
    private static boolean debug = false;
    public static final String SELECT_CERT = "com.sun.enterprise.selectCert";
    public static final String CERT_ALIAS = "com.sun.enterprise.certAlias";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$J2EEKeyManager == null ? (class$com$sun$enterprise$security$J2EEKeyManager = J2EEKeyManager.class$("com.sun.enterprise.security.J2EEKeyManager")) : class$com$sun$enterprise$security$J2EEKeyManager);
    private X509KeyManager mgr = null;
    static /* synthetic */ Class class$com$sun$enterprise$security$J2EEKeyManager;

    public J2EEKeyManager(X509KeyManager mgr) {
        this.mgr = mgr;
    }

    public String chooseClientAlias(String keyType, Principal[] issuers) {
        String chooseCert;
        if (debug) {
            System.out.println("Choose client Alias for keytype:" + keyType);
        }
        if ((chooseCert = System.getProperty(SELECT_CERT)) == null) {
            return this.mgr.chooseClientAlias(keyType, issuers);
        }
        if (chooseCert.equalsIgnoreCase("false")) {
            return this.mgr.chooseClientAlias(keyType, issuers);
        }
        String alias = System.getProperty(CERT_ALIAS);
        if (alias != null) {
            return alias;
        }
        InvocationManager im = Switch.getSwitch().getInvocationManager();
        if (im == null) {
            return this.mgr.chooseClientAlias(keyType, issuers);
        }
        ComponentInvocation ci2 = im.getCurrentInvocation();
        Object containerContext = ci2.getContainerContext();
        if (containerContext != null && containerContext instanceof AppContainer) {
            ClientSecurityContext ctx = ClientSecurityContext.getCurrent();
            Subject s2 = ctx.getSubject();
            if (s2 == null) {
                LoginContextDriver.doClientLogin(2, AppContainer.handler);
                s2 = ctx.getSubject();
            }
            Iterator itr = s2.getPrivateCredentials().iterator();
            while (itr.hasNext()) {
                Object o2 = itr.next();
                if (!(o2 instanceof X509CertificateCredential)) continue;
                X509CertificateCredential crt = (X509CertificateCredential)o2;
                String alias_to_send = crt.getAlias();
                return alias_to_send;
            }
        }
        return this.mgr.chooseClientAlias(keyType, issuers);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers) {
        if (debug) {
            System.out.println("Choose server Alias for keytype:" + keyType);
        }
        return this.mgr.chooseServerAlias(keyType, issuers);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        if (debug) {
            System.out.println("Getting certificate chain");
        }
        return this.mgr.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (debug) {
            System.out.println("Getting client aliases");
        }
        return this.mgr.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (debug) {
            System.out.println("Getting server aliases");
        }
        return this.mgr.getServerAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        if (debug) {
            System.out.println("Getting private key for alias:" + alias);
        }
        return this.mgr.getPrivateKey(alias);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

