/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;

public final class KeyTool {
    private static final String JSSE_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    private boolean debug = false;
    private File inputFile = null;
    private File outputFile = null;
    private char[] jksKeyStorePass;
    private char[] pkcsKeyStorePass = null;
    private char[] jksKeyPass = null;
    private char[] pkcsKeyPass = null;
    private String provider = null;
    private KeyStore pkcs12KeyStore = null;
    private KeyStore jksKeyStore = null;
    private static String PKCS12 = "-pkcs12";
    private static String INFILE = "-pkcsFile";
    private static String OUTFILE = "-jksFile";
    private static String PKCSKEYSTOREPASS = "-pkcsKeyStorePass";
    private static String PKCSKEYPASS = "-pkcsKeyPass";
    private static String JKSKEYSTOREPASS = "-jksKeyStorePass";
    private static String JKSKEYPASS = "-jksKeyPass";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$KeyTool == null ? (class$com$sun$enterprise$security$KeyTool = KeyTool.class$("com.sun.enterprise.security.KeyTool")) : class$com$sun$enterprise$security$KeyTool);
    static /* synthetic */ Class class$com$sun$enterprise$security$KeyTool;

    public KeyTool(String infile, String outfile, String pkcsKeyStorePass, String pkcsKeyPass, String jksKeyStorePass, String jksKeyPass, String provider) throws IOException {
        this.inputFile = new File(infile);
        this.outputFile = new File(outfile);
        this.pkcsKeyStorePass = pkcsKeyStorePass.toCharArray();
        this.pkcsKeyPass = pkcsKeyPass.toCharArray();
        this.jksKeyStorePass = jksKeyStorePass.toCharArray();
        this.jksKeyPass = jksKeyPass.toCharArray();
        this.provider = provider;
        try {
            if (this.outputFile.exists()) {
                throw new IOException("Output file already exists!");
            }
            this.pkcs12KeyStore = KeyStore.getInstance("PKCS12", provider);
            this.jksKeyStore = KeyStore.getInstance("JKS");
        }
        catch (Exception e10) {
            throw new IOException(e10.getMessage());
        }
        this.readKeyStores();
    }

    /*
     * Loose catch block
     */
    public void readKeyStores() throws IOException {
        block16: {
            FileInputStream pkcsFis = null;
            FileInputStream jksFis = null;
            pkcsFis = new FileInputStream(this.inputFile);
            jksFis = new FileInputStream(this.outputFile);
            Object var5_3 = null;
            try {
                this.pkcs12KeyStore.load(pkcsFis, this.pkcsKeyStorePass);
                this.jksKeyStore.load(jksFis, null);
            }
            catch (Exception ce2) {
                ce2.printStackTrace();
            }
            if (pkcsFis != null) {
                pkcsFis.close();
            }
            if (jksFis != null) {
                jksFis.close();
            }
            break block16;
            {
                catch (Exception e10) {
                    Object var5_4 = null;
                    try {
                        this.pkcs12KeyStore.load(pkcsFis, this.pkcsKeyStorePass);
                        this.jksKeyStore.load(jksFis, null);
                    }
                    catch (Exception ce2) {
                        ce2.printStackTrace();
                    }
                    if (pkcsFis != null) {
                        pkcsFis.close();
                    }
                    if (jksFis != null) {
                        jksFis.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    this.pkcs12KeyStore.load(pkcsFis, this.pkcsKeyStorePass);
                    this.jksKeyStore.load(jksFis, null);
                }
                catch (Exception ce2) {
                    ce2.printStackTrace();
                }
                if (pkcsFis != null) {
                    pkcsFis.close();
                }
                if (jksFis != null) {
                    jksFis.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void writeJksKeyStore() throws IOException {
        block13: {
            FileOutputStream fos = null;
            fos = new FileOutputStream(this.outputFile);
            Object var4_2 = null;
            try {
                this.jksKeyStore.store(fos, this.jksKeyStorePass);
            }
            catch (Exception ce2) {
                ce2.printStackTrace();
            }
            if (fos != null) {
                fos.close();
            }
            break block13;
            {
                catch (Exception e10) {
                    Object var4_3 = null;
                    try {
                        this.jksKeyStore.store(fos, this.jksKeyStorePass);
                    }
                    catch (Exception ce2) {
                        ce2.printStackTrace();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.jksKeyStore.store(fos, this.jksKeyStorePass);
                }
                catch (Exception ce2) {
                    ce2.printStackTrace();
                }
                if (fos != null) {
                    fos.close();
                }
                throw throwable;
            }
        }
    }

    public void replicatePkcs12ToJks() throws Exception {
        Enumeration<String> e10 = this.pkcs12KeyStore.aliases();
        while (e10.hasMoreElements()) {
            String alias = e10.nextElement();
            if (this.pkcs12KeyStore.isKeyEntry(alias)) {
                if (this.debug) {
                    System.out.println("Alias " + alias + " is a key entry ");
                }
                Key key = this.pkcs12KeyStore.getKey(alias, this.pkcsKeyPass);
                Certificate[] certs = this.pkcs12KeyStore.getCertificateChain(alias);
                this.jksKeyStore.setKeyEntry(alias, key, this.jksKeyPass, certs);
                continue;
            }
            if (!this.pkcs12KeyStore.isCertificateEntry(alias)) continue;
            if (this.debug) {
                System.out.println(" Alias " + alias + " is a certificate entry");
            }
            this.jksKeyStore.setCertificateEntry(alias, this.pkcs12KeyStore.getCertificate(alias));
        }
    }

    public void info() throws Exception {
        System.out.println(" Keystore Information");
        System.out.println(" Type = " + this.pkcs12KeyStore.getType());
        System.out.println(" Provider = " + this.pkcs12KeyStore.getProvider());
        System.out.println(" KeyStore size = " + this.pkcs12KeyStore.size());
        Enumeration<String> e10 = this.pkcs12KeyStore.aliases();
        System.out.println(" Kstore Aliases ");
        while (e10.hasMoreElements()) {
            String alias = e10.nextElement();
            System.out.println(" Alias = " + alias);
            if (this.pkcs12KeyStore.isKeyEntry(alias)) {
                System.out.println("Alias is a key entry ");
                Key key = this.pkcs12KeyStore.getKey(alias, this.pkcsKeyPass);
                System.out.println(" Format = " + key.getFormat());
                continue;
            }
            if (!this.pkcs12KeyStore.isCertificateEntry(alias)) continue;
            System.out.println(" Alias is a certificate entry");
        }
        System.out.println(" End of Information");
    }

    public static void initProvider() {
        try {
            Provider p2 = (Provider)Class.forName(JSSE_PROVIDER).newInstance();
            Security.addProvider(p2);
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    public static String getProviderName() {
        try {
            Provider p2 = (Provider)Class.forName(JSSE_PROVIDER).newInstance();
            return p2.getName();
        }
        catch (Exception e10) {
            e10.printStackTrace();
            return null;
        }
    }

    public static void help(boolean exit) {
        System.out.println(localStrings.getLocalString("enterprise.security.keytool", "keytool"));
        System.out.println(localStrings.getLocalString("enterprise.security.keytooloptions", "PKCS Options:"));
        System.out.println(" " + PKCS12 + " " + INFILE + " fileName" + " " + PKCSKEYSTOREPASS + " password" + " " + PKCSKEYPASS + " password" + " " + OUTFILE + " outputFileName" + " " + JKSKEYSTOREPASS + " password");
        if (exit) {
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        boolean pkcs = false;
        KeyTool.initProvider();
        String provider = null;
        String inFile = null;
        String outFile = null;
        String jksKeyPass = null;
        String jksKeyStorePass = null;
        String pkcsKeyPass = null;
        String pkcsKeyStorePass = null;
        try {
            if (args.length == 0) {
                KeyTool.help(false);
                sun.security.tools.KeyTool.main((String[])args);
            }
            if (args[0].equalsIgnoreCase(PKCS12)) {
                pkcs = true;
                if (args.length != 11) {
                    KeyTool.help(true);
                }
                if (!args[1].equalsIgnoreCase(INFILE)) {
                    KeyTool.help(true);
                }
                inFile = args[2];
                if (!args[3].equalsIgnoreCase(PKCSKEYSTOREPASS)) {
                    KeyTool.help(true);
                }
                pkcsKeyStorePass = args[4];
                if (!args[5].equalsIgnoreCase(PKCSKEYPASS)) {
                    KeyTool.help(true);
                }
                pkcsKeyPass = args[6];
                if (!args[7].equalsIgnoreCase(OUTFILE)) {
                    KeyTool.help(true);
                }
                outFile = args[8];
                if (!args[9].equalsIgnoreCase(JKSKEYSTOREPASS)) {
                    KeyTool.help(true);
                }
                jksKeyPass = jksKeyStorePass = args[10];
            }
            if (!pkcs) {
                sun.security.tools.KeyTool.main((String[])args);
            } else {
                provider = KeyTool.getProviderName();
                KeyTool kt = new KeyTool(inFile, outFile, pkcsKeyStorePass, pkcsKeyPass, jksKeyStorePass, jksKeyPass, provider);
                kt.replicatePkcs12ToJks();
                kt.writeJksKeyStore();
            }
        }
        catch (Exception e10) {
            System.out.println(e10.getMessage());
            e10.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

