/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.security.IRealmManager;
import com.sun.enterprise.security.auth.RemoteObject;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.rmi.RemoteException;
import javax.naming.NamingException;

public class RealmManager
extends RemoteObject
implements IRealmManager {
    public static String REALM_MANAGER_NAME = "Realm_Manager";
    private static final boolean debug = false;
    private static String REALMS_LIST = "auth.realms";
    private static String REALM_PREFIX = "auth.realm.";
    private ServerConfiguration config = ServerConfiguration.getConfiguration();
    static /* synthetic */ Class class$com$sun$enterprise$security$IRealmManager;

    public void init() throws NamingException, RemoteException {
        this.createRealms();
        this.bindObjects();
        this.selfTest();
    }

    private void createRealms() {
        String[] realms = TypeUtil.stringToArray(this.config.getProperty(REALMS_LIST), ",");
        int i2 = 0;
        while (i2 < realms.length) {
            String realmName = REALM_PREFIX + realms[i2];
            String realmFile = this.config.getProperty(realmName);
            try {
                File rfile = new File(FileUtil.getAbsolutePath(realmFile));
                Realm.instantiate(realms[i2], rfile);
            }
            catch (Exception e10) {
                e10.printStackTrace(System.err);
            }
            ++i2;
        }
    }

    private void bindObjects() throws NamingException, RemoteException {
        RealmManager irlm = this;
        Utility.bindObject(REALM_MANAGER_NAME, irlm);
    }

    private void selfTest() throws NamingException, RemoteException {
        IRealmManager iRealmManager = (IRealmManager)Utility.lookupObject(REALM_MANAGER_NAME, class$com$sun$enterprise$security$IRealmManager == null ? (class$com$sun$enterprise$security$IRealmManager = RealmManager.class$("com.sun.enterprise.security.IRealmManager")) : class$com$sun$enterprise$security$IRealmManager);
    }

    public void start() throws InterruptedException {
        Object sync;
        Object object = sync = new Object();
        synchronized (object) {
            sync.wait();
        }
    }

    public void refreshRealms(String realmName) throws RemoteException {
        try {
            Realm r2 = Realm.getInstance(realmName);
            r2.refresh();
        }
        catch (Exception e10) {
            throw new RemoteException(e10.toString());
        }
    }

    public static void main(String[] args) {
        try {
            Utility.checkJVMVersion();
            ORBManager.init(args, null);
            Switch theSwitch = Switch.getSwitch();
            NamingManagerImpl nm = new NamingManagerImpl();
            theSwitch.setNamingManager(nm);
            RealmManager mgr = new RealmManager();
            mgr.init();
            mgr.start();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

