/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.security.AbstractSecurityContext;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.LoginContextDriver;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;

public class SecurityContext
extends AbstractSecurityContext {
    private static InheritableThreadLocal currentSecCtx = new InheritableThreadLocal();
    private static SecurityContext defaultSecurityContext = null;
    private boolean SERVER_GENERATED_SECURITY_CONTEXT = false;
    static /* synthetic */ Class class$com$sun$enterprise$security$SecurityContext;

    public SecurityContext(String userName, Credentials creds, Subject s2) {
        this.initiator = new PrincipalImpl(userName);
        this.credentials = creds;
        this.subject = s2;
    }

    public static SecurityContext init() {
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc == null) {
            if (defaultSecurityContext == null) {
                SecurityContext.generateDefaultSecurityContext();
            }
            SecurityContext.setCurrent(defaultSecurityContext);
            return defaultSecurityContext;
        }
        return sc;
    }

    public static void setUnauthenticatedContext() {
        if (defaultSecurityContext == null) {
            SecurityContext.generateDefaultSecurityContext();
        }
        SecurityContext.setCurrent(defaultSecurityContext);
    }

    private static void generateDefaultSecurityContext() {
        String PRINCIPAL_NAME = "auth.default.principal.name";
        String PRINCIPAL_PASS = "auth.default.principal.password";
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        final String username = config.getProperty("auth.default.principal.name", "guest");
        final String password = config.getProperty("auth.default.principal.password", "guest123");
        Class clazz = class$com$sun$enterprise$security$SecurityContext == null ? (class$com$sun$enterprise$security$SecurityContext = SecurityContext.class$("com.sun.enterprise.security.SecurityContext")) : class$com$sun$enterprise$security$SecurityContext;
        synchronized (clazz) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        LoginContextDriver.login(username, password);
                        return null;
                    }
                });
                defaultSecurityContext = SecurityContext.getCurrent();
                defaultSecurityContext.setServerGeneratedCredentials();
                SecurityContext.setCurrent(null);
            }
            catch (Exception e10) {
                e10.printStackTrace();
            }
        }
    }

    public static void reset(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    public static SecurityContext getCurrent() {
        return (SecurityContext)currentSecCtx.get();
    }

    public static void setCurrent(SecurityContext sc) {
        currentSecCtx.set(sc);
    }

    public boolean didServerGenerateCredentials() {
        return this.SERVER_GENERATED_SECURITY_CONTEXT;
    }

    private void setServerGeneratedCredentials() {
        this.SERVER_GENERATED_SECURITY_CONTEXT = true;
    }

    public Principal getCallerPrincipal() {
        return this.initiator;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "SecurityContext[ Initiator: " + this.initiator + " Credentials " + this.credentials + "Subject " + this.subject + " ]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

