/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.AccessControlList;
import com.sun.enterprise.security.acl.Resource;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.security.AccessControlException;
import java.security.Guard;
import java.util.Enumeration;

public class ResourceGuard
implements Guard {
    private static boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$acl$ResourceGuard == null ? (class$com$sun$enterprise$security$acl$ResourceGuard = ResourceGuard.class$("com.sun.enterprise.security.acl.ResourceGuard")) : class$com$sun$enterprise$security$acl$ResourceGuard);
    private AccessControlList acl;
    static /* synthetic */ Class class$com$sun$enterprise$security$acl$ResourceGuard;

    public ResourceGuard(AccessControlList acl) {
        this.acl = acl;
        if (debug) {
            System.out.println("Created a Resource Guard with: " + acl);
        }
    }

    public void checkGuard(Object obj) throws SecurityException {
        if (debug) {
            System.out.println("Checking Access to the Object " + obj);
            System.out.println("ACL protecting this resource " + this.acl);
            System.out.println("The object is an instance of class " + obj.getClass());
        }
        if (this.acl.checkAccess(RoleMapper.getDefaultRole())) {
            return;
        }
        if (obj instanceof Resource) {
            Resource r2 = (Resource)obj;
            RoleMapper rmapper = RoleMapper.getRoleMapper(r2.getApplication());
            Enumeration rlist = rmapper.getCurrentRoles();
            while (rlist.hasMoreElements()) {
                Role role = (Role)rlist.nextElement();
                if (debug) {
                    System.out.println("Checking for the role: " + role);
                }
                if (!this.acl.checkAccess(role)) continue;
                if (debug) {
                    System.out.println("Access to the Resource: " + r2 + " was allowed for a user with role " + role);
                }
                return;
            }
            throw new AccessControlException(localStrings.getLocalString("resourceguard.access_denied", "Access to the Resource is Denied"));
        }
        throw new SecurityException(localStrings.getLocalString("resourceguard.invalid_resource", "Invalid Resource."));
    }

    public String toString() {
        return "Guard(" + this.acl.toString() + ")";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

