/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.application;

import com.sun.ejb.Invocation;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.log.FileLogWriter;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.application.Audit;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Date;

public class AuditLog
implements Audit {
    private static boolean debug = false;
    private static final String AUDIT_LOG_FILE = "audit.log.file";
    private static Log log = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$application$AuditLog == null ? (class$com$sun$enterprise$security$application$AuditLog = AuditLog.class$("com.sun.enterprise.security.application.AuditLog")) : class$com$sun$enterprise$security$application$AuditLog);
    static /* synthetic */ Class class$com$sun$enterprise$security$application$AuditLog;

    AuditLog() {
        if (log == null) {
            log = AuditLog.initLog();
        }
    }

    private static synchronized Log initLog() {
        Log aLog = null;
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String serverId = System.getProperty("com.sun.enterprise.J2EEServerId", "j2ee");
        String appname = System.getProperty("com.sun.enterprise.appname");
        if (appname == null || appname.equals("")) {
            appname = serverId;
        }
        File dir = LogUtil.getLogDirectory(appname, "j2ee");
        if (debug) {
            System.out.println("AUDIT Log:" + dir);
        }
        try {
            aLog = AuditLog.getLog(dir, config.getProperty(AUDIT_LOG_FILE, "audit.log"));
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            aLog = Log.out;
        }
        return aLog;
    }

    private static Log getLog(File dir, String logFileName) throws IOException {
        File logfile = new File(dir, logFileName);
        if (!logfile.exists()) {
            logfile.createNewFile();
        }
        return Log.getLog(new FileLogWriter(logfile));
    }

    public synchronized void log(Invocation inv, String message) {
        if (debug) {
            this.print(inv);
        }
        log.println(localStrings.getLocalString("enterprise.security.audit_log_invocation", "Audit Log: Invocation"));
        log.println("Principal: " + this.getCallerPrincipal());
        log.println("EJBObject: " + inv.ejbObject);
        log.println("Method: " + inv.method);
        log.println("Time: " + new Date());
        log.println("Status: " + message);
        log.println("};");
    }

    public void flush() {
        log.flush();
    }

    public Log getLog() {
        return log;
    }

    private void print(Invocation inv) {
        System.out.println("Security Manager: Invocation {");
        System.out.println("EJBClass=" + inv.ejb);
        System.out.println("EJBObject=" + inv.ejbObject);
        System.out.println("Method=" + inv.method);
        System.out.println("Context=" + inv.context);
        System.out.println("};");
    }

    private Principal getCallerPrincipal() {
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc != null) {
            return sc.getCallerPrincipal();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

