/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.application;

import com.sun.ejb.Invocation;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.AccessControlEntryImpl;
import com.sun.enterprise.security.acl.AccessControlList;
import com.sun.enterprise.security.acl.AccessControlListImpl;
import com.sun.enterprise.security.acl.EJBResource;
import com.sun.enterprise.security.acl.ResourceAccessManager;
import com.sun.enterprise.security.acl.ResourceGuard;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.security.application.AuditLog;
import com.sun.enterprise.security.application.Authorizer;
import com.sun.enterprise.security.application.AuthorizerImpl;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class EJBSecurityManager
implements SecurityManager {
    private static final boolean debug = false;
    private ResourceAccessManager ram = null;
    private EjbDescriptor deploymentDescriptor = null;
    private ClassLoader loader = null;
    private Authorizer authorizer = null;
    private ServerConfiguration config = null;
    private static AuditLog audit = new AuditLog();
    private boolean loggingOn = false;
    private static final String AUDIT_ON = "auth.audit";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$application$EJBSecurityManager == null ? (class$com$sun$enterprise$security$application$EJBSecurityManager = EJBSecurityManager.class$("com.sun.enterprise.security.application.EJBSecurityManager")) : class$com$sun$enterprise$security$application$EJBSecurityManager);
    private Switch theSwitch;
    private RunAsIdentityDescriptor runAs = null;
    private Set unchecked;
    private Set excluded;
    static /* synthetic */ Class class$com$sun$enterprise$security$application$EJBSecurityManager;

    public EJBSecurityManager(ClassLoader loader, EjbDescriptor ejbDescriptor) {
        boolean runas;
        this.loader = loader;
        this.deploymentDescriptor = ejbDescriptor;
        if (this.deploymentDescriptor == null) {
            throw new IllegalArgumentException("Illegal Deployment Descriptor Information.");
        }
        this.config = ServerConfiguration.getConfiguration();
        String val = this.config.getProperty(AUDIT_ON);
        if (val.trim().equals("true")) {
            this.loggingOn = true;
        }
        boolean bl2 = runas = !this.deploymentDescriptor.getUsesCallerIdentity();
        if (runas) {
            this.runAs = this.deploymentDescriptor.getRunAsIdentity();
        }
        this.ram = new ResourceAccessManager();
        this.authorizer = new AuthorizerImpl(this.ram);
        this.theSwitch = Switch.getSwitch();
        this.initialize();
    }

    private String getAppName() {
        String appname = "default";
        Application app = this.deploymentDescriptor.getApplication();
        if (app != null) {
            appname = app.getName();
        }
        return appname;
    }

    private void initialize() {
        String appName = this.getAppName();
        EjbDescriptor des = this.deploymentDescriptor;
        RoleMapper.setRoleMapper(appName, des.getApplication().getRoleMapper());
        Enumeration ejbmethods = des.getMethods(this.loader).elements();
        while (ejbmethods.hasMoreElements()) {
            Method mthd = (Method)ejbmethods.nextElement();
            EJBResource r2 = new EJBResource(appName, mthd);
            AccessControlList mthdAcl = this.getAccessControlList(des, mthd);
            if (mthdAcl == null) continue;
            ResourceGuard rg = new ResourceGuard(mthdAcl);
            this.ram.protect(r2, rg);
        }
        this.copyUncheckedAndExcludedSets();
    }

    private void copyUncheckedAndExcludedSets() {
        Set ex2;
        this.excluded = Collections.synchronizedSet(new HashSet());
        this.unchecked = Collections.synchronizedSet(new HashSet());
        EjbDescriptor des = this.deploymentDescriptor;
        Set uc = des.getUncheckedMethodDescriptors();
        if (uc != null) {
            Set set = uc;
            synchronized (set) {
                Iterator iuc = uc.iterator();
                while (iuc.hasNext()) {
                    MethodDescriptor md = (MethodDescriptor)iuc.next();
                    Method mth = md.getMethod(des);
                    this.unchecked.add(mth);
                }
            }
        }
        if ((ex2 = des.getExcludedMethodDescriptors()) != null) {
            Set set = ex2;
            synchronized (set) {
                Iterator iex = ex2.iterator();
                while (iex.hasNext()) {
                    MethodDescriptor md = (MethodDescriptor)iex.next();
                    Method mth = md.getMethod(des);
                    this.excluded.add(mth);
                }
            }
        }
    }

    private AccessControlList getAccessControlList(EjbDescriptor ejbdes, Method m2) {
        AccessControlListImpl acl = null;
        Iterator methodPermissions = ejbdes.getMethodPermissionsFor(m2).iterator();
        if (methodPermissions.hasNext()) {
            acl = new AccessControlListImpl();
        } else {
            acl = new AccessControlListImpl();
            acl.addEntry(new AccessControlEntryImpl(RoleMapper.getDefaultRole()));
        }
        while (methodPermissions.hasNext()) {
            MethodPermission mp = (MethodPermission)methodPermissions.next();
            if (!mp.isRoleBased()) continue;
            AccessControlEntryImpl ace = new AccessControlEntryImpl(mp.getRole());
            acl.addEntry(ace);
        }
        return acl;
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    public static AuditLog getAuditLog() {
        return audit;
    }

    public boolean authorize(Invocation inv) {
        boolean ret;
        try {
            if (inv.securityPermissions == 2) {
                ret = false;
            } else if (inv.securityPermissions == 1) {
                ret = true;
            } else if (this.isExcluded(inv.method)) {
                ret = false;
            } else if (this.isUnchecked(inv.method)) {
                ret = true;
            } else if (this.areMethodPermissionsSet()) {
                boolean changed = false;
                SecurityContext old = SecurityContext.getCurrent();
                if (old == null) {
                    SecurityContext.init();
                    changed = true;
                }
                ret = this.authorizer.authorize(this.getAppName(), inv);
                if (changed) {
                    this.setSecurityContext(old);
                }
            } else {
                ret = true;
            }
        }
        catch (LoginException le) {
            ret = false;
        }
        if (this.loggingOn) {
            audit.log(inv, ret ? localStrings.getLocalString("enterprise.security.successful", "Successful.") : localStrings.getLocalString("enterprise.security.failed", "Failed."));
            if (!ret) {
                audit.flush();
            }
        }
        return ret;
    }

    public boolean isUnchecked(Method method) {
        if (this.unchecked == null) {
            return false;
        }
        return this.unchecked.contains(method);
    }

    public boolean isExcluded(Method method) {
        if (this.excluded == null) {
            return false;
        }
        return this.excluded.contains(method);
    }

    private boolean areMethodPermissionsSet() {
        EjbDescriptor des = this.deploymentDescriptor;
        boolean empty = des.getPermissionedMethodsByPermission().isEmpty();
        return !empty;
    }

    private void setSecurityContext(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    public void preInvoke(ComponentInvocation inv) {
        SecurityContext old = null;
        if (this.runAs != null) {
            old = SecurityContext.init();
            inv.setOldSecurityContext(old);
            this.loginForRunAs();
        }
    }

    public void postInvoke(ComponentInvocation inv) {
        if (this.runAs != null) {
            SecurityContext old = inv.getOldSecurityContext();
            this.setSecurityContext(old);
        }
    }

    private void loginForRunAs() {
        LoginContextDriver.loginPrincipal(this.runAs.getPrincipal());
    }

    public void audit(Invocation inv) {
        if (this.loggingOn) {
            audit.log(inv, "Audit");
        }
    }

    public boolean isCallerInRole(String role) {
        SecurityContext newsc = null;
        SecurityContext old = null;
        boolean ret = false;
        if (this.runAs != null) {
            try {
                InvocationManager im = this.theSwitch.getInvocationManager();
                ComponentInvocation ci2 = im.getCurrentInvocation();
                old = ci2.getOldSecurityContext();
                newsc = this.getSecurityContext();
                this.setSecurityContext(old);
                ret = this.authorizer.isCallerInRole(this.getAppName(), role);
                Object var8_8 = null;
                this.setSecurityContext(newsc);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.setSecurityContext(newsc);
                throw throwable;
            }
        } else {
            boolean changed = false;
            old = SecurityContext.getCurrent();
            if (old == null) {
                SecurityContext.init();
                changed = true;
            }
            ret = this.authorizer.isCallerInRole(this.getAppName(), role);
            if (changed) {
                this.setSecurityContext(old);
            }
        }
        return ret;
    }

    public Principal getCallerPrincipal() {
        SecurityContext old = null;
        boolean changed = false;
        if (this.runAs != null) {
            InvocationManager im = this.theSwitch.getInvocationManager();
            ComponentInvocation ci2 = im.getCurrentInvocation();
            old = ci2.getOldSecurityContext();
        } else {
            old = this.getSecurityContext();
            if (old == null) {
                old = SecurityContext.init();
                changed = true;
            }
        }
        if (old != null) {
            Principal prin = old.getCallerPrincipal();
            if (changed) {
                this.setSecurityContext(null);
            }
            return prin;
        }
        throw new IllegalStateException("Bad or improper security context.");
    }

    public void destroy() {
        String appName = this.getAppName();
        RoleMapper.removeRoleMapper(appName);
        Enumeration ejbmethods = this.deploymentDescriptor.getMethods(this.loader).elements();
        while (ejbmethods.hasMoreElements()) {
            Method mthd = (Method)ejbmethods.nextElement();
            EJBResource r2 = new EJBResource(appName, mthd);
            this.ram.unprotect(r2);
        }
        this.deploymentDescriptor = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

