/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth;

import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.AuthenticationInfoImpl;
import com.sun.enterprise.security.auth.AuthenticationStatusImpl;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.LocalCredentialsImpl;
import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.login.ServerLoginCallbackHandler;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import sun.security.x509.X500Name;

public class LoginContextDriver {
    private static final boolean debug = false;
    public static String REALMNAME = "default";
    public static String CERT_REALMNAME = "certificate";
    public static String AUTHMETHOD = "password";
    private static String SERVER_JAAS_NAME = "ServerLoginDefault";
    private static String CLIENT_JAAS_PASSWORD = "default";
    private static String CLIENT_JAAS_CERTIFICATE = "certificate";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$LoginContextDriver == null ? (class$com$sun$enterprise$security$auth$LoginContextDriver = LoginContextDriver.class$("com.sun.enterprise.security.auth.LoginContextDriver")) : class$com$sun$enterprise$security$auth$LoginContextDriver);
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$LoginContextDriver;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$X509CertificateCredential;

    public static void login(String username, String password) {
        final Subject fs = new Subject();
        final PasswordCredential pc = new PasswordCredential(username, password, REALMNAME);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fs.getPrivateCredentials().add(pc);
                return fs;
            }
        });
        LoginContextDriver.login(fs, class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
    }

    public static void login(Subject subject, Class cls) throws LoginException {
        Credentials credentials = null;
        Set credset = null;
        final Subject fs = subject;
        if (cls.equals(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential)) {
            credset = (Set)AccessController.doPrivileged(new PrivilegedAction(){
                static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;

                public Object run() {
                    return fs.getPrivateCredentials(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = 2.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            final Iterator iter = credset.iterator();
            if (!iter.hasNext()) {
                return;
            }
            Object obj = null;
            try {
                obj = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iter.next();
                    }
                });
            }
            catch (Exception e10) {
                e10.printStackTrace();
            }
            if (obj instanceof PasswordCredential) {
                PasswordCredential p2 = obj;
                String user = p2.getUser();
                String pwd = p2.getPassword();
                ServerLoginCallbackHandler slch = new ServerLoginCallbackHandler(user, pwd);
                try {
                    LoginContext lg = new LoginContext(SERVER_JAAS_NAME, subject, slch);
                    lg.login();
                    try {
                        Object ob = AccessController.doPrivileged(new PrivilegedAction(){
                            static /* synthetic */ Class class$com$sun$enterprise$security$auth$LocalCredentialsImpl;

                            public Object run() {
                                Credentials cred = null;
                                Set credset = fs.getPublicCredentials(class$com$sun$enterprise$security$auth$LocalCredentialsImpl == null ? (class$com$sun$enterprise$security$auth$LocalCredentialsImpl = 4.class$("com.sun.enterprise.security.auth.LocalCredentialsImpl")) : class$com$sun$enterprise$security$auth$LocalCredentialsImpl);
                                Iterator it = credset.iterator();
                                if (it.hasNext()) {
                                    cred = (Credentials)it.next();
                                    fs.getPublicCredentials().remove(cred);
                                    return cred;
                                }
                                return cred;
                            }

                            static /* synthetic */ Class class$(String x0) {
                                try {
                                    return Class.forName(x0);
                                }
                                catch (ClassNotFoundException x1) {
                                    throw new NoClassDefFoundError(x1.getMessage());
                                }
                            }
                        });
                        credentials = (Credentials)ob;
                    }
                    catch (Exception e11) {
                        e11.printStackTrace();
                    }
                }
                catch (Exception e12) {
                    e12.printStackTrace();
                    throw new LoginException(e12.toString());
                }
                LoginContextDriver.setSecurityContext(user, fs, credentials);
                return;
            }
            throw new LoginException("Incorrect Credentials object");
        }
        credset = subject.getPublicCredentials(cls);
        final Iterator iter = credset.iterator();
        if (iter.hasNext()) {
            Object obj = null;
            try {
                obj = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iter.next();
                    }
                });
            }
            catch (Exception e13) {
                e13.printStackTrace();
            }
            if (obj instanceof X509CertificateCredential) {
                X509CertificateCredential xp = obj;
                String user = xp.getAlias();
                credentials = LoginContextDriver.generateDummyCredential(user, CERT_REALMNAME, AUTHMETHOD);
                LoginContextDriver.setSecurityContext(user, fs, credentials);
                return;
            }
            if (obj instanceof AnonCredential) {
                SecurityContext.setUnauthenticatedContext();
            } else {
                String user = "";
                if (obj instanceof GSSUPName) {
                    user = ((GSSUPName)obj).getUser();
                } else if (obj instanceof X500Name) {
                    user = ((X500Name)obj).getName();
                }
                credentials = LoginContextDriver.generateDummyCredential(user, REALMNAME, AUTHMETHOD);
                LoginContextDriver.setSecurityContext(user, subject, credentials);
                return;
            }
        }
    }

    public static Subject doClientLogin(int type, CallbackHandler jaasHandler) throws LoginException {
        final CallbackHandler handler = jaasHandler;
        final Subject subject = new Subject();
        if (type == 1) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext(CLIENT_JAAS_PASSWORD, subject, handler);
                        lg.login();
                    }
                    catch (javax.security.auth.login.LoginException e10) {
                        throw new LoginException(e10.toString());
                    }
                    return null;
                }
            });
            LoginContextDriver.postClientAuth(subject, class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            return subject;
        }
        if (type == 2) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext(CLIENT_JAAS_CERTIFICATE, subject, handler);
                        lg.login();
                    }
                    catch (javax.security.auth.login.LoginException e10) {
                        throw new LoginException(e10.toString());
                    }
                    return null;
                }
            });
            LoginContextDriver.postClientAuth(subject, class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (class$com$sun$enterprise$security$auth$login$X509CertificateCredential = LoginContextDriver.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : class$com$sun$enterprise$security$auth$login$X509CertificateCredential);
            return subject;
        }
        if (type == 3) {
            AccessController.doPrivileged(new PrivilegedAction(){
                static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;
                static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$X509CertificateCredential;

                public Object run() {
                    try {
                        LoginContext lgup = new LoginContext(CLIENT_JAAS_PASSWORD, subject, handler);
                        LoginContext lgc = new LoginContext(CLIENT_JAAS_CERTIFICATE, subject, handler);
                        lgup.login();
                        LoginContextDriver.postClientAuth(subject, 8.class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (8.class$com$sun$enterprise$security$auth$login$PasswordCredential = 8.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : 8.class$com$sun$enterprise$security$auth$login$PasswordCredential);
                        lgc.login();
                        LoginContextDriver.postClientAuth(subject, 8.class$com$sun$enterprise$security$auth$login$X509CertificateCredential == null ? (8.class$com$sun$enterprise$security$auth$login$X509CertificateCredential = 8.class$("com.sun.enterprise.security.auth.login.X509CertificateCredential")) : 8.class$com$sun$enterprise$security$auth$login$X509CertificateCredential);
                    }
                    catch (javax.security.auth.login.LoginException e10) {
                        throw new LoginException(e10.toString());
                    }
                    return null;
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            return subject;
        }
        AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$PasswordCredential;

            public Object run() {
                try {
                    LoginContext lg = new LoginContext(CLIENT_JAAS_PASSWORD, subject, handler);
                    lg.login();
                    LoginContextDriver.postClientAuth(subject, 9.class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (9.class$com$sun$enterprise$security$auth$login$PasswordCredential = 9.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : 9.class$com$sun$enterprise$security$auth$login$PasswordCredential);
                }
                catch (javax.security.auth.login.LoginException e10) {
                    throw new LoginException(e10.toString());
                }
                return null;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        return subject;
    }

    private static void postClientAuth(Subject subject, Class clazz) {
        final Class clas = clazz;
        final Subject fs = subject;
        Set credset = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return fs.getPrivateCredentials(clas);
            }
        });
        final Iterator iter = credset.iterator();
        while (iter.hasNext()) {
            Object obj = null;
            try {
                obj = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iter.next();
                    }
                });
            }
            catch (Exception e10) {
                e10.printStackTrace();
            }
            if (obj instanceof PasswordCredential) {
                PasswordCredential p2 = obj;
                String user = p2.getUser();
                String realm = p2.getRealm();
                Credentials cred = LoginContextDriver.generateDummyCredential(user, realm, AUTHMETHOD);
                LoginContextDriver.setClientSecurityContext(user, fs, cred);
                return;
            }
            if (!(obj instanceof X509CertificateCredential)) continue;
            X509CertificateCredential p3 = obj;
            String user = p3.getAlias();
            String realm = p3.getRealm();
            Credentials cred = LoginContextDriver.generateDummyCredential(user, realm, AUTHMETHOD);
            LoginContextDriver.setClientSecurityContext(user, fs, cred);
            return;
        }
    }

    public static Credentials generateDummyCredential(String user, String realm, String authMethod) {
        int status = 0;
        LocalCredentialsImpl cred = new LocalCredentialsImpl();
        AuthenticationInfoImpl ainfo = new AuthenticationInfoImpl(user, REALMNAME, true);
        ainfo.setAttribute("Groups", new Privilege[0]);
        AuthenticationStatusImpl as2 = new AuthenticationStatusImpl(user, AUTHMETHOD, REALMNAME, status);
        cred.setAuthenticationStatus(as2);
        cred.addAuthenticationInfo(ainfo);
        return cred;
    }

    public static void loginPrincipal(String username) throws LoginException {
        final Subject s2 = new Subject();
        final GSSUPName name = new GSSUPName(username, REALMNAME);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                s2.getPublicCredentials().add(name);
                return null;
            }
        });
        Credentials cred = LoginContextDriver.generateDummyCredential(username, REALMNAME, AUTHMETHOD);
        LoginContextDriver.setSecurityContext(username, s2, cred);
    }

    public static void logout() throws LoginException {
        LoginContextDriver.unsetSecurityContext();
    }

    private static void setClientSecurityContext(String username, Subject subject, Credentials credentials) {
        ClientSecurityContext securityContext = new ClientSecurityContext(username, credentials, subject);
        ClientSecurityContext.setCurrent(securityContext);
    }

    private static void unsetClientSecurityContext() {
        ClientSecurityContext.setCurrent(null);
    }

    private static void setSecurityContext(String userName, Subject subject, Credentials credentials) {
        SecurityContext securityContext = new SecurityContext(userName, credentials, subject);
        SecurityContext.setCurrent(securityContext);
    }

    private static void unsetSecurityContext() {
        SecurityContext.setCurrent(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

