/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ClientPasswordLoginModule
implements LoginModule {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$login$ClientPasswordLoginModule == null ? (class$com$sun$enterprise$security$auth$login$ClientPasswordLoginModule = ClientPasswordLoginModule.class$("com.sun.enterprise.security.auth.login.ClientPasswordLoginModule")) : class$com$sun$enterprise$security$auth$login$ClientPasswordLoginModule);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private final PasswordCredential passwordCredential = null;
    private PrincipalImpl userPrincipal;
    public static String LOGIN_NAME = "j2eelogin.name";
    public static String LOGIN_PASSWORD = "j2eelogin.password";
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$ClientPasswordLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            String failure = localStrings.getLocalString("login.nocallback", "Error: no CallbackHandler available to garner authentication information from the user");
            throw new LoginException(failure);
        }
        String uname = System.getProperty(LOGIN_NAME);
        if (uname != null) {
            char[] dest;
            this.username = new String(uname);
            String pswd = System.getProperty(LOGIN_PASSWORD);
            if (pswd == null) {
                dest = new char[]{};
                this.password = new char[0];
            } else {
                int length = pswd.length();
                dest = new char[length];
                pswd.getChars(0, length, dest, 0);
                this.password = new char[length];
            }
            System.arraycopy(dest, 0, this.password, 0, dest.length);
        } else {
            Callback[] callbacks = new Callback[]{new NameCallback(localStrings.getLocalString("login.username", "ClientPasswordModule username: ")), new PasswordCallback(localStrings.getLocalString("login.password", "ClientPasswordModule password: "), false)};
            try {
                this.callbackHandler.handle(callbacks);
                this.username = ((NameCallback)callbacks[0]).getName();
                if (this.username == null) {
                    String fail = localStrings.getLocalString("login.nousername", "No user specified");
                    throw new LoginException(fail);
                }
                char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
                if (tmpPassword == null) {
                    tmpPassword = new char[]{};
                }
                this.password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
                ((PasswordCallback)callbacks[1]).clearPassword();
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.toString());
            }
            catch (UnsupportedCallbackException uce) {
                String nocallback = localStrings.getLocalString("login.callback", "Error: Callback not available to garner authentication information from user(CallbackName):");
                throw new LoginException(nocallback + uce.getCallback().toString());
            }
        }
        if (this.debug) {
            System.out.println("\t\t[ClientPasswordLoginModule] user entered username: " + this.username);
            System.out.print("\t\t[ClientPasswordLoginModule] user entered password: ");
            int i2 = 0;
            while (i2 < this.password.length) {
                System.out.print(this.password[i2]);
                ++i2;
            }
            System.out.println();
        }
        if (this.debug) {
            System.out.println("\t\t[ClientPasswordLoginModule] authentication succeeded");
        }
        this.succeeded = true;
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[ClientPasswordLoginModule] added PrincipalImpl to Subject");
        }
        String realm = LoginContextDriver.REALMNAME;
        PasswordCredential pc = new PasswordCredential(this.username, new String(this.password), realm);
        if (!this.subject.getPrivateCredentials().contains(pc)) {
            this.subject.getPrivateCredentials().add(pc);
        }
        this.username = null;
        int i2 = 0;
        while (i2 < this.password.length) {
            this.password[i2] = 32;
            ++i2;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                int i2 = 0;
                while (i2 < this.password.length) {
                    this.password[i2] = 32;
                    ++i2;
                }
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            int i2 = 0;
            while (i2 < this.password.length) {
                this.password[i2] = 32;
                ++i2;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

