/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import com.sun.enterprise.security.auth.AuthenticationStatusImpl;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.LocalCredentialsImpl;
import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ServerPasswordLoginModule
implements LoginModule {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$login$ServerPasswordLoginModule == null ? (class$com$sun$enterprise$security$auth$login$ServerPasswordLoginModule = ServerPasswordLoginModule.class$("com.sun.enterprise.security.auth.login.ServerPasswordLoginModule")) : class$com$sun$enterprise$security$auth$login$ServerPasswordLoginModule);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private PrincipalImpl userPrincipal;
    private String realmName = "default";
    private String authMethod = "password";
    private Credentials cred = new LocalCredentialsImpl();
    private AuthenticationStatus authenticationStatus;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$login$ServerPasswordLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no Server CallbackHandler available to garner authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("DUMMY"), new PasswordCallback("DUMMY", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        if (this.debug) {
            System.out.println("\t\t[ServerPasswordLoginModule] user entered username: " + this.username);
            System.out.print("\t\t[ServerPasswordLoginModule] user entered password: ");
            int i2 = 0;
            while (i2 < this.password.length) {
                System.out.print(this.password[i2]);
                ++i2;
            }
            System.out.println();
        }
        this.authenticationStatus = this.authenticate();
        if (this.authenticationStatus.getStatus() == 0) {
            if (this.debug) {
                System.out.println("\t\t[ServerPasswordLoginModule] authentication succeeded");
            }
            this.succeeded = true;
            return true;
        }
        if (this.debug) {
            System.out.println("\t\t[ServerPasswordLoginModule] authentication failed");
        }
        this.succeeded = false;
        this.username = null;
        int i3 = 0;
        while (i3 < this.password.length) {
            this.password[i3] = 32;
            ++i3;
        }
        this.password = null;
        throw new FailedLoginException("Password Incorrect");
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[SharedPasswordLoginModule] added PrincipalImpl to Subject");
        }
        if (!this.subject.getPublicCredentials().contains(this.cred)) {
            this.subject.getPublicCredentials().add(this.cred);
        }
        this.username = null;
        int i2 = 0;
        while (i2 < this.password.length) {
            this.password[i2] = 32;
            ++i2;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                int i2 = 0;
                while (i2 < this.password.length) {
                    this.password[i2] = 32;
                    ++i2;
                }
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPublicCredentials().remove(this.cred);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            int i2 = 0;
            while (i2 < this.password.length) {
                this.password[i2] = 32;
                ++i2;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        return true;
    }

    AuthenticationStatus authenticate() {
        try {
            if (this.debug) {
                System.out.println(" In ServerPasswordLoginModule.authenticate!");
            }
            Realm realm = Realm.getInstance(this.realmName);
            AuthenticationHandler handler = realm.getAuthenticationHandler();
            String pass = new String(this.password);
            this.authenticationStatus = handler.doAuthentication(this.cred, this.username, pass.getBytes());
        }
        catch (Exception e10) {
            this.authenticationStatus = new AuthenticationStatusImpl(this.username, this.realmName, this.authMethod, 1);
        }
        return this.authenticationStatus;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

