/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import java.security.cert.X509Certificate;

public class X509CertificateCredential {
    private X509Certificate[] certChain;
    private String realm;
    private String alias;

    public X509CertificateCredential(X509Certificate[] certChain, String alias, String realm) {
        this.certChain = certChain;
        this.alias = alias;
        this.realm = realm;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getRealm() {
        return this.realm;
    }

    public X509Certificate[] getX509CertificateChain() {
        return this.certChain;
    }

    public boolean equals(Object o2) {
        X509CertificateCredential pc;
        if (o2 instanceof X509CertificateCredential && (pc = (X509CertificateCredential)o2).getRealm().equals(this.realm) && pc.getAlias().equals(this.alias)) {
            X509Certificate[] certs = pc.getX509CertificateChain();
            int i2 = 0;
            while (i2 < certs.length) {
                if (!certs[i2].equals(this.certChain[i2])) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.certChain.hashCode() + this.realm.hashCode() + this.alias.hashCode();
    }

    public String toString() {
        String s2 = "Realm=" + this.realm;
        s2 = s2 + " alias=" + this.alias;
        s2 = s2 + " X509Certificate=" + this.certChain;
        return s2;
    }
}

