/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.certificate.CertificateAuthHandler;
import com.sun.enterprise.security.auth.realm.certificate.CertificateStore;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public final class CertificateRealm
extends Realm {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$realm$certificate$CertificateRealm == null ? (class$com$sun$enterprise$security$auth$realm$certificate$CertificateRealm = CertificateRealm.class$("com.sun.enterprise.security.auth.realm.certificate.CertificateRealm")) : class$com$sun$enterprise$security$auth$realm$certificate$CertificateRealm);
    private static String CERTSTORE_FILE_NAME = "certstore";
    private static String CERTSTORE_DIR_PROP = "directory";
    private static String AUTH_TYPE = "certificate";
    private boolean initted = false;
    private AuthenticationHandler authHandler = null;
    private CertificateStore certstore = null;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$realm$certificate$CertificateRealm;

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames() throws BadRealmException {
        Vector v2 = new Vector();
        return v2.elements();
    }

    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        if (!this.initted) {
            this.initted = true;
            super.init(props);
            String dirname = FileUtil.getAbsolutePath(props.getProperty(CERTSTORE_DIR_PROP));
            this.certstore = new CertificateStore(this, dirname + File.separator + CERTSTORE_FILE_NAME);
            this.authHandler = new CertificateAuthHandler(this);
        }
    }

    public Enumeration getUserNames() {
        return this.certstore.getUsers();
    }

    public User getUser(String alias) throws NoSuchUserException {
        return this.certstore.getUser(alias);
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    public void createUser(String alias, byte[] cert) throws BadRealmException {
        CertificateStore certificateStore = this.certstore;
        synchronized (certificateStore) {
            try {
                User u2 = this.getUser(alias);
                String message = localStrings.getLocalString("certificate.duplicate_user", "There is already an alias named {0}.", new Object[]{alias});
                throw new BadRealmException(message);
            }
            catch (NoSuchUserException e10) {
                this.certstore.addUser(alias, cert);
            }
        }
    }

    public void deleteUser(String alias) throws BadRealmException, NoSuchUserException {
        CertificateStore certificateStore = this.certstore;
        synchronized (certificateStore) {
            User u2 = this.getUser(alias);
            this.certstore.removeUser(alias);
        }
    }

    public void refresh() throws BadRealmException {
        CertificateRealm certificateRealm = this;
        synchronized (certificateRealm) {
            try {
                this.certstore.read();
            }
            catch (Exception e10) {
                throw new BadRealmException(e10.getMessage());
            }
        }
    }

    public Certificate[] getCertificates() throws NoSuchUserException {
        return this.certstore.getCertificates();
    }

    public Enumeration getGroupNames(String username) throws InvalidOperationException, NoSuchUserException {
        throw new InvalidOperationException(" Certificate Realm does not support method  : getGroupNames (username)");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

