/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.sharedpassword;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.util.TypeUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

final class FilePassword {
    private static final String DELIMITER_SYMBOL = "::";
    private static final String TEMP_FILE = "passwd.tmp";
    private static final String DEFAULT_USER = "auth.default.principal.name";
    private static final String DEFAULT_PASS = "auth.default.principal.password";
    private Hashtable passwordTable;
    private Hashtable groupsTable;
    private Hashtable groupsToUsersTable;
    private File file;
    private String defaultUser;
    private String defaultPassword;
    private String comma = ",";

    FilePassword(String fileName) throws BadRealmException {
        try {
            ServerConfiguration config = ServerConfiguration.getConfiguration();
            this.file = new File(fileName);
            this.defaultUser = config.getProperty(DEFAULT_USER, "guest").trim();
            this.defaultPassword = config.getProperty(DEFAULT_PASS, "guest123").trim();
            this.read();
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new BadRealmException(e10.getMessage());
        }
    }

    private void addDefaultUser() {
        this.passwordTable.put(this.defaultUser, this.defaultPassword);
        this.groupsTable.put(this.defaultUser, "");
    }

    /*
     * WARNING - void declaration
     */
    void read() throws IOException {
        String line;
        String user = null;
        String groups = null;
        String passwd = null;
        String realPasswd = null;
        BASE64Decoder decoder = new BASE64Decoder();
        FileInputStream f2 = new FileInputStream(this.file);
        BufferedReader in = new BufferedReader(new InputStreamReader(f2));
        this.passwordTable = new Hashtable();
        this.groupsTable = new Hashtable();
        this.groupsToUsersTable = new Hashtable();
        while ((line = in.readLine()) != null) {
            void var5_8;
            StringTokenizer st = new StringTokenizer((String)var5_8, DELIMITER_SYMBOL);
            if (st.hasMoreTokens()) {
                user = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                passwd = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                groups = st.nextToken();
            }
            if (passwd != null) {
                byte[] realPassBytes = decoder.decodeBuffer(passwd);
                realPasswd = new String(realPassBytes);
            }
            if (user != null && realPasswd != null) {
                this.passwordTable.put(user, realPasswd);
            }
            this.groupsTable.put(user, groups);
            String[] groupArray = TypeUtil.stringToArray(groups, this.comma);
            this.addInGroupsToUsersTable(groupArray, user);
        }
        f2.close();
        this.addDefaultUser();
    }

    private void rewrite() throws IOException {
        File temp = new File(this.file.getParent(), TEMP_FILE);
        FileOutputStream f2 = new FileOutputStream(temp);
        PrintWriter pf = new PrintWriter(new OutputStreamWriter(f2));
        BASE64Encoder encoder = new BASE64Encoder();
        Enumeration e10 = this.passwordTable.keys();
        while (e10.hasMoreElements()) {
            String username = (String)e10.nextElement();
            if (username.equals(this.defaultUser)) continue;
            String password = (String)this.passwordTable.get(username);
            String groups = (String)this.groupsTable.get(username);
            int len = password.length();
            byte[] b10 = password.getBytes();
            String passwd64 = encoder.encodeBuffer(b10);
            pf.println(username.trim() + DELIMITER_SYMBOL + passwd64.trim() + DELIMITER_SYMBOL + groups.trim());
        }
        this.addDefaultUser();
        FilePassword filePassword = this;
        synchronized (filePassword) {
            pf.close();
            this.file.delete();
            temp.renameTo(this.file);
        }
    }

    synchronized String getPasswd(String user) throws NoSuchUserException {
        if (this.passwordTable.containsKey(user)) {
            return (String)this.passwordTable.get(user);
        }
        throw new NoSuchUserException(user);
    }

    synchronized String[] getGroups(String user) throws NoSuchUserException {
        if (this.groupsTable.containsKey(user)) {
            return TypeUtil.stringToArray((String)this.groupsTable.get(user), this.comma);
        }
        throw new NoSuchUserException(user);
    }

    synchronized void addUser(String user, String password, String[] groups) throws BadRealmException {
        if (password == null || groups == null) {
            this.passwordTable.remove(user);
            this.groupsTable.remove(user);
        } else {
            this.passwordTable.put(user, password);
            this.groupsTable.put(user, TypeUtil.arrayToString(groups, this.comma));
            this.addInGroupsToUsersTable(groups, user);
        }
        try {
            this.rewrite();
        }
        catch (Exception e10) {
            throw new BadRealmException(e10.getMessage());
        }
    }

    synchronized void removeUser(String user) throws BadRealmException {
        this.passwordTable.remove(user);
        try {
            String[] groupsArray = this.getGroups(user);
            this.groupsTable.remove(user);
            this.removeFromGroupsToUsersTable(groupsArray, user);
        }
        catch (NoSuchUserException nsue) {
            // empty catch block
        }
        try {
            this.rewrite();
        }
        catch (Exception e10) {
            throw new BadRealmException(e10.getMessage());
        }
    }

    private synchronized void addInGroupsToUsersTable(String[] groups, String user) {
        if (user == null || groups == null) {
            return;
        }
        int i2 = 0;
        while (i2 < groups.length) {
            String group = groups[i2];
            if (!this.groupsToUsersTable.containsKey(group)) {
                this.groupsToUsersTable.put(group, user);
            } else {
                String listOfUsers = (String)this.groupsToUsersTable.get(group);
                if (listOfUsers.indexOf(user) == -1) {
                    this.groupsToUsersTable.put(group, listOfUsers + this.comma + user);
                }
            }
            ++i2;
        }
    }

    private synchronized void removeFromGroupsToUsersTable(String[] groups, String user) {
        if (user == null || groups == null) {
            return;
        }
        int i2 = 0;
        while (i2 < groups.length) {
            String listOfUsers;
            String group = groups[i2];
            if (this.groupsToUsersTable.containsKey(group) && (listOfUsers = (String)this.groupsToUsersTable.get(group)).indexOf(user) != -1) {
                String[] usersList = TypeUtil.stringToArray(listOfUsers, this.comma);
                if (usersList.length == 1) {
                    this.groupsToUsersTable.remove(group);
                    return;
                }
                String[] finalList = new String[usersList.length - 1];
                int countForFinalList = 0;
                int j2 = 0;
                while (j2 < usersList.length) {
                    if (!usersList[j2].equals(user)) {
                        finalList[countForFinalList++] = new String(usersList[j2]);
                    }
                    ++j2;
                }
                this.groupsToUsersTable.remove(group);
                this.groupsToUsersTable.put(group, TypeUtil.arrayToString(finalList, this.comma));
            }
            ++i2;
        }
    }

    public String getUsersInGroup(String group) {
        if (this.groupsToUsersTable.containsKey(group)) {
            return (String)this.groupsToUsersTable.get(group);
        }
        return null;
    }

    public synchronized Enumeration users() {
        return this.passwordTable.keys();
    }
}

